/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.tosfs.util.JsonCodec;
import org.apache.hadoop.fs.tosfs.util.Serializer;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hadoop.thirdparty.com.google.common.base.Throwables;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.StringUtils;

public class SuccessData
implements Serializer {
    private static final JsonCodec<SuccessData> CODEC = new JsonCodec<SuccessData>(SuccessData.class);
    private String name;
    private boolean success = true;
    private long timestamp;
    private String date;
    private String hostname;
    private String committer;
    private String description;
    private String jobId;
    private final List<String> filenames = new ArrayList<String>();
    private final Map<String, String> diagnostics = new HashMap<String, String>();

    public SuccessData() {
    }

    public SuccessData(Builder builder) {
        this.name = builder.name;
        this.success = builder.success;
        this.timestamp = builder.timestamp;
        this.date = builder.date;
        this.hostname = builder.hostname;
        this.committer = builder.committer;
        this.description = builder.description;
        this.jobId = builder.jobId;
        this.filenames.addAll(builder.filenames);
    }

    public String name() {
        return this.name;
    }

    public boolean success() {
        return this.success;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String date() {
        return this.date;
    }

    public String hostname() {
        return this.hostname;
    }

    public String committer() {
        return this.committer;
    }

    public String description() {
        return this.description;
    }

    public String jobId() {
        return this.jobId;
    }

    public Map<String, String> diagnostics() {
        return this.diagnostics;
    }

    public List<String> filenames() {
        return this.filenames;
    }

    public void recordJobFailure(Throwable thrown) {
        this.success = false;
        String stacktrace = Throwables.getStackTraceAsString((Throwable)thrown);
        this.addDiagnosticInfo("exception", thrown.toString());
        this.addDiagnosticInfo("stacktrace", stacktrace);
    }

    public void addDiagnosticInfo(String key, String value) {
        this.diagnostics.put(key, value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("success", this.success).add("timestamp", this.timestamp).add("date", (Object)this.date).add("hostname", (Object)this.hostname).add("committer", (Object)this.committer).add("description", (Object)this.description).add("jobId", (Object)this.jobId).add("filenames", (Object)StringUtils.join((CharSequence)",", this.filenames)).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public byte[] serialize() throws IOException {
        return CODEC.toBytes(this);
    }

    public static SuccessData deserialize(byte[] data) throws IOException {
        return CODEC.fromBytes(data);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.success, this.timestamp, this.date, this.hostname, this.committer, this.description, this.jobId, this.filenames);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SuccessData)) {
            return false;
        }
        SuccessData that = (SuccessData)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.success, that.success) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.date, that.date) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.committer, that.committer) && Objects.equals(this.description, that.description) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.filenames, that.filenames);
    }

    public static class Builder {
        private String name = SuccessData.class.getName();
        private boolean success = true;
        private long timestamp;
        private String date;
        private String hostname;
        private String committer;
        private String description;
        private String jobId;
        private final List<String> filenames = Lists.newArrayList();

        public Builder setName(String nameInput) {
            this.name = nameInput;
            return this;
        }

        public Builder setSuccess(boolean successInput) {
            this.success = successInput;
            return this;
        }

        public Builder setTimestamp(long timestampInput) {
            this.timestamp = timestampInput;
            return this;
        }

        public Builder setDate(String dateInput) {
            this.date = dateInput;
            return this;
        }

        public Builder setHostname(String hostnameInput) {
            this.hostname = hostnameInput;
            return this;
        }

        public Builder setCommitter(String committerInput) {
            this.committer = committerInput;
            return this;
        }

        public Builder setDescription(String descriptionInput) {
            this.description = descriptionInput;
            return this;
        }

        public Builder setJobId(String jobIdInput) {
            this.jobId = jobIdInput;
            return this;
        }

        public Builder addFileNames(Iterable<String> newFileNamesInput) {
            if (newFileNamesInput != null) {
                Iterables.addAll(this.filenames, newFileNamesInput);
            }
            return this;
        }

        public SuccessData build() {
            return new SuccessData(this);
        }
    }
}

