/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.commit;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.tosfs.commit.CommitUtils;
import org.apache.hadoop.fs.tosfs.commit.Pending;
import org.apache.hadoop.fs.tosfs.util.JsonCodec;
import org.apache.hadoop.fs.tosfs.util.Serializer;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Lists;

public class PendingSet
implements Serializer {
    private static final JsonCodec<PendingSet> CODEC = new JsonCodec<PendingSet>(PendingSet.class);
    private String jobId;
    private List<Pending> pendings;
    private Map<String, String> extraData;

    public PendingSet() {
    }

    public PendingSet(String jobId) {
        this(jobId, Lists.newArrayList());
    }

    public PendingSet(String jobId, List<Pending> pendings) {
        this.jobId = jobId;
        this.pendings = Lists.newArrayList(pendings);
        this.extraData = Maps.newHashMap();
    }

    public PendingSet addAll(Iterable<Pending> items) {
        Iterables.addAll(this.pendings, items);
        return this;
    }

    public PendingSet add(Pending pending) {
        this.pendings.add(pending);
        return this;
    }

    public PendingSet addExtraData(String key, String val) {
        this.extraData.put(key, val);
        return this;
    }

    public String jobId() {
        return this.jobId;
    }

    public List<Pending> commits() {
        return this.pendings;
    }

    public Map<String, String> extraData() {
        return this.extraData;
    }

    public int size() {
        return this.pendings.size();
    }

    @Override
    public byte[] serialize() throws IOException {
        return CODEC.toBytes(this);
    }

    public static PendingSet deserialize(byte[] data) {
        try {
            return CODEC.fromBytes(data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static PendingSet deserialize(FileSystem fs, FileStatus f) {
        try {
            return PendingSet.deserialize(CommitUtils.load(fs, f.getPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.pendings, this.extraData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PendingSet)) {
            return false;
        }
        PendingSet that = (PendingSet)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.pendings, that.pendings) && Objects.equals(this.extraData, that.extraData);
    }
}

