/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.commit;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.tosfs.object.Part;
import org.apache.hadoop.fs.tosfs.util.JsonCodec;
import org.apache.hadoop.fs.tosfs.util.Serializer;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;

public class Pending
implements Serializer {
    private static final JsonCodec<Pending> CODEC = new JsonCodec<Pending>(Pending.class);
    private String bucket;
    private String destKey;
    private String uploadId;
    private long length;
    private long createdTimestamp;
    private List<Part> parts;

    public Pending() {
    }

    public Pending(String bucket, String destKey, String uploadId, long length, long createdTimestamp, List<Part> parts) {
        this.bucket = bucket;
        this.destKey = destKey;
        this.uploadId = uploadId;
        this.length = length;
        this.createdTimestamp = createdTimestamp;
        this.parts = parts;
    }

    public String bucket() {
        return this.bucket;
    }

    public String destKey() {
        return this.destKey;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public long length() {
        return this.length;
    }

    public long createdTimestamp() {
        return this.createdTimestamp;
    }

    public List<Part> parts() {
        return this.parts;
    }

    @Override
    public byte[] serialize() throws IOException {
        return CODEC.toBytes(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("destKey", (Object)this.destKey).add("uploadId", (Object)this.uploadId).add("length", this.length).add("createdTimestamp", this.createdTimestamp).add("uploadParts", (Object)StringUtils.join(this.parts, (String)",")).toString();
    }

    public static Pending deserialize(byte[] data) throws IOException {
        return CODEC.fromBytes(data);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.destKey, this.uploadId, this.length, this.createdTimestamp, this.parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pending)) {
            return false;
        }
        Pending that = (Pending)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.destKey, that.destKey) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals(this.length, that.length) && Objects.equals(this.createdTimestamp, that.createdTimestamp) && Objects.equals(this.parts, that.parts);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String bucket;
        private String destKey;
        private String uploadId;
        private long length;
        private long createdTimestamp;
        private final List<Part> parts = Lists.newArrayList();

        public Builder setBucket(String bucketInput) {
            this.bucket = bucketInput;
            return this;
        }

        public Builder setDestKey(String destKeyInput) {
            this.destKey = destKeyInput;
            return this;
        }

        public Builder setUploadId(String uploadIdInput) {
            this.uploadId = uploadIdInput;
            return this;
        }

        public Builder setLength(long lengthInput) {
            this.length = lengthInput;
            return this;
        }

        public Builder setCreatedTimestamp(long createdTimestampInput) {
            this.createdTimestamp = createdTimestampInput;
            return this;
        }

        public Builder addParts(List<Part> partsInput) {
            this.parts.addAll(partsInput);
            return this;
        }

        public Pending build() {
            Preconditions.checkArgument((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.bucket}), (Object)"Empty bucket");
            Preconditions.checkArgument((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.destKey}), (Object)"Empty object destination key");
            Preconditions.checkArgument((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.uploadId}), (Object)"Empty uploadId");
            Preconditions.checkArgument((this.length >= 0L ? 1 : 0) != 0, (String)"Invalid length: %s", (Object[])new Object[]{this.length});
            this.parts.forEach(part -> Preconditions.checkArgument((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{part.eTag(), "Empty etag"})));
            return new Pending(this.bucket, this.destKey, this.uploadId, this.length, this.createdTimestamp, this.parts);
        }
    }
}

