/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.tosfs.commit.CommitUtils;
import org.apache.hadoop.fs.tosfs.commit.Pending;
import org.apache.hadoop.fs.tosfs.object.ObjectOutputStream;
import org.apache.hadoop.fs.tosfs.object.ObjectStorage;
import org.apache.hadoop.fs.tosfs.object.ObjectStorageFactory;
import org.apache.hadoop.fs.tosfs.object.ObjectUtils;
import org.apache.hadoop.fs.tosfs.object.Part;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;

public class MagicOutputStream
extends ObjectOutputStream {
    private final FileSystem fs;
    private final Path pendingPath;
    private boolean closeStorage = false;

    public MagicOutputStream(FileSystem fs, ExecutorService threadPool, Configuration conf, Path magic) {
        this(fs, ObjectStorageFactory.create(magic.toUri().getScheme(), magic.toUri().getHost(), conf), threadPool, conf, magic);
        this.closeStorage = true;
    }

    public MagicOutputStream(FileSystem fs, ObjectStorage storage, ExecutorService threadPool, Configuration conf, Path magic) {
        super(storage, threadPool, conf, magic, false);
        this.fs = fs;
        this.pendingPath = MagicOutputStream.createPendingPath(magic);
    }

    static String toDestKey(Path magicPath) {
        Preconditions.checkArgument((boolean)MagicOutputStream.isMagic(magicPath), (String)"Destination path is not magic %s", (Object[])new Object[]{magicPath});
        String magicKey = ObjectUtils.pathToKey(magicPath);
        ArrayList splits = Lists.newArrayList((Object[])magicKey.split("/"));
        int magicIndex = splits.indexOf("__magic");
        Preconditions.checkArgument((magicIndex >= 0 ? 1 : 0) != 0, (String)"Cannot locate %s in path %s", (Object[])new Object[]{"__magic", magicPath});
        List parentSplits = splits.subList(0, magicIndex);
        List childrenSplits = splits.subList(magicIndex + 1, splits.size());
        Preconditions.checkArgument((!childrenSplits.isEmpty() ? 1 : 0) != 0, (String)"No path found under %s for path %s", (Object[])new Object[]{"__magic", magicPath});
        ArrayList destSplits = Lists.newArrayList(parentSplits);
        if (childrenSplits.contains("__base")) {
            int baseIndex = childrenSplits.indexOf("__base");
            Preconditions.checkArgument((baseIndex >= 0 ? 1 : 0) != 0, (String)"Cannot locate %s in path %s", (Object[])new Object[]{"__base", magicPath});
            List baseChildrenSplits = childrenSplits.subList(baseIndex + 1, childrenSplits.size());
            Preconditions.checkArgument((!baseChildrenSplits.isEmpty() ? 1 : 0) != 0, (String)"No path found under %s for magic path %s", (Object[])new Object[]{"__base", magicPath});
            destSplits.addAll(baseChildrenSplits);
        } else {
            String filename = (String)childrenSplits.get(childrenSplits.size() - 1);
            destSplits.add(filename);
        }
        return StringUtils.join((Iterable)destSplits, (String)"/");
    }

    @Override
    protected String createDestKey(Path magicPath) {
        return MagicOutputStream.toDestKey(magicPath);
    }

    @Override
    protected void finishUpload(String destKey, String uploadId, List<Part> parts) throws IOException {
        Pending pending = Pending.builder().setBucket(this.storage().bucket().name()).setUploadId(uploadId).setLength(parts.stream().mapToLong(Part::size).sum()).setDestKey(destKey).setCreatedTimestamp(System.currentTimeMillis()).addParts(parts).build();
        this.persist(this.pendingPath, pending.serialize());
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.closeStorage) {
            this.storage().close();
        }
    }

    protected void persist(Path p, byte[] data) throws IOException {
        CommitUtils.save(this.fs, p, data);
    }

    public String pendingKey() {
        return ObjectUtils.pathToKey(this.pendingPath);
    }

    private static Path createPendingPath(Path magic) {
        return new Path(magic.getParent(), String.format("%s%s", magic.getName(), ".pending"));
    }

    private static boolean isInternalFile(Path p) {
        return p.toString().endsWith(".pendingset") || p.toString().endsWith(".pending");
    }

    public static boolean isMagic(Path p) {
        Preconditions.checkNotNull((Object)p, (Object)"path cannot be null.");
        String path = p.toUri().getPath();
        List splits = Arrays.stream(path.split("/")).filter(xva$0 -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList());
        return splits.contains("__magic") && !MagicOutputStream.isInternalFile(p);
    }
}

