/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs.commit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.tosfs.commit.mapred.Committer;
import org.apache.hadoop.fs.tosfs.util.Serializer;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;

public final class CommitUtils {
    public static final String COMMITTER_NAME = Committer.class.getName();
    public static final String FS_STORAGE_OBJECT_SCHEME = "fs.object-storage.scheme";
    public static final String DEFAULT_FS_STORAGE_OBJECT_SCHEME = "tos,oss,s3,s3a,s3n,obs,filestore";
    public static final String MAGIC = "__magic";
    public static final String BASE = "__base";
    public static final String PENDING_SUFFIX = ".pending";
    public static final String PENDINGSET_SUFFIX = ".pendingset";
    public static final String SUCCESS = "_SUCCESS";
    public static final String SUMMARY_FILENAME_FORMAT = "summary-%s.json";
    public static final String TASK_ATTEMPT_ID = "task.attempt.id";
    public static final String SPARK_WRITE_UUID = "spark.sql.sources.writeJobUUID";
    private static Set<String> errorStage = new HashSet<String>();
    private static boolean testMode = false;

    private CommitUtils() {
    }

    public static Path magicPath(Path out) {
        return new Path(out, MAGIC);
    }

    public static Path magicJobPath(String jobId, Path jobOutput) {
        return new Path(CommitUtils.magicPath(jobOutput), jobId);
    }

    public static int appAttemptId(JobContext context) {
        return context.getConfiguration().getInt("mapreduce.job.application.attempt.id", 0);
    }

    public static Path magicJobAttemptPath(String jobId, int appAttemptId, Path jobOutput) {
        return new Path(CommitUtils.magicPath(jobOutput), CommitUtils.formatAppAttemptDir(jobId, appAttemptId));
    }

    public static Path magicJobAttemptPath(JobContext context, Path jobOutput) {
        String jobId = CommitUtils.buildJobId(context);
        return CommitUtils.magicJobAttemptPath(jobId, CommitUtils.appAttemptId(context), jobOutput);
    }

    private static String formatAppAttemptDir(String jobId, int appAttemptId) {
        return String.format("%s/%02d", jobId, appAttemptId);
    }

    public static Path magicTaskAttemptsPath(String jobId, Path jobOutput, int appAttemptId) {
        return new Path(CommitUtils.magicJobAttemptPath(jobId, appAttemptId, jobOutput), "tasks");
    }

    public static Path magicTaskAttemptBasePath(TaskAttemptContext context, String jobId, Path jobOutput) {
        return new Path(CommitUtils.magicTaskAttemptPath(context, jobId, jobOutput), BASE);
    }

    public static Path magicTaskAttemptBasePath(TaskAttemptContext context, Path jobOutput) {
        String jobId = CommitUtils.buildJobId((JobContext)context);
        return CommitUtils.magicTaskAttemptBasePath(context, jobId, jobOutput);
    }

    public static Path magicTaskAttemptPath(TaskAttemptContext context, String jobId, Path jobOutput) {
        return new Path(CommitUtils.magicTaskAttemptsPath(jobId, jobOutput, CommitUtils.appAttemptId((JobContext)context)), String.valueOf(context.getTaskAttemptID()));
    }

    public static Path magicTaskAttemptPath(TaskAttemptContext context, Path jobOutput) {
        String jobId = CommitUtils.buildJobId((JobContext)context);
        return CommitUtils.magicTaskAttemptPath(context, jobId, jobOutput);
    }

    public static Path magicTaskPendingSetPath(TaskAttemptContext context, Path jobOutput) {
        String taskId = String.valueOf(context.getTaskAttemptID().getTaskID());
        return new Path(CommitUtils.magicJobAttemptPath((JobContext)context, jobOutput), String.format("%s%s", taskId, PENDINGSET_SUFFIX));
    }

    public static String buildJobId(Configuration conf, JobID jobId) {
        String jobUUID = conf.getTrimmed(SPARK_WRITE_UUID, "");
        if (!jobUUID.isEmpty()) {
            if (jobUUID.startsWith("job")) {
                return jobUUID;
            }
            return String.format("%s_%s", "job", jobUUID);
        }
        return jobId != null ? jobId.toString() : "NULL_JOB_ID";
    }

    public static String buildJobId(JobContext context) {
        return CommitUtils.buildJobId(context.getConfiguration(), context.getJobID());
    }

    public static String jobName(JobContext context) {
        String name = context.getJobName();
        return name != null && !name.isEmpty() ? name : "(anonymous)";
    }

    public static Path successMarker(Path output) {
        return new Path(output, SUCCESS);
    }

    public static Path summaryReport(Path reportDir, String jobId) {
        return new Path(reportDir, String.format(SUMMARY_FILENAME_FORMAT, jobId));
    }

    public static void save(FileSystem fs, Path path, byte[] data) throws IOException {
        try (FSDataOutputStream out = fs.create(path);){
            IOUtils.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)out);
        }
    }

    public static void save(FileSystem fs, Path path, Serializer instance) throws IOException {
        CommitUtils.save(fs, path, instance.serialize());
    }

    public static byte[] load(FileSystem fs, Path path) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FSDataInputStream in = fs.open(path);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return out.toByteArray();
    }

    public static List<FileStatus> listPendingFiles(FileSystem fs, Path dir) throws IOException {
        ArrayList pendingFiles = Lists.newArrayList();
        CommitUtils.listFiles(fs, dir, true, f -> {
            if (f.getPath().toString().endsWith(PENDING_SUFFIX)) {
                pendingFiles.add(f);
            }
        });
        return pendingFiles;
    }

    public static void listFiles(FileSystem fs, Path dir, boolean recursive, FileVisitor visitor) throws IOException {
        RemoteIterator iter = fs.listFiles(dir, recursive);
        while (iter.hasNext()) {
            FileStatus f = (FileStatus)iter.next();
            visitor.visit(f);
        }
    }

    public static boolean supportObjectStorageCommit(Configuration conf, Path outputPath) {
        return CommitUtils.supportSchemes(conf).contains(outputPath.toUri().getScheme());
    }

    private static List<String> supportSchemes(Configuration conf) {
        String schemes = conf.get(FS_STORAGE_OBJECT_SCHEME, DEFAULT_FS_STORAGE_OBJECT_SCHEME);
        Preconditions.checkNotNull((Object)schemes, (String)"%s cannot be null", (Object[])new Object[]{FS_STORAGE_OBJECT_SCHEME});
        return Arrays.asList(schemes.split(","));
    }

    public static void injectError(String stage) {
        errorStage.add(stage);
        testMode = true;
    }

    public static void removeError(String stage) {
        errorStage.remove(stage);
    }

    public static <T extends Exception> void triggerError(Supplier<T> error, String stage) throws T {
        if (testMode && errorStage.contains(stage)) {
            throw (Exception)error.get();
        }
    }

    public static interface FileVisitor {
        public void visit(FileStatus var1);
    }
}

