/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.tosfs.RawFileSystem;
import org.apache.hadoop.util.Preconditions;

public class TosFileSystem
extends RawFileSystem {
    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)name);
        String scheme = name.getScheme();
        if (scheme == null || scheme.isEmpty()) {
            scheme = FileSystem.getDefaultUri((Configuration)conf).getScheme();
        }
        Preconditions.checkArgument((boolean)scheme.equals("tos"), (String)"Unsupported scheme %s, expected scheme is %s.", (Object[])new Object[]{scheme, "tos"});
        super.initialize(name, conf);
    }
}

