/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.tosfs.RawFS;
import org.apache.hadoop.util.Preconditions;

public class TosFS
extends RawFS {
    public TosFS(URI uri, Configuration conf) throws IOException, URISyntaxException {
        super(TosFS.verifyURI(uri, conf), conf);
    }

    private static URI verifyURI(URI uri, Configuration conf) {
        Preconditions.checkNotNull((Object)uri);
        String scheme = uri.getScheme();
        if (scheme == null || scheme.isEmpty()) {
            scheme = FileSystem.getDefaultUri((Configuration)conf).getScheme();
        }
        Preconditions.checkArgument((boolean)scheme.equals("tos"), (String)"Unsupported scheme %s, expected scheme is %s.", (Object[])new Object[]{scheme, "tos"});
        return uri;
    }
}

