/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.tosfs.common.Bytes;

public class TosChecksum
extends FileChecksum {
    private String algorithm;
    private byte[] checksum;

    public TosChecksum(String algorithm, byte[] checksum) {
        this.algorithm = algorithm;
        this.checksum = checksum;
    }

    public String getAlgorithmName() {
        return this.algorithm;
    }

    public int getLength() {
        return this.checksum.length;
    }

    public byte[] getBytes() {
        return this.checksum;
    }

    public void write(DataOutput out) throws IOException {
        byte[] algorithmBytes = Bytes.toBytes(this.algorithm);
        out.write(algorithmBytes.length);
        out.write(algorithmBytes);
        out.write(this.checksum.length);
        out.write(this.checksum);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] algorithmBytes = new byte[in.readInt()];
        in.readFully(algorithmBytes);
        this.algorithm = Bytes.toString(algorithmBytes);
        this.checksum = new byte[in.readInt()];
        in.readFully(this.checksum);
    }
}

