/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs;

import java.util.Arrays;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

public class RawFileStatus
extends FileStatus {
    private final byte[] checksum;

    public RawFileStatus(long length, boolean isdir, long blocksize, long modificationTime, Path path, String owner, byte[] checksum) {
        super(length, isdir, 1, blocksize, modificationTime, path);
        this.setOwner(owner);
        this.setGroup(owner);
        this.checksum = checksum;
    }

    public byte[] checksum() {
        return this.checksum;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.checksum));
    }

    public boolean equals(Object o) {
        if (!(o instanceof RawFileStatus)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        RawFileStatus other = (RawFileStatus)((Object)o);
        return Arrays.equals(this.checksum, other.checksum);
    }
}

