/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.tosfs;

import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Preconditions;

public final class RawFSUtils {
    private RawFSUtils() {
    }

    public static boolean inSubtree(String root, String p) {
        return RawFSUtils.inSubtree(new Path(root), new Path(p));
    }

    public static boolean inSubtree(Path root, Path node) {
        Preconditions.checkNotNull((Object)root, (Object)"Root cannot be null");
        Preconditions.checkNotNull((Object)node, (Object)"Node cannot be null");
        if (root.isRoot()) {
            return true;
        }
        if (Objects.equals(root, node)) {
            return true;
        }
        while (!node.isRoot()) {
            if (Objects.equals(root, node)) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }
}

