/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.object;

import com.volcengine.tos.comm.event.DataTransferListener;
import com.volcengine.tos.comm.ratelimit.RateLimiter;
import com.volcengine.tos.model.GenericInput;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

public class AppendObjectInput
extends GenericInput {
    private String bucket;
    private String key;
    private long offset;
    private long contentLength = -1L;
    private transient InputStream content;
    private ObjectMetaRequestOptions options;
    private DataTransferListener dataTransferListener;
    private String preHashCrc64ecma;
    private RateLimiter rateLimiter;
    private String ifMatch;
    private long objectExpires = -1L;

    public Map<String, String> getAllSettedHeaders() {
        return Objects.isNull(this.options) ? null : this.options.headers();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getContent() {
        return this.content;
    }

    public ObjectMetaRequestOptions getOptions() {
        return this.options;
    }

    public DataTransferListener getDataTransferListener() {
        return this.dataTransferListener;
    }

    public String getPreHashCrc64ecma() {
        return this.preHashCrc64ecma;
    }

    public AppendObjectInput setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public AppendObjectInput setKey(String key) {
        this.key = key;
        return this;
    }

    public AppendObjectInput setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public AppendObjectInput setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public AppendObjectInput setContent(InputStream content) {
        this.content = content;
        return this;
    }

    public AppendObjectInput setOptions(ObjectMetaRequestOptions options) {
        this.options = options;
        return this;
    }

    public AppendObjectInput setDataTransferListener(DataTransferListener dataTransferListener) {
        this.dataTransferListener = dataTransferListener;
        return this;
    }

    public AppendObjectInput setPreHashCrc64ecma(String preHashCrc64ecma) {
        this.preHashCrc64ecma = preHashCrc64ecma;
        return this;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public AppendObjectInput setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public AppendObjectInput setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    public long getObjectExpires() {
        return this.objectExpires;
    }

    public AppendObjectInput setObjectExpires(long objectExpires) {
        this.objectExpires = objectExpires;
        return this;
    }

    public String toString() {
        return "AppendObjectInput{bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + ", offset=" + this.offset + ", contentLength=" + this.contentLength + ", content=" + this.content + ", options=" + this.options + ", dataTransferListener=" + this.dataTransferListener + ", preHashCrc64ecma='" + this.preHashCrc64ecma + '\'' + ", rateLimiter=" + this.rateLimiter + ", ifMatch='" + this.ifMatch + '\'' + ", objectExpires=" + this.objectExpires + '}';
    }

    public static AppendObjectInputBuilder builder() {
        return new AppendObjectInputBuilder();
    }

    public static final class AppendObjectInputBuilder {
        private String bucket;
        private String key;
        private long offset;
        private long contentLength = -1L;
        private transient InputStream content;
        private ObjectMetaRequestOptions options;
        private DataTransferListener dataTransferListener;
        private String preHashCrc64ecma;
        private RateLimiter rateLimiter;
        private String ifMatch;
        private long objectExpires = -1L;

        private AppendObjectInputBuilder() {
        }

        public AppendObjectInputBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public AppendObjectInputBuilder key(String key) {
            this.key = key;
            return this;
        }

        public AppendObjectInputBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public AppendObjectInputBuilder contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public AppendObjectInputBuilder content(InputStream content) {
            this.content = content;
            return this;
        }

        public AppendObjectInputBuilder options(ObjectMetaRequestOptions options) {
            this.options = options;
            return this;
        }

        public AppendObjectInputBuilder dataTransferListener(DataTransferListener dataTransferListener) {
            this.dataTransferListener = dataTransferListener;
            return this;
        }

        public AppendObjectInputBuilder preHashCrc64ecma(String preHashCrc64ecma) {
            this.preHashCrc64ecma = preHashCrc64ecma;
            return this;
        }

        public AppendObjectInputBuilder rateLimit(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        public AppendObjectInputBuilder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public AppendObjectInputBuilder objectExpires(long objectExpires) {
            this.objectExpires = objectExpires;
            return this;
        }

        public AppendObjectInput build() {
            AppendObjectInput appendObjectInput = new AppendObjectInput();
            appendObjectInput.key = this.key;
            appendObjectInput.content = this.content;
            appendObjectInput.preHashCrc64ecma = this.preHashCrc64ecma;
            appendObjectInput.offset = this.offset;
            appendObjectInput.contentLength = this.contentLength;
            appendObjectInput.bucket = this.bucket;
            appendObjectInput.dataTransferListener = this.dataTransferListener;
            appendObjectInput.rateLimiter = this.rateLimiter;
            appendObjectInput.options = this.options;
            appendObjectInput.ifMatch = this.ifMatch;
            appendObjectInput.objectExpires = this.objectExpires;
            return appendObjectInput;
        }
    }
}

