/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.bucket;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.volcengine.tos.comm.common.StorageClassType;
import com.volcengine.tos.internal.model.LifecycleDateSerializer;
import java.util.Date;

public class Transition {
    @JsonProperty(value="Date")
    @JsonSerialize(using=LifecycleDateSerializer.class)
    private Date date;
    @JsonProperty(value="Days")
    private int days;
    @JsonProperty(value="StorageClass")
    private StorageClassType storageClass;

    public Date getDate() {
        return this.date;
    }

    public Transition setDate(Date date) {
        this.date = date;
        return this;
    }

    public int getDays() {
        return this.days;
    }

    public Transition setDays(int days) {
        this.days = days;
        return this;
    }

    public StorageClassType getStorageClass() {
        return this.storageClass;
    }

    public Transition setStorageClass(StorageClassType storageClass) {
        this.storageClass = storageClass;
        return this;
    }

    public String toString() {
        return "Transition{date=" + this.date + ", days=" + this.days + ", storageClass=" + (Object)((Object)this.storageClass) + '}';
    }

    public static TransitionBuilder builder() {
        return new TransitionBuilder();
    }

    public static final class TransitionBuilder {
        private Date date;
        private int days;
        private StorageClassType storageClass;

        private TransitionBuilder() {
        }

        public TransitionBuilder date(Date date) {
            this.date = date;
            return this;
        }

        public TransitionBuilder days(int days) {
            this.days = days;
            return this;
        }

        public TransitionBuilder storageClass(StorageClassType storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Transition build() {
            Transition transition = new Transition();
            transition.setDate(this.date);
            transition.setDays(this.days);
            transition.setStorageClass(this.storageClass);
            return transition;
        }
    }
}

