/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util.ratelimit;

import com.volcengine.tos.comm.ratelimit.RateLimitRes;
import com.volcengine.tos.comm.ratelimit.RateLimiter;

public class DefaultRateLimiter
implements RateLimiter {
    private long capacity;
    private long rate;
    private long lastTokenGivenNanos;
    private long currentAmount;

    public DefaultRateLimiter(long rate) {
        this.capacity = rate;
        this.rate = rate;
        this.lastTokenGivenNanos = System.nanoTime();
        this.validateRateInput();
        this.currentAmount = this.capacity;
    }

    public DefaultRateLimiter(long capacity, long rate) {
        this.capacity = capacity;
        this.rate = rate;
        this.lastTokenGivenNanos = System.nanoTime();
        this.validateRateInput();
        this.currentAmount = this.capacity;
    }

    private void validateRateInput() {
        if (this.capacity < 10240L) {
            this.capacity = 10240L;
        }
        if (this.rate < 1024L) {
            this.rate = 1024L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RateLimitRes acquire(long want) {
        if (want <= 0L) {
            return new RateLimitRes().setOk(true).setTimeToWaitNanos(0L);
        }
        DefaultRateLimiter defaultRateLimiter = this;
        synchronized (defaultRateLimiter) {
            return this.reserveAndGetWaitTimeMills(want, System.nanoTime());
        }
    }

    private RateLimitRes reserveAndGetWaitTimeMills(long want, long timeMicros) {
        double duration = (double)(timeMicros - this.lastTokenGivenNanos) / 1.0E9;
        long increaseToken = (long)(duration * (double)this.rate);
        this.currentAmount = Math.min(increaseToken + this.currentAmount, this.capacity);
        if (want > this.capacity) {
            return new RateLimitRes().setOk(true).setTimeToWaitNanos(0L);
        }
        if (want > this.currentAmount) {
            long timeToWait = (long)((double)(want - this.currentAmount) * 1.0E9 / (double)this.rate);
            return new RateLimitRes().setOk(false).setTimeToWaitNanos(timeToWait);
        }
        this.lastTokenGivenNanos = timeMicros;
        this.currentAmount -= want;
        return new RateLimitRes().setOk(true).setTimeToWaitNanos(0L);
    }

    public long getCapacity() {
        return this.capacity;
    }

    public DefaultRateLimiter setCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public long getRate() {
        return this.rate;
    }

    public DefaultRateLimiter setRate(long rate) {
        this.rate = rate;
        return this;
    }

    public long getLastTokenGivenNanos() {
        return this.lastTokenGivenNanos;
    }

    public DefaultRateLimiter setLastTokenGivenNanos(long lastTokenGivenNanos) {
        this.lastTokenGivenNanos = lastTokenGivenNanos;
        return this;
    }

    public long getCurrentAmount() {
        return this.currentAmount;
    }

    public DefaultRateLimiter setCurrentAmount(long currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }
}

