/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.taskman;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.internal.taskman.AbortTaskHook;
import com.volcengine.tos.internal.taskman.InternalCancelHook;
import com.volcengine.tos.internal.taskman.TaskManager;
import com.volcengine.tos.internal.taskman.TaskOutput;
import com.volcengine.tos.internal.taskman.TosTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class TaskManagerImpl
implements TaskManager {
    private ExecutorService executor;
    private List<Future<TaskOutput<?>>> futures;
    private List<TaskOutput<?>> outputs;
    private List<TosTask> tasks;
    private InternalCancelHook internalCancelHook;
    private AbortTaskHook abortTaskHook;

    public TaskManagerImpl(int workerNum, int taskNum, InternalCancelHook internalCancelHook, AbortTaskHook abortTaskHook) {
        this.executor = new ThreadPoolExecutor(workerNum, workerNum, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
        this.futures = new ArrayList(taskNum);
        this.outputs = new ArrayList(taskNum);
        this.tasks = new ArrayList<TosTask>(taskNum);
        this.internalCancelHook = internalCancelHook;
        this.abortTaskHook = abortTaskHook;
    }

    @Override
    public void dispatch(TosTask task) {
        this.tasks.add(task);
    }

    @Override
    public void handle() {
        for (TosTask tosTask : this.tasks) {
            this.futures.add(this.executor.submit(tosTask.getCallableTask()));
        }
        try {
            for (Future future : this.futures) {
                this.outputs.add((TaskOutput<?>)future.get());
            }
        }
        catch (CancellationException e) {
            throw new TosClientException("tos: execute canceled", e);
        }
        catch (InterruptedException e) {
            throw new TosClientException("tos: execute interrupted", e);
        }
        catch (ExecutionException e) {
            if (this.abortTaskHook != null) {
                this.abortTaskHook.abort();
            }
            throw new TosClientException("tos: execute failed", e);
        }
        finally {
            this.executor.shutdown();
        }
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            if (this.abortTaskHook != null) {
                this.abortTaskHook.abort();
            }
            throw new TosClientException("tos: await executor terminated failed", e);
        }
    }

    @Override
    public List<TaskOutput<?>> get() {
        return this.outputs;
    }

    @Override
    public void suspend() {
        if (this.executor != null) {
            for (Future<TaskOutput<?>> future : this.futures) {
                try {
                    future.wait();
                }
                catch (InterruptedException e) {
                    throw new TosClientException("tos: execute interrupted while waiting", e);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            try {
                for (Future<TaskOutput<?>> future : this.futures) {
                    future.cancel(true);
                }
            }
            finally {
                this.executor.shutdownNow();
            }
        }
    }
}

