/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.comm.io.TosRepeatableFileInputStream;
import com.volcengine.tos.internal.RequestConnectionManager;
import com.volcengine.tos.internal.RequestDnsInterceptor;
import com.volcengine.tos.internal.RequestDnsResolver;
import com.volcengine.tos.internal.RequestLatencyInterceptor;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.WrappedApacheTransportRequestBody;
import com.volcengine.tos.internal.model.CRC64Checksum;
import com.volcengine.tos.internal.model.RetryCountNotifier;
import com.volcengine.tos.internal.model.SimpleDataTransferListenInputStream;
import com.volcengine.tos.internal.model.TosCheckedInputStream;
import com.volcengine.tos.internal.util.CRC64Utils;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.dnscache.DnsCacheService;
import com.volcengine.tos.internal.util.dnscache.DnsCacheServiceImpl;
import com.volcengine.tos.internal.util.ratelimit.RateLimitedInputStream;
import com.volcengine.tos.transport.TransportConfig;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.CheckedInputStream;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;

public class RequestTransport
implements Transport,
Closeable {
    private static final ContentType DEFAULT_MEDIA_TYPE = null;
    private final CloseableHttpClient client;
    private int maxRetries;
    private int except100ContinueThreshold;
    private boolean disableEncodingMeta;
    private DnsCacheService dnsCacheService;

    public RequestTransport(TransportConfig config) {
        ParamsChecker.ensureNotNull(config, "TransportConfig");
        int maxConnections = config.getMaxConnections() > 0 ? config.getMaxConnections() : 1024;
        int maxIdleConnectionTimeMills = config.getIdleConnectionTimeMills() > 0 ? config.getIdleConnectionTimeMills() : 60000;
        int readTimeout = config.getReadTimeoutMills() >= 0 ? config.getReadTimeoutMills() : 30000;
        int writeTimeout = config.getWriteTimeoutMills() >= 0 ? config.getWriteTimeoutMills() : 30000;
        int connectTimeout = config.getConnectTimeoutMills() > 0 ? config.getConnectTimeoutMills() : 10000;
        this.maxRetries = config.getMaxRetryCount();
        if (this.maxRetries < 0) {
            this.maxRetries = 0;
        }
        this.except100ContinueThreshold = config.getExcept100ContinueThreshold();
        HttpClientBuilder builder = HttpClients.custom();
        RequestDnsResolver requestDnsResolver = new RequestDnsResolver(SystemDefaultDnsResolver.INSTANCE);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        if (!config.isHttp() && !config.isEnableVerifySSL()) {
            connectionManagerBuilder = TosUtils.ignoreCertificate(connectionManagerBuilder);
        }
        if (StringUtils.isNotEmpty(config.getProxyHost()) && config.getProxyPort() > 0) {
            this.addProxyConfig(config, builder);
        }
        if (config.getDnsCacheTimeMinutes() > 0) {
            this.dnsCacheService = new DnsCacheServiceImpl(config.getDnsCacheTimeMinutes(), 30);
            requestDnsResolver.setDnsCacheService(this.dnsCacheService);
        }
        connectionManagerBuilder.setDnsResolver(requestDnsResolver);
        connectionManagerBuilder.setMaxConnTotal(maxConnections);
        connectionManagerBuilder.setMaxConnPerRoute(maxConnections);
        ConnectionConfig.Builder conBuilder = ConnectionConfig.custom();
        conBuilder.setTimeToLive(maxIdleConnectionTimeMills, TimeUnit.MILLISECONDS);
        conBuilder.setSocketTimeout(Math.max(readTimeout, writeTimeout), TimeUnit.MILLISECONDS);
        conBuilder.setConnectTimeout(connectTimeout, TimeUnit.MILLISECONDS);
        connectionManagerBuilder.setDefaultConnectionConfig(conBuilder.build());
        RequestLatencyInterceptor requestLatencyInterceptor = new RequestLatencyInterceptor(TosUtils.getLogger()).setHighLatencyLogThreshold(config.getHighLatencyLogThreshold());
        RequestDnsInterceptor requestDnsInterceptor = new RequestDnsInterceptor(this.dnsCacheService);
        RequestConnectionManager requestConnectionManager = new RequestConnectionManager(connectionManagerBuilder.build());
        this.client = builder.setConnectionManager(requestConnectionManager).setDefaultRequestConfig(requestConfigBuilder.build()).disableAutomaticRetries().disableRedirectHandling().addRequestInterceptorFirst(requestLatencyInterceptor).addResponseInterceptorLast(requestLatencyInterceptor).addExecInterceptorAfter("dnsRemover", "dnsRemover", requestDnsInterceptor).disableContentCompression().build();
    }

    private void addProxyConfig(TransportConfig config, HttpClientBuilder builder) {
        HttpHost proxy = new HttpHost(config.getProxyHost(), config.getProxyPort());
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        builder.setRoutePlanner(routePlanner);
        if (StringUtils.isNotEmpty(config.getProxyUserName())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(config.getProxyHost(), config.getProxyPort()), new UsernamePasswordCredentials(config.getProxyUserName(), config.getProxyPassword().toCharArray()));
            builder.setDefaultCredentialsProvider(credentialsProvider);
        }
    }

    public RequestTransport setDisableEncodingMeta(boolean disableEncodingMeta) {
        this.disableEncodingMeta = disableEncodingMeta;
        return this;
    }

    @Override
    public void switchConfig(TransportConfig config) {
        this.maxRetries = config.getMaxRetryCount();
        if (this.maxRetries < 0) {
            this.maxRetries = 0;
        }
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    @Override
    public TosResponse roundTrip(TosRequest tosRequest) throws IOException {
        WrappedHttpResponse wrappedHttpResponse = null;
        long start = System.currentTimeMillis();
        int reqTimes = 1;
        this.wrapTosRequestContent(tosRequest);
        HttpEntityContainer lastRequest = null;
        int i = 0;
        while (i < this.maxRetries + 1) {
            try {
                HttpEntity entity;
                if (tosRequest.getContent() != null && tosRequest.getContent() instanceof RetryCountNotifier) {
                    ((RetryCountNotifier)((Object)tosRequest.getContent())).setRetryCount(i);
                }
                if (lastRequest != null && (entity = lastRequest.getEntity()) != null && entity instanceof WrappedApacheTransportRequestBody) {
                    ((WrappedApacheTransportRequestBody)entity).reset();
                }
                ClassicHttpRequest builder = this.buildRequest(tosRequest);
                lastRequest = builder;
                if (i != 0) {
                    builder.addHeader("x-sdk-retry-count", "attempt=" + i + "; max=" + this.maxRetries);
                }
                ClassicHttpResponse response = this.client.executeOpen(null, builder, null);
                wrappedHttpResponse = this.handleResponse(response, tosRequest);
                wrappedHttpResponse.setHttpResponse(response);
                if (!wrappedHttpResponse.isRetry() || !tosRequest.isRetryableOnServerException() || i == this.maxRetries) break;
                long sleepMs = TosUtils.backoff(i);
                if ((wrappedHttpResponse.getCode() == 503 || wrappedHttpResponse.getCode() == 429) && StringUtils.isNotEmpty(wrappedHttpResponse.getRetryAfter())) {
                    try {
                        sleepMs = Math.max((long)(Integer.parseInt(wrappedHttpResponse.getRetryAfter()) * 1000), sleepMs);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Thread.sleep(sleepMs);
            }
            catch (InterruptedException e) {
                TosUtils.getLogger().debug("tos: request interrupted while sleeping in retry");
                this.printAccessLogFailed(e);
                throw new TosClientException("tos: request interrupted", e);
            }
            catch (IOException e) {
                if (tosRequest.isRetryableOnClientException() && !"mark/reset not supported".equals(e.toString())) {
                    try {
                        if (i == this.maxRetries) {
                            this.printAccessLogFailed(e);
                            throw e;
                        }
                        Thread.sleep(TosUtils.backoff(i));
                    }
                    catch (InterruptedException ie) {
                        TosUtils.getLogger().debug("tos: request interrupted while sleeping in retry");
                        this.printAccessLogFailed(e);
                        throw new TosClientException("tos: request interrupted", e);
                    }
                }
                this.printAccessLogFailed(e);
                throw e;
            }
            catch (URISyntaxException e) {
                TosUtils.getLogger().debug("tos: request interrupted while sleeping in retry");
                this.printAccessLogFailed(e);
                throw new TosClientException("tos: request interrupted", e);
            }
            ++i;
            ++reqTimes;
        }
        long end = System.currentTimeMillis();
        if (wrappedHttpResponse == null) {
            throw new TosClientException("empty wrappedHttpResponse", null);
        }
        ParamsChecker.ensureNotNull(wrappedHttpResponse.getHttpResponse(), "okhttp response");
        this.printAccessLogSucceed(wrappedHttpResponse.getCode(), wrappedHttpResponse.getReqID(), end - start, reqTimes);
        if (wrappedHttpResponse.getResponse() == null) {
            return new TosResponse().setStatusCode(wrappedHttpResponse.getCode()).setContentLength(this.getSize(wrappedHttpResponse.getHttpResponse())).setHeaders(this.getHeaders(wrappedHttpResponse.getHttpResponse())).setInputStream(null);
        }
        return wrappedHttpResponse.getResponse();
    }

    private void printAccessLogSucceed(int code, String reqId, long cost, int reqTimes) {
        TosUtils.getLogger().info("tos: status code:{}, request id:{}, request cost {} ms, request {} times\n", new Object[]{code, reqId, cost, reqTimes});
    }

    private void printAccessLogFailed(Exception e) {
        TosUtils.getLogger().info("tos: request exception: {}\n", (Object)e.toString());
    }

    private void checkCrc(TosRequest tosRequest, ClassicHttpResponse response) {
        boolean needCheckCrc;
        boolean bl = needCheckCrc = tosRequest.isEnableCrcCheck() && response.getCode() < 300 && tosRequest.getContent() != null && tosRequest.getContent() instanceof CheckedInputStream;
        if (!needCheckCrc) {
            return;
        }
        long clientCrcLong = ((CheckedInputStream)tosRequest.getContent()).getChecksum().getValue();
        String clientHashCrc64Ecma = CRC64Utils.longToUnsignedLongString(clientCrcLong);
        String serverHashCrc64Ecma = response.getFirstHeader("x-tos-hash-crc64ecma").getValue();
        if (StringUtils.isNotEmpty(serverHashCrc64Ecma) && !StringUtils.equals(clientHashCrc64Ecma, serverHashCrc64Ecma)) {
            throw new TosClientException("tos: crc64 check failed, expected:" + serverHashCrc64Ecma + ", in fact:" + clientHashCrc64Ecma, null);
        }
    }

    private WrappedHttpResponse handleResponse(ClassicHttpResponse response, TosRequest tosRequest) throws IOException {
        ParamsChecker.ensureNotNull(response, "http response");
        int code = response.getCode();
        String reqID = null;
        String headEC = null;
        if (response.getFirstHeader("X-Tos-Request-Id") != null) {
            reqID = response.getFirstHeader("X-Tos-Request-Id").getValue();
        }
        if (response.getFirstHeader("X-Tos-Ec") != null) {
            headEC = response.getFirstHeader("X-Tos-Ec").getValue();
        }
        if (code >= 500 || code == 429 || code == 408 || code == 400 && "0005-00000044".equals(headEC)) {
            if (response.getFirstHeader("Retry-After") == null) {
                return new WrappedHttpResponse(null, true, code, null, reqID);
            }
            String retryAfter = response.getFirstHeader("Retry-After").getValue();
            return new WrappedHttpResponse(null, true, code, retryAfter, reqID);
        }
        ParamsChecker.ensureNotNull(response, "http response");
        this.checkCrc(tosRequest, response);
        HttpEntity entity = response.getEntity();
        InputStream inputStream = entity == null ? null : entity.getContent();
        return new WrappedHttpResponse(new TosResponse().setStatusCode(code).setContentLength(this.getSize(response)).setHeaders(this.getHeaders(response)).setInputStream(inputStream), false, code, null, reqID);
    }

    private ClassicHttpRequest buildRequest(TosRequest request) throws IOException, URISyntaxException {
        HttpUriRequestBase builder;
        URI uri = request.toURL();
        switch (request.getMethod() == null ? "" : request.getMethod().toUpperCase()) {
            case "GET": {
                builder = new HttpGet(uri);
                break;
            }
            case "POST": {
                builder = new HttpPost(uri);
                if (request.getContent() != null && request.getContentLength() <= 0L) {
                    byte[] data = new byte[request.getContent().available()];
                    int exact = request.getContent().read(data);
                    if (exact != -1 && exact != data.length) {
                        throw new IOException("expected " + data.length + " bytes, but got " + exact + " bytes.");
                    }
                    builder.setEntity(new ByteArrayEntity(data, this.getContentType(request)));
                    break;
                }
                if (request.getContent() != null) {
                    if (this.except100ContinueThreshold > 0 && (request.getContentLength() < 0L || request.getContentLength() > (long)this.except100ContinueThreshold)) {
                        builder.addHeader("Expect", "100-continue");
                    }
                    builder.setEntity(new WrappedApacheTransportRequestBody(this.getContentType(request), request));
                    break;
                }
                if (request.getData() != null) {
                    if (this.except100ContinueThreshold > 0 && request.getData().length > this.except100ContinueThreshold) {
                        builder.addHeader("Expect", "100-continue");
                    }
                    builder.setEntity(new ByteArrayEntity(request.getData(), this.getContentType(request)));
                    break;
                }
                builder.setEntity(new ByteArrayEntity(new byte[0], this.getContentType(request)));
                break;
            }
            case "PUT": {
                builder = new HttpPut(uri);
                if (request.getContent() != null) {
                    if (this.except100ContinueThreshold > 0 && (request.getContentLength() < 0L || request.getContentLength() > (long)this.except100ContinueThreshold)) {
                        builder.addHeader("Expect", "100-continue");
                    }
                    builder.setEntity(new WrappedApacheTransportRequestBody(this.getContentType(request), request));
                    break;
                }
                if (request.getData() != null) {
                    if (this.except100ContinueThreshold > 0 && request.getData().length > this.except100ContinueThreshold) {
                        builder.addHeader("Expect", "100-continue");
                    }
                    builder.setEntity(new ByteArrayEntity(request.getData(), this.getContentType(request)));
                    break;
                }
                builder.setEntity(new ByteArrayEntity(new byte[0], this.getContentType(request)));
                break;
            }
            case "HEAD": {
                builder = new HttpHead(uri);
                break;
            }
            case "DELETE": {
                builder = new HttpDelete(uri);
                break;
            }
            default: {
                throw new TosClientException("Method is not supported: " + request.getMethod(), null);
            }
        }
        this.addHeader(request, builder);
        return builder;
    }

    private void addHeader(TosRequest request, ClassicHttpRequest builder) {
        if (request == null || builder == null || request.getHeaders() == null) {
            return;
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            String key = entry.getKey();
            if (key == "Content-Length") continue;
            String value = entry.getValue();
            builder.addHeader(key, value);
        }
    }

    private void wrapTosRequestContent(TosRequest request) {
        if (request == null || request.getContent() == null) {
            return;
        }
        InputStream originalInputStream = request.getContent();
        InputStream wrappedInputStream = null;
        int readLimit = 524288;
        if (request.getReadLimit() > 0) {
            readLimit = request.getReadLimit();
        }
        wrappedInputStream = originalInputStream.markSupported() ? originalInputStream : (originalInputStream instanceof FileInputStream ? new TosRepeatableFileInputStream((FileInputStream)originalInputStream) : new BufferedInputStream(originalInputStream, readLimit));
        wrappedInputStream.mark(readLimit);
        if (request.getRateLimiter() != null) {
            wrappedInputStream = new RateLimitedInputStream(wrappedInputStream, request.getRateLimiter());
        }
        if (request.getDataTransferListener() != null) {
            wrappedInputStream = new SimpleDataTransferListenInputStream(wrappedInputStream, request.getDataTransferListener(), request.getContentLength());
        }
        if (request.isUseTrailerHeader() || request.isEnableCrcCheck()) {
            CRC64Checksum checksum = new CRC64Checksum(request.getCrc64InitValue());
            wrappedInputStream = new TosCheckedInputStream(wrappedInputStream, checksum);
        }
        request.setContent(wrappedInputStream);
    }

    private ContentType getContentType(TosRequest request) {
        String type = "";
        if (request.getHeaders() != null && request.getHeaders().containsKey("Content-Type")) {
            type = request.getHeaders().get("Content-Type");
        }
        return StringUtils.isEmpty(type) ? DEFAULT_MEDIA_TYPE : ContentType.parse(type);
    }

    private long getSize(ClassicHttpResponse response) {
        Header header = response.getFirstHeader("Content-Length");
        if (header == null) {
            return 0L;
        }
        String size = header.getValue();
        if (StringUtils.isEmpty(size)) {
            return 0L;
        }
        return Long.parseLong(size);
    }

    private Map<String, String> getHeaders(ClassicHttpResponse response) {
        Header[] headers = response.getHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>(headers.length);
        for (Header head : response.getHeaders()) {
            this.parseHeader(response, headersMap, head.getName());
        }
        return headersMap;
    }

    private void parseHeader(ClassicHttpResponse response, Map<String, String> headers, String name) {
        String key = name;
        String value = response.getFirstHeader(name).getValue();
        if (!this.disableEncodingMeta) {
            if (StringUtils.startWithIgnoreCase(key, "X-Tos-Meta-")) {
                key = TosUtils.decodeHeader(key);
                value = TosUtils.decodeHeader(value);
            } else if (StringUtils.equalsIgnoreCase(key, "Content-Disposition")) {
                value = TosUtils.decodeHeader(value);
            }
        }
        headers.put(key.toLowerCase(), value);
    }

    @Override
    public void close() throws IOException {
        if (this.dnsCacheService != null && this.dnsCacheService instanceof Closeable) {
            ((Closeable)((Object)this.dnsCacheService)).close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    private class WrappedHttpResponse {
        private final TosResponse response;
        private final boolean retry;
        private final int code;
        private final String retryAfter;
        private final String reqID;
        private ClassicHttpResponse httpResponse;

        public WrappedHttpResponse(TosResponse response, boolean retry, int code, String retryAfter, String reqID) {
            this.response = response;
            this.retry = retry;
            this.code = code;
            this.retryAfter = retryAfter;
            this.reqID = reqID;
        }

        public TosResponse getResponse() {
            return this.response;
        }

        public boolean isRetry() {
            return this.retry;
        }

        public int getCode() {
            return this.code;
        }

        public String getRetryAfter() {
            return this.retryAfter;
        }

        public String getReqID() {
            return this.reqID;
        }

        public void setHttpResponse(ClassicHttpResponse httpResponse) {
            this.httpResponse = httpResponse;
        }

        public ClassicHttpResponse getHttpResponse() {
            return this.httpResponse;
        }
    }
}

