/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.credential;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.credential.Credentials;
import com.volcengine.tos.credential.CredentialsProvider;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;

public class EcsCredentialsProvider
implements CredentialsProvider,
Closeable {
    private static final String DEFAULT_META_SERVICE_URL = "http://100.96.0.96/volcstack/latest/iam/security_credentials";
    private static final DateTimeFormatter expireTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
    private final Thread refreshThread;
    private final String roleName;
    private final String url;
    private final Lock lock;
    private final CloseableHttpClient client;
    private volatile EcsCredentials ecsCredentials;

    public EcsCredentialsProvider(String roleName) {
        this(roleName, null);
    }

    public EcsCredentialsProvider(String roleName, String url) {
        if (StringUtils.isEmpty(roleName)) {
            throw new TosClientException("ecs role name is empty", null);
        }
        this.url = StringUtils.isEmpty(url) ? DEFAULT_META_SERVICE_URL : url;
        this.roleName = roleName;
        this.lock = new ReentrantLock();
        this.client = TosUtils.defaultApacheHttpClient();
        int finalRefreshInterval = 300;
        this.refreshThread = new Thread(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        Thread.sleep(300000L);
                        EcsCredentials origin = EcsCredentialsProvider.this.ecsCredentials;
                        if (origin != null && !((double)(System.nanoTime() - origin.lastUpdateTimeNanos) > 1.0E9)) continue;
                        EcsCredentialsProvider.this.fetchCredentials();
                    }
                    catch (TosClientException e) {
                        TosUtils.getLogger().warn("try to fetch ecs credentials failed", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        this.refreshThread.setDaemon(true);
        this.refreshThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials getCredentials(int expires) {
        EcsCredentials credentials = this.ecsCredentials;
        if (credentials != null && credentials.isValid()) {
            return credentials;
        }
        this.lock.lock();
        try {
            credentials = this.ecsCredentials;
            if (credentials != null && credentials.isValid()) {
                EcsCredentials ecsCredentials = credentials;
                return ecsCredentials;
            }
            Credentials credentials2 = this.fetchCredentials();
            return credentials2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Credentials fetchCredentials() {
        EcsCredentials origin = this.ecsCredentials;
        try {
            EcsCredentials current;
            this.ecsCredentials = current = this.client.execute((ClassicHttpRequest)new HttpGet(this.url + "/" + this.roleName), response -> {
                int statusCode = response.getCode();
                if (statusCode == 200) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        try (InputStream inputStream = entity.getContent();){
                            EcsCredentials creds = (EcsCredentials)TosUtils.getJsonMapper().readValue(inputStream, EcsCredentials.class);
                            if (StringUtils.isNotEmpty(creds.ak) && StringUtils.isNotEmpty(creds.sk)) {
                                creds.lastUpdateTimeNanos = System.nanoTime();
                                if (StringUtils.isNotEmpty(creds.expiredTime)) {
                                    ZonedDateTime l = ZonedDateTime.parse(creds.expiredTime, expireTimeFormatter);
                                    creds.expiredDate = Date.from(Instant.from(l));
                                }
                                this.ecsCredentials = creds;
                                EcsCredentials ecsCredentials = creds;
                                return ecsCredentials;
                            }
                        }
                    }
                    throw new TosClientException("parse ecs token failed", null);
                }
                throw new TosClientException("get ecs token failed, unexpected status code: " + statusCode, null);
            });
            return current;
        }
        catch (Exception e) {
            if (origin != null) {
                origin.immortal = true;
                return origin;
            }
            if (e instanceof TosClientException) {
                throw (TosClientException)e;
            }
            throw new TosClientException("get ecs token failed", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.refreshThread.interrupt();
        this.client.close();
    }

    private static class EcsCredentials
    implements Credentials {
        @JsonIgnore
        volatile boolean immortal;
        @JsonIgnore
        long lastUpdateTimeNanos;
        @JsonIgnore
        Date expiredDate;
        @JsonProperty(value="AccessKeyId")
        String ak;
        @JsonProperty(value="SecretAccessKey")
        String sk;
        @JsonProperty(value="SessionToken")
        String securityToken;
        @JsonProperty(value="ExpiredTime")
        String expiredTime;

        private EcsCredentials() {
        }

        boolean isValid() {
            return this.immortal || this.expiredDate == null || this.expiredDate.after(new Date());
        }

        @Override
        public String getAk() {
            return this.ak;
        }

        @Override
        public String getSk() {
            return this.sk;
        }

        @Override
        public String getSecurityToken() {
            return this.securityToken;
        }
    }
}

