/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos;

import com.volcengine.tos.TosException;
import java.util.ArrayList;
import java.util.List;

public class UnexpectedStatusCodeException
extends TosException {
    private int statusCode;
    private List<Integer> expectedCodes = new ArrayList<Integer>();
    private String requestID;

    public UnexpectedStatusCodeException(int statusCode, int expectedCode, String requestID) {
        this.statusCode = statusCode;
        this.expectedCodes.add(expectedCode);
        this.requestID = requestID;
    }

    public UnexpectedStatusCodeException(int statusCode, List<Integer> expectedCodes, String requestID) {
        this.statusCode = statusCode;
        this.expectedCodes.addAll(expectedCodes);
        this.requestID = requestID;
    }

    public UnexpectedStatusCodeException withRequestID(String requestID) {
        this.requestID = requestID;
        return this;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public List<Integer> getExpectedCodes() {
        return this.expectedCodes;
    }

    @Deprecated
    public String getRequestID() {
        return this.requestID;
    }

    @Override
    public String toString() {
        return "UnexpectedStatusCodeException{statusCode=" + this.statusCode + ", expectedCodes=" + this.expectedCodes + ", requestID='" + this.requestID + '\'' + '}';
    }
}

