/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SkipBadRecords;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.io.InputWriter;
import org.apache.hadoop.streaming.io.OutputReader;

public class PipeReducer
extends PipeMapRed
implements Reducer {
    private byte[] reduceOutFieldSeparator;
    private byte[] reduceInputFieldSeparator;
    private int numOfReduceOutputKeyFields = 1;
    private boolean skipping = false;

    @Override
    String getPipeCommand(JobConf job) {
        String str = job.get("stream.reduce.streamprocessor");
        if (str == null) {
            return str;
        }
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("stream.reduce.streamprocessor in jobconf not found");
            return null;
        }
    }

    @Override
    boolean getDoPipe() {
        String argv = this.getPipeCommand(this.job_);
        return argv != null && !"NONE".equals(argv);
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        SkipBadRecords.setAutoIncrReducerProcCount((Configuration)job, (boolean)false);
        this.skipping = job.getBoolean("mapreduce.job.skiprecords", false);
        this.reduceOutFieldSeparator = this.job_.get("stream.reduce.output.field.separator", "\t").getBytes(StandardCharsets.UTF_8);
        this.reduceInputFieldSeparator = this.job_.get("stream.reduce.input.field.separator", "\t").getBytes(StandardCharsets.UTF_8);
        this.numOfReduceOutputKeyFields = this.job_.getInt("stream.num.reduce.output.key.fields", 1);
    }

    public void reduce(Object key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
        if (this.doPipe_ && this.outThread_ == null) {
            this.startOutputThreads(output, reporter);
        }
        try {
            while (values.hasNext()) {
                Writable val = (Writable)values.next();
                ++this.numRecRead_;
                this.maybeLogRecord();
                if (this.doPipe_) {
                    if (this.outerrThreadsThrowable != null) {
                        this.mapRedFinished();
                        throw new IOException("MROutput/MRErrThread failed:", this.outerrThreadsThrowable);
                    }
                    this.inWriter_.writeKey(key);
                    this.inWriter_.writeValue(val);
                    continue;
                }
                output.collect(key, (Object)val);
            }
            if (this.doPipe_ && this.skipping) {
                this.clientOut_.flush();
            }
        }
        catch (IOException io) {
            Object extraInfo = "";
            try {
                int exitVal = this.sim.exitValue();
                extraInfo = exitVal == 0 ? "subprocess exited successfully\n" : "subprocess exited with error code " + exitVal + "\n";
            }
            catch (IllegalThreadStateException e) {
                extraInfo = "subprocess still running\n";
            }
            this.mapRedFinished();
            throw new IOException((String)extraInfo + this.getContext() + io.getMessage());
        }
    }

    public void close() {
        this.mapRedFinished();
    }

    @Override
    public byte[] getInputSeparator() {
        return this.reduceInputFieldSeparator;
    }

    @Override
    public byte[] getFieldSeparator() {
        return this.reduceOutFieldSeparator;
    }

    @Override
    public int getNumOfKeyFields() {
        return this.numOfReduceOutputKeyFields;
    }

    @Override
    InputWriter createInputWriter() throws IOException {
        return super.createInputWriter(this.reduceInputWriterClass_);
    }

    @Override
    OutputReader createOutputReader() throws IOException {
        return super.createOutputReader(this.reduceOutputReaderClass_);
    }
}

