/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.streaming.Environment;
import org.apache.hadoop.streaming.PathFinder;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.io.InputWriter;
import org.apache.hadoop.streaming.io.OutputReader;
import org.apache.hadoop.streaming.io.TextInputWriter;
import org.apache.hadoop.streaming.io.TextOutputReader;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeMapRed {
    protected static final Logger LOG = LoggerFactory.getLogger((String)PipeMapRed.class.getName());
    static final int OUTSIDE = 1;
    static final int SINGLEQ = 2;
    static final int DOUBLEQ = 3;
    private static final int BUFFER_SIZE = 131072;
    long startTime_;
    long numRecRead_ = 0L;
    long numRecWritten_ = 0L;
    long numRecSkipped_ = 0L;
    long nextRecReadLog_ = 1L;
    long minRecWrittenToEnableSkip_ = Long.MAX_VALUE;
    long reporterOutDelay_ = 10000L;
    long reporterErrDelay_ = 10000L;
    long joinDelay_;
    JobConf job_;
    boolean doPipe_;
    Class<? extends InputWriter> mapInputWriterClass_;
    Class<? extends OutputReader> mapOutputReaderClass_;
    Class<? extends InputWriter> reduceInputWriterClass_;
    Class<? extends OutputReader> reduceOutputReaderClass_;
    boolean nonZeroExitIsFailure_;
    Process sim;
    InputWriter inWriter_;
    OutputReader outReader_;
    MROutputThread outThread_;
    MRErrorThread errThread_;
    DataOutputStream clientOut_;
    DataInputStream clientErr_;
    DataInputStream clientIn_;
    int numExceptions_;
    protected volatile Throwable outerrThreadsThrowable;
    volatile boolean processProvidedStatus_ = false;

    public Configuration getConfiguration() {
        return this.job_;
    }

    public DataOutput getClientOutput() {
        return this.clientOut_;
    }

    public DataInput getClientInput() {
        return this.clientIn_;
    }

    public abstract byte[] getInputSeparator();

    public abstract byte[] getFieldSeparator();

    public abstract int getNumOfKeyFields();

    abstract String getPipeCommand(JobConf var1);

    abstract boolean getDoPipe();

    static String[] splitArgs(String args) {
        ArrayList<String> argList = new ArrayList<String>();
        char[] ch = args.toCharArray();
        int clen = ch.length;
        int state = 1;
        int argstart = 0;
        for (int c = 0; c <= clen; ++c) {
            boolean last = c == clen;
            int lastState = state;
            boolean endToken = false;
            if (!last) {
                if (ch[c] == '\'') {
                    if (state == 1) {
                        state = 2;
                    } else if (state == 2) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == '\"') {
                    if (state == 1) {
                        state = 3;
                    } else if (state == 3) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == ' ' && state == 1) {
                    endToken = true;
                }
            }
            if (!last && !endToken) continue;
            if (c != argstart) {
                String a = args.substring(argstart, c);
                argList.add(a);
            }
            argstart = c + 1;
            lastState = state;
        }
        return argList.toArray(new String[0]);
    }

    public void configure(JobConf job) {
        try {
            String argv = this.getPipeCommand(job);
            this.joinDelay_ = job.getLong("stream.joindelay.milli", 0L);
            this.job_ = job;
            this.mapInputWriterClass_ = this.job_.getClass("stream.map.input.writer.class", TextInputWriter.class, InputWriter.class);
            this.mapOutputReaderClass_ = this.job_.getClass("stream.map.output.reader.class", TextOutputReader.class, OutputReader.class);
            this.reduceInputWriterClass_ = this.job_.getClass("stream.reduce.input.writer.class", TextInputWriter.class, InputWriter.class);
            this.reduceOutputReaderClass_ = this.job_.getClass("stream.reduce.output.reader.class", TextOutputReader.class, OutputReader.class);
            this.nonZeroExitIsFailure_ = this.job_.getBoolean("stream.non.zero.exit.is.failure", true);
            this.doPipe_ = this.getDoPipe();
            if (!this.doPipe_) {
                return;
            }
            this.setStreamJobDetails(job);
            String[] argvSplit = PipeMapRed.splitArgs(argv);
            String prog = argvSplit[0];
            File currentDir = new File(".").getAbsoluteFile();
            if (!new File(prog).isAbsolute()) {
                FileUtil.chmod((String)new File(currentDir, prog).toString(), (String)"a+x");
            }
            if (!new File(argvSplit[0]).isAbsolute()) {
                PathFinder finder = new PathFinder("PATH");
                finder.prependPathComponent(currentDir.toString());
                File f = finder.getAbsolutePath(argvSplit[0]);
                if (f != null) {
                    argvSplit[0] = f.getAbsolutePath();
                }
                f = null;
            }
            LOG.info("PipeMapRed exec " + Arrays.asList(argvSplit));
            Environment childEnv = (Environment)StreamUtil.env().clone();
            this.addJobConfToEnvironment(this.job_, childEnv);
            this.addEnvironment(childEnv, this.job_.get("stream.addenvironment"));
            this.envPut(childEnv, "TMPDIR", System.getProperty("java.io.tmpdir"));
            ProcessBuilder builder = new ProcessBuilder(argvSplit);
            builder.environment().putAll(childEnv.toMap());
            this.sim = builder.start();
            this.clientOut_ = new DataOutputStream(new BufferedOutputStream(this.sim.getOutputStream(), 131072));
            this.clientIn_ = new DataInputStream(new BufferedInputStream(this.sim.getInputStream(), 131072));
            this.clientErr_ = new DataInputStream(new BufferedInputStream(this.sim.getErrorStream()));
            this.startTime_ = System.currentTimeMillis();
        }
        catch (IOException e) {
            LOG.error("configuration exception", (Throwable)e);
            throw new RuntimeException("configuration exception", e);
        }
        catch (InterruptedException e) {
            LOG.error("configuration exception", (Throwable)e);
            throw new RuntimeException("configuration exception", e);
        }
    }

    void setStreamJobDetails(JobConf job) {
        String s = job.get("stream.minRecWrittenToEnableSkip_");
        if (s != null) {
            this.minRecWrittenToEnableSkip_ = Long.parseLong(s);
            LOG.info("JobConf set minRecWrittenToEnableSkip_ =" + this.minRecWrittenToEnableSkip_);
        }
    }

    void addJobConfToEnvironment(JobConf jobconf, Properties env) {
        JobConf conf = new JobConf((Configuration)jobconf);
        conf.setDeprecatedProperties();
        int lenLimit = conf.getInt("stream.jobconf.truncate.limit", -1);
        for (Map.Entry confEntry : conf) {
            String name = (String)confEntry.getKey();
            String value = conf.get(name);
            name = this.safeEnvVarName(name);
            if (lenLimit > -1 && value.length() > lenLimit) {
                LOG.warn("Environment variable " + name + " truncated to " + lenLimit + " to  fit system limits.");
                value = value.substring(0, lenLimit);
            }
            this.envPut(env, name, value);
        }
    }

    String safeEnvVarName(String var) {
        StringBuilder safe = new StringBuilder();
        int len = var.length();
        for (int i = 0; i < len; ++i) {
            int c = var.charAt(i);
            int s = c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 ? c : 95;
            safe.append((char)s);
        }
        return safe.toString();
    }

    void addEnvironment(Properties env, String nameVals) {
        if (nameVals == null) {
            return;
        }
        String[] nv = nameVals.split(" ");
        for (int i = 0; i < nv.length; ++i) {
            String[] pair = nv[i].split("=", 2);
            if (pair.length != 2) {
                LOG.info("Skip env entry:" + nv[i]);
                continue;
            }
            this.envPut(env, pair[0], pair[1]);
        }
    }

    void envPut(Properties env, String name, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add  env entry:" + name + "=" + value);
        }
        env.put(name, value);
    }

    void startOutputThreads(OutputCollector output, Reporter reporter) throws IOException {
        this.inWriter_ = this.createInputWriter();
        this.outReader_ = this.createOutputReader();
        this.outThread_ = new MROutputThread(this.outReader_, output, reporter);
        this.outThread_.start();
        this.errThread_ = new MRErrorThread();
        this.errThread_.setReporter(reporter);
        this.errThread_.start();
    }

    void waitOutputThreads() throws IOException {
        try {
            int exitVal;
            if (this.outThread_ == null) {
                OutputCollector collector = new OutputCollector(){

                    public void collect(Object key, Object value) throws IOException {
                    }
                };
                Reporter reporter = Reporter.NULL;
                this.startOutputThreads(collector, reporter);
            }
            if ((exitVal = this.sim.waitFor()) != 0) {
                if (this.nonZeroExitIsFailure_) {
                    throw new RuntimeException("PipeMapRed.waitOutputThreads(): subprocess failed with code " + exitVal);
                }
                LOG.info("PipeMapRed.waitOutputThreads(): subprocess exited with code " + exitVal + " in " + PipeMapRed.class.getName());
            }
            if (this.outThread_ != null) {
                this.outThread_.join(this.joinDelay_);
            }
            if (this.errThread_ != null) {
                this.errThread_.join(this.joinDelay_);
            }
            if (this.outerrThreadsThrowable != null) {
                throw new RuntimeException(this.outerrThreadsThrowable);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    abstract InputWriter createInputWriter() throws IOException;

    InputWriter createInputWriter(Class<? extends InputWriter> inputWriterClass) throws IOException {
        InputWriter inputWriter = (InputWriter)ReflectionUtils.newInstance(inputWriterClass, (Configuration)this.job_);
        inputWriter.initialize(this);
        return inputWriter;
    }

    abstract OutputReader createOutputReader() throws IOException;

    OutputReader createOutputReader(Class<? extends OutputReader> outputReaderClass) throws IOException {
        OutputReader outputReader = (OutputReader)ReflectionUtils.newInstance(outputReaderClass, (Configuration)this.job_);
        outputReader.initialize(this);
        return outputReader;
    }

    public void mapRedFinished() {
        try {
            if (!this.doPipe_) {
                LOG.info("mapRedFinished");
                return;
            }
            if (this.clientOut_ != null) {
                try {
                    this.clientOut_.flush();
                    this.clientOut_.close();
                }
                catch (IOException io) {
                    LOG.warn("{}", (Throwable)io);
                }
            }
            try {
                this.waitOutputThreads();
            }
            catch (IOException io) {
                LOG.warn("{}", (Throwable)io);
            }
            if (this.sim != null) {
                this.sim.destroy();
            }
            LOG.info("mapRedFinished");
        }
        catch (RuntimeException e) {
            LOG.info("PipeMapRed failed!", (Throwable)e);
            throw e;
        }
    }

    void maybeLogRecord() {
        if (this.numRecRead_ >= this.nextRecReadLog_) {
            String info = this.numRecInfo();
            LOG.info(info);
            this.nextRecReadLog_ = this.nextRecReadLog_ < 100000L ? (this.nextRecReadLog_ *= 10L) : (this.nextRecReadLog_ += 100000L);
        }
    }

    public String getContext() {
        String s = this.numRecInfo() + "\n";
        s = s + "minRecWrittenToEnableSkip_=" + this.minRecWrittenToEnableSkip_ + " ";
        s = s + this.envline("HOST");
        s = s + this.envline("USER");
        s = s + this.envline("HADOOP_USER");
        if (this.outThread_ != null) {
            s = s + "last tool output: |" + this.outReader_.getLastOutput() + "|\n";
        }
        return s;
    }

    String envline(String var) {
        return var + "=" + StreamUtil.env().get(var) + "\n";
    }

    String numRecInfo() {
        long elapsed = (System.currentTimeMillis() - this.startTime_) / 1000L;
        return "R/W/S=" + this.numRecRead_ + "/" + this.numRecWritten_ + "/" + this.numRecSkipped_ + " in:" + this.safeDiv(this.numRecRead_, elapsed) + " [rec/s] out:" + this.safeDiv(this.numRecWritten_, elapsed) + " [rec/s]";
    }

    String safeDiv(long n, long d) {
        return d == 0L ? "NA" : n / d + "=" + n + "/" + d;
    }

    class MROutputThread
    extends Thread {
        OutputReader outReader = null;
        OutputCollector outCollector = null;
        Reporter reporter = null;
        long lastStdoutReport = 0L;

        MROutputThread(OutputReader outReader, OutputCollector outCollector, Reporter reporter) {
            this.setDaemon(true);
            this.outReader = outReader;
            this.outCollector = outCollector;
            this.reporter = reporter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.outReader.readKeyValue()) {
                    Object key = this.outReader.getCurrentKey();
                    Object value = this.outReader.getCurrentValue();
                    this.outCollector.collect(key, value);
                    ++PipeMapRed.this.numRecWritten_;
                    long now = System.currentTimeMillis();
                    if (now - this.lastStdoutReport <= PipeMapRed.this.reporterOutDelay_) continue;
                    this.lastStdoutReport = now;
                    String hline = "Records R/W=" + PipeMapRed.this.numRecRead_ + "/" + PipeMapRed.this.numRecWritten_;
                    if (!PipeMapRed.this.processProvidedStatus_) {
                        this.reporter.setStatus(hline);
                    } else {
                        this.reporter.progress();
                    }
                    LOG.info(hline);
                }
            }
            catch (Throwable th) {
                PipeMapRed.this.outerrThreadsThrowable = th;
                LOG.warn("{}", th);
            }
            finally {
                try {
                    if (PipeMapRed.this.clientIn_ != null) {
                        PipeMapRed.this.clientIn_.close();
                        PipeMapRed.this.clientIn_ = null;
                    }
                }
                catch (IOException io) {
                    LOG.info("{}", (Throwable)io);
                }
            }
        }
    }

    class MRErrorThread
    extends Thread {
        long lastStderrReport = 0L;
        volatile Reporter reporter;
        private final String reporterPrefix;
        private final String counterPrefix;
        private final String statusPrefix;

        public MRErrorThread() {
            this.reporterPrefix = PipeMapRed.this.job_.get("stream.stderr.reporter.prefix", "reporter:");
            this.counterPrefix = this.reporterPrefix + "counter:";
            this.statusPrefix = this.reporterPrefix + "status:";
            this.setDaemon(true);
        }

        public void setReporter(Reporter reporter) {
            this.reporter = reporter;
        }

        @Override
        public void run() {
            Text line = new Text();
            LineReader lineReader = null;
            try {
                lineReader = new LineReader((InputStream)PipeMapRed.this.clientErr_, (Configuration)PipeMapRed.this.job_);
                while (lineReader.readLine(line) > 0) {
                    String lineStr = line.toString();
                    if (this.matchesReporter(lineStr)) {
                        if (this.matchesCounter(lineStr)) {
                            this.incrCounter(lineStr);
                        } else if (this.matchesStatus(lineStr)) {
                            PipeMapRed.this.processProvidedStatus_ = true;
                            this.setStatus(lineStr);
                        } else {
                            LOG.warn("Cannot parse reporter line: " + lineStr);
                        }
                    } else {
                        System.err.println(lineStr);
                    }
                    long now = System.currentTimeMillis();
                    if (this.reporter != null && now - this.lastStderrReport > PipeMapRed.this.reporterErrDelay_) {
                        this.lastStderrReport = now;
                        this.reporter.progress();
                    }
                    line.clear();
                }
                if (lineReader != null) {
                    lineReader.close();
                }
                if (PipeMapRed.this.clientErr_ != null) {
                    PipeMapRed.this.clientErr_.close();
                    PipeMapRed.this.clientErr_ = null;
                    LOG.info("MRErrorThread done");
                }
            }
            catch (Throwable th) {
                PipeMapRed.this.outerrThreadsThrowable = th;
                LOG.warn("{}", th);
                try {
                    if (lineReader != null) {
                        lineReader.close();
                    }
                    if (PipeMapRed.this.clientErr_ != null) {
                        PipeMapRed.this.clientErr_.close();
                        PipeMapRed.this.clientErr_ = null;
                    }
                }
                catch (IOException io) {
                    LOG.info("{}", (Throwable)io);
                }
            }
        }

        private boolean matchesReporter(String line) {
            return line.startsWith(this.reporterPrefix);
        }

        private boolean matchesCounter(String line) {
            return line.startsWith(this.counterPrefix);
        }

        private boolean matchesStatus(String line) {
            return line.startsWith(this.statusPrefix);
        }

        private void incrCounter(String line) {
            String trimmedLine = line.substring(this.counterPrefix.length()).trim();
            String[] columns = trimmedLine.split(",");
            if (columns.length == 3) {
                try {
                    this.reporter.incrCounter(columns[0], columns[1], Long.parseLong(columns[2]));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Cannot parse counter increment '" + columns[2] + "' from line: " + line);
                }
            } else {
                LOG.warn("Cannot parse counter line: " + line);
            }
        }

        private void setStatus(String line) {
            this.reporter.setStatus(line.substring(this.statusPrefix.length()).trim());
        }
    }
}

