/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.streaming.Environment;

@InterfaceAudience.Private
public class StreamUtil {
    static final String regexpSpecials = "[]()?*+|.!^-\\~@";
    private static Environment env;
    private static String host;

    public static Class goodClassOrNull(Configuration conf, String className, String defaultPackage) {
        Class clazz = null;
        try {
            clazz = conf.getClassByName((String)className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null && ((String)className).indexOf(46) == -1 && defaultPackage != null) {
            className = defaultPackage + "." + (String)className;
            try {
                clazz = conf.getClassByName((String)className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    public static String findInClasspath(String className) {
        return StreamUtil.findInClasspath(className, StreamUtil.class.getClassLoader());
    }

    public static String findInClasspath(String className, ClassLoader loader) {
        String codePath;
        Object relPath = className;
        relPath = ((String)relPath).replace('.', '/');
        URL classUrl = loader.getResource((String)(relPath = (String)relPath + ".class"));
        if (classUrl != null) {
            boolean inJar = classUrl.getProtocol().equals("jar");
            codePath = classUrl.toString();
            if (codePath.startsWith("jar:")) {
                codePath = codePath.substring("jar:".length());
            }
            if (codePath.startsWith("file:")) {
                codePath = codePath.substring("file:".length());
            }
            if (inJar) {
                int bang = codePath.lastIndexOf(33);
                codePath = codePath.substring(0, bang);
            } else {
                int pos = codePath.lastIndexOf((String)relPath);
                if (pos == -1) {
                    throw new IllegalArgumentException("invalid codePath: className=" + className + " codePath=" + codePath);
                }
                codePath = codePath.substring(0, pos);
            }
        } else {
            codePath = null;
        }
        return codePath;
    }

    static String qualifyHost(String url) {
        try {
            return StreamUtil.qualifyHost(new URL(url)).toString();
        }
        catch (IOException io) {
            return url;
        }
    }

    static URL qualifyHost(URL url) {
        try {
            InetAddress a = InetAddress.getByName(url.getHost());
            String qualHost = a.getCanonicalHostName();
            URL q = new URL(url.getProtocol(), qualHost, url.getPort(), url.getFile());
            return q;
        }
        catch (IOException io) {
            return url;
        }
    }

    public static String regexpEscape(String plain) {
        StringBuffer buf = new StringBuffer();
        char[] ch = plain.toCharArray();
        int csup = ch.length;
        for (int c = 0; c < csup; ++c) {
            if (regexpSpecials.indexOf(ch[c]) != -1) {
                buf.append("\\");
            }
            buf.append(ch[c]);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String slurp(File f) throws IOException {
        int len = (int)f.length();
        byte[] buf = new byte[len];
        String contents = null;
        try (FileInputStream in = new FileInputStream(f);){
            in.read(buf, 0, len);
            contents = new String(buf, StandardCharsets.UTF_8);
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String slurpHadoop(Path p, FileSystem fs) throws IOException {
        int len = (int)fs.getFileStatus(p).getLen();
        byte[] buf = new byte[len];
        String contents = null;
        try (FSDataInputStream in = fs.open(p);){
            in.readFully(in.getPos(), buf);
            contents = new String(buf, StandardCharsets.UTF_8);
        }
        return contents;
    }

    public static String getHost() {
        return host;
    }

    static Environment env() {
        if (env != null) {
            return env;
        }
        try {
            env = new Environment();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return env;
    }

    public static boolean isLocalJobTracker(JobConf job) {
        String framework = job.get("mapreduce.framework.name", "local");
        return framework.equals("local");
    }

    static {
        try {
            env = new Environment();
            host = env.getHost();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }
}

