/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.appmaster;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.sls.AMDefinition;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.TaskRunner;
import org.apache.hadoop.yarn.sls.utils.SLSUtils;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class AMSimulator
extends TaskRunner.Task {
    private static final long FINISH_TIME_NOT_INITIALIZED = Long.MIN_VALUE;
    protected ResourceManager rm;
    protected SLSRunner se;
    protected ApplicationId appId;
    protected ApplicationAttemptId appAttemptId;
    protected String oldAppId;
    protected static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected final BlockingQueue<AllocateResponse> responseQueue;
    private int responseId = 0;
    private String user;
    private String nodeLabelExpression;
    protected String queue;
    protected String amtype;
    private long baselineTimeMS;
    protected long traceStartTimeMS;
    protected long traceFinishTimeMS;
    protected long simulateStartTimeMS;
    protected long simulateFinishTimeMS = Long.MIN_VALUE;
    protected boolean isTracked;
    protected int totalContainers;
    protected int finishedContainers;
    volatile boolean isAMContainerRunning = false;
    volatile Container amContainer;
    private static final Logger LOG = LoggerFactory.getLogger(AMSimulator.class);
    private Resource amContainerResource;
    private ReservationSubmissionRequest reservationRequest;
    private Map<ApplicationId, AMSimulator> appIdToAMSim;
    private Set<NodeId> ranNodes = new ConcurrentSkipListSet<NodeId>();

    public AMSimulator() {
        this.responseQueue = new LinkedBlockingQueue<AllocateResponse>();
    }

    public void init(AMDefinition amDef, ResourceManager rm, SLSRunner slsRunner, boolean tracked, long baselineTimeMS, long heartbeatInterval, Map<ApplicationId, AMSimulator> appIdToAMSim) {
        long startTime = amDef.getJobStartTime();
        long endTime = startTime + 1000000L * heartbeatInterval;
        super.init(startTime, endTime, heartbeatInterval);
        this.user = amDef.getUser();
        this.queue = amDef.getQueue();
        this.oldAppId = amDef.getOldAppId();
        this.amContainerResource = amDef.getAmResource();
        this.nodeLabelExpression = amDef.getLabelExpression();
        this.traceStartTimeMS = amDef.getJobStartTime();
        this.traceFinishTimeMS = amDef.getJobFinishTime();
        this.rm = rm;
        this.se = slsRunner;
        this.isTracked = tracked;
        this.baselineTimeMS = baselineTimeMS;
        this.appIdToAMSim = appIdToAMSim;
    }

    @Override
    public void firstStep() throws Exception {
        this.simulateStartTimeMS = System.currentTimeMillis() - this.baselineTimeMS;
        ReservationId reservationId = null;
        try {
            reservationId = this.submitReservationWhenSpecified();
        }
        catch (UndeclaredThrowableException y) {
            LOG.warn("Unable to place reservation: " + y.getMessage());
        }
        this.submitApp(reservationId);
        this.appIdToAMSim.put(this.appId, this);
        this.trackApp();
    }

    public synchronized void notifyAMContainerLaunched(Container masterContainer) throws Exception {
        this.amContainer = masterContainer;
        this.appAttemptId = masterContainer.getId().getApplicationAttemptId();
        this.registerAM();
        this.isAMContainerRunning = true;
    }

    protected void setReservationRequest(ReservationSubmissionRequest rr) {
        this.reservationRequest = rr;
    }

    private ReservationId submitReservationWhenSpecified() throws IOException, InterruptedException {
        if (this.reservationRequest != null) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.user);
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws YarnException, IOException {
                    AMSimulator.this.rm.getClientRMService().submitReservation(AMSimulator.this.reservationRequest);
                    LOG.info("RESERVATION SUCCESSFULLY SUBMITTED " + AMSimulator.this.reservationRequest.getReservationId());
                    return null;
                }
            });
            return this.reservationRequest.getReservationId();
        }
        return null;
    }

    @Override
    public void middleStep() throws Exception {
        if (this.isAMContainerRunning) {
            this.processResponseQueue();
            this.sendContainerRequest();
            this.checkStop();
        }
    }

    @Override
    public void lastStep() throws Exception {
        if (this.simulateFinishTimeMS != Long.MIN_VALUE) {
            LOG.warn("Method AMSimulator#lastStep was already called. Skipping execution of method for application: {}", (Object)this.appId);
            return;
        }
        LOG.info("Application {} is shutting down.", (Object)this.appId);
        if (this.isTracked) {
            this.untrackApp();
        }
        if (this.amContainer != null) {
            LOG.info("AM container = {} reported to finish", (Object)this.amContainer.getId());
            this.se.getNmMap().get(this.amContainer.getNodeId()).cleanupContainer(this.amContainer.getId());
        } else {
            LOG.info("AM container is null");
        }
        for (NodeId nodeId : this.ranNodes) {
            this.se.getNmMap().get(nodeId).finishApplication(this.getApplicationId());
        }
        if (null == this.appAttemptId) {
            return;
        }
        final FinishApplicationMasterRequest finishAMRequest = (FinishApplicationMasterRequest)recordFactory.newRecordInstance(FinishApplicationMasterRequest.class);
        finishAMRequest.setFinalApplicationStatus(FinalApplicationStatus.SUCCEEDED);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appId)).getRMAppAttempt(this.appAttemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                AMSimulator.this.rm.getApplicationMasterService().finishApplicationMaster(finishAMRequest);
                return null;
            }
        });
        this.simulateFinishTimeMS = System.currentTimeMillis() - this.baselineTimeMS;
        SchedulerMetrics schedulerMetrics = ((SchedulerWrapper)this.rm.getResourceScheduler()).getSchedulerMetrics();
        if (schedulerMetrics != null) {
            schedulerMetrics.addAMRuntime(this.appId, this.traceStartTimeMS, this.traceFinishTimeMS, this.simulateStartTimeMS, this.simulateFinishTimeMS);
        }
    }

    protected ResourceRequest createResourceRequest(Resource resource, ExecutionType executionType, String host, int priority, long allocationId, int numContainers) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        request.setCapability(resource);
        request.setResourceName(host);
        request.setNumContainers(numContainers);
        request.setExecutionTypeRequest(ExecutionTypeRequest.newInstance((ExecutionType)executionType));
        Priority prio = (Priority)recordFactory.newRecordInstance(Priority.class);
        prio.setPriority(priority);
        request.setPriority(prio);
        request.setAllocationRequestId(allocationId);
        return request;
    }

    protected AllocateRequest createAllocateRequest(List<ResourceRequest> ask, List<ContainerId> toRelease) {
        AllocateRequest allocateRequest = (AllocateRequest)recordFactory.newRecordInstance(AllocateRequest.class);
        allocateRequest.setResponseId(this.responseId++);
        allocateRequest.setAskList(ask);
        allocateRequest.setReleaseList(toRelease);
        return allocateRequest;
    }

    protected AllocateRequest createAllocateRequest(List<ResourceRequest> ask) {
        return this.createAllocateRequest(ask, new ArrayList<ContainerId>());
    }

    protected abstract void processResponseQueue() throws Exception;

    protected abstract void sendContainerRequest() throws Exception;

    public abstract void initReservation(ReservationId var1, long var2, long var4);

    protected abstract void checkStop();

    private void submitApp(ReservationId reservationId) throws YarnException, InterruptedException, IOException {
        GetNewApplicationRequest newAppRequest = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
        GetNewApplicationResponse newAppResponse = this.rm.getClientRMService().getNewApplication(newAppRequest);
        this.appId = newAppResponse.getApplicationId();
        final SubmitApplicationRequest subAppRequest = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        ApplicationSubmissionContext appSubContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        appSubContext.setApplicationId(this.appId);
        appSubContext.setMaxAppAttempts(1);
        appSubContext.setQueue(this.queue);
        appSubContext.setPriority(Priority.newInstance((int)0));
        ContainerLaunchContext conLauContext = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        conLauContext.setApplicationACLs(new HashMap());
        conLauContext.setCommands(new ArrayList());
        conLauContext.setEnvironment(new HashMap());
        conLauContext.setLocalResources(new HashMap());
        conLauContext.setServiceData(new HashMap());
        appSubContext.setAMContainerSpec(conLauContext);
        appSubContext.setResource(this.amContainerResource);
        if (this.nodeLabelExpression != null) {
            appSubContext.setNodeLabelExpression(this.nodeLabelExpression);
        }
        if (reservationId != null) {
            appSubContext.setReservationID(reservationId);
        }
        subAppRequest.setApplicationSubmissionContext(appSubContext);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.user);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws YarnException, IOException {
                AMSimulator.this.rm.getClientRMService().submitApplication(subAppRequest);
                return null;
            }
        });
        LOG.info("Submit a new application {}", (Object)this.appId);
    }

    private void registerAM() throws YarnException, IOException, InterruptedException {
        final RegisterApplicationMasterRequest amRegisterRequest = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        amRegisterRequest.setHost("localhost");
        amRegisterRequest.setRpcPort(1000);
        amRegisterRequest.setTrackingUrl("localhost:1000");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.appAttemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(this.appId)).getRMAppAttempt(this.appAttemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RegisterApplicationMasterResponse>(){

            @Override
            public RegisterApplicationMasterResponse run() throws Exception {
                return AMSimulator.this.rm.getApplicationMasterService().registerApplicationMaster(amRegisterRequest);
            }
        });
        LOG.info("Register the application master for application {}", (Object)this.appId);
    }

    private void trackApp() {
        SchedulerMetrics schedulerMetrics;
        if (this.isTracked && (schedulerMetrics = ((SchedulerWrapper)this.rm.getResourceScheduler()).getSchedulerMetrics()) != null) {
            schedulerMetrics.addTrackedApp(this.appId, this.oldAppId);
        }
    }

    public void untrackApp() {
        SchedulerMetrics schedulerMetrics;
        if (this.isTracked && (schedulerMetrics = ((SchedulerWrapper)this.rm.getResourceScheduler()).getSchedulerMetrics()) != null) {
            schedulerMetrics.removeTrackedApp(this.oldAppId);
        }
    }

    protected List<ResourceRequest> packageRequests(List<ContainerSimulator> csList, int priority) {
        HashMap<Long, Map<CallSite, ResourceRequest>> rackLocalRequests = new HashMap<Long, Map<CallSite, ResourceRequest>>();
        HashMap<Long, Map<String, ResourceRequest>> nodeLocalRequests = new HashMap<Long, Map<String, ResourceRequest>>();
        HashMap<Long, ResourceRequest> anyRequests = new HashMap<Long, ResourceRequest>();
        for (ContainerSimulator cs : csList) {
            long allocationId = cs.getAllocationId();
            ResourceRequest anyRequest = (ResourceRequest)anyRequests.get(allocationId);
            if (cs.getHostname() != null) {
                Map<String, ResourceRequest> nodeLocalRequestMap;
                Map<CallSite, ResourceRequest> rackLocalRequestMap;
                if (rackLocalRequests.containsKey(allocationId)) {
                    rackLocalRequestMap = (Map)rackLocalRequests.get(allocationId);
                } else {
                    rackLocalRequestMap = new HashMap();
                    rackLocalRequests.put(allocationId, rackLocalRequestMap);
                }
                String[] rackHostNames = SLSUtils.getRackHostName(cs.getHostname());
                String rackname = "/" + rackHostNames[0];
                if (rackLocalRequestMap.containsKey(rackname)) {
                    ((ResourceRequest)rackLocalRequestMap.get(rackname)).setNumContainers(((ResourceRequest)rackLocalRequestMap.get(rackname)).getNumContainers() + 1);
                } else {
                    ResourceRequest request = this.createResourceRequest(cs.getResource(), cs.getExecutionType(), rackname, priority, cs.getAllocationId(), 1);
                    rackLocalRequestMap.put((CallSite)((Object)rackname), request);
                }
                if (nodeLocalRequests.containsKey(allocationId)) {
                    nodeLocalRequestMap = (Map)nodeLocalRequests.get(allocationId);
                } else {
                    nodeLocalRequestMap = new HashMap();
                    nodeLocalRequests.put(allocationId, nodeLocalRequestMap);
                }
                String hostname = rackHostNames[1];
                if (nodeLocalRequestMap.containsKey(hostname)) {
                    ((ResourceRequest)nodeLocalRequestMap.get(hostname)).setNumContainers(((ResourceRequest)nodeLocalRequestMap.get(hostname)).getNumContainers() + 1);
                } else {
                    ResourceRequest request = this.createResourceRequest(cs.getResource(), cs.getExecutionType(), hostname, priority, cs.getAllocationId(), 1);
                    nodeLocalRequestMap.put(hostname, request);
                }
            }
            if (anyRequest == null) {
                anyRequest = this.createResourceRequest(cs.getResource(), cs.getExecutionType(), "*", priority, cs.getAllocationId(), 1);
                anyRequests.put(allocationId, anyRequest);
                continue;
            }
            anyRequest.setNumContainers(anyRequest.getNumContainers() + 1);
        }
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        for (Map nodeLocalRequestMap : nodeLocalRequests.values()) {
            ask.addAll(nodeLocalRequestMap.values());
        }
        for (Map rackLocalRequestMap : rackLocalRequests.values()) {
            ask.addAll(rackLocalRequestMap.values());
        }
        ask.addAll(anyRequests.values());
        return ask;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getAMType() {
        return this.amtype;
    }

    public long getDuration() {
        return this.simulateFinishTimeMS - this.simulateStartTimeMS;
    }

    public int getNumTasks() {
        return this.totalContainers;
    }

    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    public Set<NodeId> getRanNodes() {
        return this.ranNodes;
    }
}

