/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.common.config.ResourceEstimatorConfiguration;
import org.apache.hadoop.resourceestimator.common.config.ResourceEstimatorUtil;
import org.apache.hadoop.resourceestimator.common.exception.ResourceEstimatorException;
import org.apache.hadoop.resourceestimator.common.serialization.RLESparseResourceAllocationSerDe;
import org.apache.hadoop.resourceestimator.common.serialization.ResourceSerDe;
import org.apache.hadoop.resourceestimator.skylinestore.api.SkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.resourceestimator.solver.api.Solver;
import org.apache.hadoop.resourceestimator.solver.exceptions.SolverException;
import org.apache.hadoop.resourceestimator.translator.api.LogParser;
import org.apache.hadoop.resourceestimator.translator.impl.LogParserUtil;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/resourceestimator")
public class ResourceEstimatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceEstimatorService.class);
    private final SkylineStore skylineStore;
    private final Solver solver;
    private final LogParser logParser;
    private final LogParserUtil logParserUtil = new LogParserUtil();
    private final Configuration config;
    private final Gson gson;
    private final Type rleType;
    private final Type skylineStoreType;

    public ResourceEstimatorService() throws ResourceEstimatorException {
        try {
            this.config = new Configuration();
            this.config.addResource("resourceestimator-config.xml");
            this.skylineStore = ResourceEstimatorUtil.createProviderInstance(this.config, "resourceestimator.skylinestore.provider", ResourceEstimatorConfiguration.DEFAULT_SKYLINESTORE_PROVIDER, SkylineStore.class);
            this.logParser = ResourceEstimatorUtil.createProviderInstance(this.config, "resourceestimator.translator.provider", ResourceEstimatorConfiguration.DEFAULT_TRANSLATOR_PROVIDER, LogParser.class);
            this.logParser.init(this.config, this.skylineStore);
            this.logParserUtil.setLogParser(this.logParser);
            this.solver = ResourceEstimatorUtil.createProviderInstance(this.config, "resourceestimator.solver.provider", ResourceEstimatorConfiguration.DEFAULT_SOLVER_PROVIDER, Solver.class);
            this.solver.init(this.config, this.skylineStore);
        }
        catch (Exception ex) {
            LOGGER.error("Server initialization failed due to: {}", (Object)ex.getMessage());
            throw new ResourceEstimatorException(ex.getMessage(), ex);
        }
        this.gson = new GsonBuilder().registerTypeAdapter(Resource.class, (Object)new ResourceSerDe()).registerTypeAdapter(RLESparseResourceAllocation.class, (Object)new RLESparseResourceAllocationSerDe()).enableComplexMapKeySerialization().create();
        this.rleType = new TypeToken<RLESparseResourceAllocation>(){}.getType();
        this.skylineStoreType = new TypeToken<Map<RecurrenceId, List<ResourceSkyline>>>(){}.getType();
    }

    @POST
    @Path(value="/translator/{logFile : .+}")
    public void parseFile(@PathParam(value="logFile") String logFile) throws IOException, SkylineStoreException, ResourceEstimatorException {
        this.logParserUtil.parseLog(logFile);
        LOGGER.debug("Parse logFile: {}.", (Object)logFile);
    }

    @GET
    @Path(value="/estimator/{pipelineId}")
    @Produces(value={"application/json"})
    public String getPrediction(@PathParam(value="pipelineId") String pipelineId) throws SolverException, SkylineStoreException {
        RLESparseResourceAllocation result = this.skylineStore.getEstimation(pipelineId);
        if (result == null) {
            RecurrenceId recurrenceId = new RecurrenceId(pipelineId, "*");
            Map<RecurrenceId, List<ResourceSkyline>> jobHistory = this.skylineStore.getHistory(recurrenceId);
            result = this.solver.solve(jobHistory);
        }
        String prediction = this.gson.toJson((Object)result, this.rleType);
        LOGGER.debug("Predict resource requests for pipelineId: {}.", (Object)pipelineId);
        return prediction;
    }

    @GET
    @Path(value="/skylinestore/history/{pipelineId}/{runId}")
    @Produces(value={"application/json"})
    public String getHistoryResourceSkyline(@PathParam(value="pipelineId") String pipelineId, @PathParam(value="runId") String runId) throws SkylineStoreException {
        RecurrenceId recurrenceId = new RecurrenceId(pipelineId, runId);
        Map<RecurrenceId, List<ResourceSkyline>> jobHistory = this.skylineStore.getHistory(recurrenceId);
        String skyline = this.gson.toJson(jobHistory, this.skylineStoreType);
        LOGGER.debug("Query the skyline store for recurrenceId: {}.", (Object)recurrenceId);
        return skyline;
    }

    @GET
    @Path(value="/skylinestore/estimation/{pipelineId}")
    @Produces(value={"application/json"})
    public String getEstimatedResourceAllocation(@PathParam(value="pipelineId") String pipelineId) throws SkylineStoreException {
        RLESparseResourceAllocation result = this.skylineStore.getEstimation(pipelineId);
        String skyline = this.gson.toJson((Object)result, this.rleType);
        LOGGER.debug("Query the skyline store for pipelineId: {}.", (Object)pipelineId);
        return skyline;
    }

    @DELETE
    @Path(value="/skylinestore/history/{pipelineId}/{runId}")
    public void deleteHistoryResourceSkyline(@PathParam(value="pipelineId") String pipelineId, @PathParam(value="runId") String runId) throws SkylineStoreException {
        RecurrenceId recurrenceId = new RecurrenceId(pipelineId, runId);
        this.skylineStore.deleteHistory(recurrenceId);
        LOGGER.info("Delete ResourceSkyline for recurrenceId: {}.", (Object)recurrenceId);
    }
}

