/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.impl;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.exceptions.InvalidPathnameException;
import org.apache.hadoop.registry.client.impl.FSRegistryOperationsService;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFSRegistryOperationsService {
    private static FSRegistryOperationsService registry = new FSRegistryOperationsService();
    private static FileSystem fs;

    @BeforeAll
    public static void initRegistry() throws IOException {
        Assertions.assertNotNull((Object)registry);
        registry.init(new Configuration());
        fs = registry.getFs();
        fs.delete(new Path("test"), true);
    }

    @BeforeEach
    public void createTestDir() throws IOException {
        fs.mkdirs(new Path("test"));
    }

    @AfterEach
    public void cleanTestDir() throws IOException {
        fs.delete(new Path("test"), true);
    }

    @Test
    public void testMkNodeNonRecursive() throws InvalidPathnameException, PathNotFoundException, IOException {
        boolean result = false;
        System.out.println("Make node with parent already made, nonrecursive");
        result = registry.mknode("test/registryTestNode", false);
        Assertions.assertTrue((boolean)result);
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode")));
        try {
            System.out.println("Try to make node with no parent, nonrecursive");
            registry.mknode("test/parent/registryTestNode", false);
            Assertions.fail((String)"Should not have created node");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)fs.exists(new Path("test/parent/registryTestNode")));
    }

    @Test
    public void testMkNodeRecursive() throws IOException {
        boolean result = false;
        System.out.println("Make node with parent already made, recursive");
        result = registry.mknode("test/registryTestNode", true);
        Assertions.assertTrue((boolean)result);
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode")));
        result = false;
        System.out.println("Try to make node with no parent, recursive");
        result = registry.mknode("test/parent/registryTestNode", true);
        Assertions.assertTrue((boolean)result);
        Assertions.assertTrue((boolean)fs.exists(new Path("test/parent/registryTestNode")));
    }

    @Test
    public void testMkNodeAlreadyExists() throws IOException {
        System.out.println("pre-create test path");
        fs.mkdirs(new Path("test/registryTestNode"));
        System.out.println("Try to mknode existing path -- should be noop and return false");
        Assertions.assertFalse((boolean)registry.mknode("test/registryTestNode", true));
        Assertions.assertFalse((boolean)registry.mknode("test/registryTestNode", false));
    }

    @Test
    public void testBindParentPath() throws InvalidPathnameException, PathNotFoundException, FileAlreadyExistsException, IOException {
        ServiceRecord record = this.createRecord("0");
        System.out.println("pre-create test path");
        fs.mkdirs(new Path("test/parent1/registryTestNode"));
        registry.bind("test/parent1/registryTestNode", record, 1);
        Assertions.assertTrue((boolean)fs.exists(new Path("test/parent1/registryTestNode/_record")));
        registry.bind("test/parent2/registryTestNode", record, 1);
        Assertions.assertTrue((boolean)fs.exists(new Path("test/parent2/registryTestNode")));
    }

    @Test
    public void testBindAlreadyExists() throws IOException {
        ServiceRecord record1 = this.createRecord("1");
        ServiceRecord record2 = this.createRecord("2");
        System.out.println("Bind record1");
        registry.bind("test/registryTestNode", record1, 1);
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/_record")));
        System.out.println("Bind record2, overwrite = 1");
        registry.bind("test/registryTestNode", record2, 1);
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/_record")));
        ServiceRecord readRecord = registry.resolve("test/registryTestNode");
        Assertions.assertTrue((boolean)readRecord.equals((Object)record2));
        System.out.println("Bind record3, overwrite = 0");
        try {
            registry.bind("test/registryTestNode", record1, 0);
            Assertions.fail((String)"Should not overwrite record");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        readRecord = registry.resolve("test/registryTestNode");
        Assertions.assertTrue((boolean)readRecord.equals((Object)record2));
    }

    @Test
    public void testResolve() throws IOException {
        ServiceRecord record = this.createRecord("0");
        registry.bind("test/registryTestNode", record, 1);
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/_record")));
        System.out.println("Read record that exists");
        ServiceRecord readRecord = registry.resolve("test/registryTestNode");
        Assertions.assertNotNull((Object)readRecord);
        Assertions.assertTrue((boolean)record.equals((Object)readRecord));
        System.out.println("Try to read record that does not exist");
        try {
            readRecord = registry.resolve("test/nonExistentNode");
            Assertions.fail((String)"Should throw an error, record does not exist");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testExists() throws IOException {
        System.out.println("pre-create test path");
        fs.mkdirs(new Path("test/registryTestNode"));
        System.out.println("Check for existing node");
        boolean exists = registry.exists("test/registryTestNode");
        Assertions.assertTrue((boolean)exists);
        System.out.println("Check for  non-existing node");
        exists = registry.exists("test/nonExistentNode");
        Assertions.assertFalse((boolean)exists);
    }

    @Test
    public void testDeleteDirsOnly() throws IOException {
        System.out.println("pre-create test path with children");
        fs.mkdirs(new Path("test/registryTestNode"));
        fs.mkdirs(new Path("test/registryTestNode/child1"));
        fs.mkdirs(new Path("test/registryTestNode/child2"));
        try {
            registry.delete("test/registryTestNode", false);
            Assertions.fail((String)"Deleted dir wich children, nonrecursive flag set");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode")));
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/child1")));
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/child2")));
        System.out.println("Delete leaf path 'test/registryTestNode/child2'");
        registry.delete("test/registryTestNode/child2", false);
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode")));
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/child1")));
        Assertions.assertFalse((boolean)fs.exists(new Path("test/registryTestNode/child2")));
        System.out.println("Recursively delete non-leaf path 'test/registryTestNode'");
        registry.delete("test/registryTestNode", true);
        Assertions.assertFalse((boolean)fs.exists(new Path("test/registryTestNode")));
    }

    @Test
    public void testDeleteWithRecords() throws IOException {
        System.out.println("pre-create test path with children and mocked records");
        fs.mkdirs(new Path("test/registryTestNode"));
        fs.mkdirs(new Path("test/registryTestNode/child1"));
        fs.mkdirs(new Path("test/registryTestNode/child2"));
        fs.create(new Path("test/registryTestNode/_record")).close();
        fs.create(new Path("test/registryTestNode/child1/_record")).close();
        System.out.println("Delete dir with child nodes and record file");
        try {
            registry.delete("test/registryTestNode", false);
            Assertions.fail((String)"Nonrecursive delete of non-empty dir");
        }
        catch (PathIsNotEmptyDirectoryException pathIsNotEmptyDirectoryException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/_record")));
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/child1/_record")));
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/child2")));
        System.out.println("Delete dir with record file and no child dirs");
        registry.delete("test/registryTestNode/child1", false);
        Assertions.assertFalse((boolean)fs.exists(new Path("test/registryTestNode/child1")));
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/child2")));
        System.out.println("Delete dir with child dir and no record file");
        try {
            registry.delete("test/registryTestNode", false);
            Assertions.fail((String)"Nonrecursive delete of non-empty dir");
        }
        catch (PathIsNotEmptyDirectoryException pathIsNotEmptyDirectoryException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)fs.exists(new Path("test/registryTestNode/child2")));
    }

    @Test
    public void testList() throws IOException {
        System.out.println("pre-create test path with children and mocked records");
        fs.mkdirs(new Path("test/registryTestNode"));
        fs.mkdirs(new Path("test/registryTestNode/child1"));
        fs.mkdirs(new Path("test/registryTestNode/child2"));
        fs.create(new Path("test/registryTestNode/_record")).close();
        fs.create(new Path("test/registryTestNode/child1/_record")).close();
        List ls = null;
        ls = registry.list("test/registryTestNode");
        Assertions.assertNotNull((Object)ls);
        Assertions.assertEquals((int)2, (int)ls.size());
        System.out.println(ls);
        Assertions.assertTrue((boolean)ls.contains("child1"));
        Assertions.assertTrue((boolean)ls.contains("child2"));
        ls = null;
        ls = registry.list("test/registryTestNode/child1");
        Assertions.assertNotNull((Object)ls);
        Assertions.assertTrue((boolean)ls.isEmpty());
        ls = null;
        ls = registry.list("test/registryTestNode/child2");
        Assertions.assertNotNull((Object)ls);
        Assertions.assertTrue((boolean)ls.isEmpty());
    }

    private ServiceRecord createRecord(String id) {
        System.out.println("Creating mock service record");
        ServiceRecord record = new ServiceRecord();
        record.set("yarn:id", (Object)id);
        record.description = "testRecord";
        return record;
    }
}

