/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.impl;

import java.io.IOException;
import java.util.List;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.AbstractZKRegistryTest;
import org.apache.hadoop.registry.client.impl.CuratorEventCatcher;
import org.apache.hadoop.registry.client.impl.zk.CuratorService;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCuratorService
extends AbstractZKRegistryTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestCuratorService.class);
    protected CuratorService curatorService;
    public static final String MISSING = "/missing";
    private List<ACL> rootACL;

    @BeforeEach
    public void startCurator() throws IOException {
        this.createCuratorService();
    }

    @AfterEach
    public void stopCurator() {
        ServiceOperations.stop((Service)this.curatorService);
    }

    protected void createCuratorService() throws IOException {
        this.curatorService = new CuratorService("curatorService");
        this.curatorService.init(this.createRegistryConfiguration());
        this.curatorService.start();
        this.rootACL = RegistrySecurity.WorldReadWriteACL;
        this.curatorService.maybeCreate("", CreateMode.PERSISTENT, this.rootACL, true);
    }

    @Test
    public void testLs() throws Throwable {
        this.curatorService.zkList("/");
    }

    @Test
    public void testLsNotFound() throws Throwable {
        TestCuratorService.assertThrows(PathNotFoundException.class, () -> {
            List ls = this.curatorService.zkList(MISSING);
        });
    }

    @Test
    public void testExists() throws Throwable {
        TestCuratorService.assertTrue((boolean)this.curatorService.zkPathExists("/"));
    }

    @Test
    public void testExistsMissing() throws Throwable {
        TestCuratorService.assertFalse((boolean)this.curatorService.zkPathExists(MISSING));
    }

    @Test
    public void testVerifyExists() throws Throwable {
        this.pathMustExist("/");
    }

    @Test
    public void testVerifyExistsMissing() throws Throwable {
        TestCuratorService.assertThrows(PathNotFoundException.class, () -> this.pathMustExist("/file-not-found"));
    }

    @Test
    public void testMkdirs() throws Throwable {
        this.mkPath("/p1", CreateMode.PERSISTENT);
        this.pathMustExist("/p1");
        this.mkPath("/p1/p2", CreateMode.EPHEMERAL);
        this.pathMustExist("/p1/p2");
    }

    private void mkPath(String path, CreateMode mode) throws IOException {
        this.curatorService.zkMkPath(path, mode, false, RegistrySecurity.WorldReadWriteACL);
    }

    public void pathMustExist(String path) throws IOException {
        this.curatorService.zkPathMustExist(path);
    }

    @Test
    public void testMkdirChild() throws Throwable {
        TestCuratorService.assertThrows(PathNotFoundException.class, () -> this.mkPath("/testMkdirChild/child", CreateMode.PERSISTENT));
    }

    @Test
    public void testMaybeCreate() throws Throwable {
        TestCuratorService.assertTrue((boolean)this.curatorService.maybeCreate("/p3", CreateMode.PERSISTENT, RegistrySecurity.WorldReadWriteACL, false));
        TestCuratorService.assertFalse((boolean)this.curatorService.maybeCreate("/p3", CreateMode.PERSISTENT, RegistrySecurity.WorldReadWriteACL, false));
    }

    @Test
    public void testRM() throws Throwable {
        this.mkPath("/rm", CreateMode.PERSISTENT);
        this.curatorService.zkDelete("/rm", false, null);
        this.verifyNotExists("/rm");
        this.curatorService.zkDelete("/rm", false, null);
    }

    @Test
    public void testRMNonRf() throws Throwable {
        this.mkPath("/rm", CreateMode.PERSISTENT);
        this.mkPath("/rm/child", CreateMode.PERSISTENT);
        try {
            this.curatorService.zkDelete("/rm", false, null);
            TestCuratorService.fail((String)"expected a failure");
        }
        catch (PathIsNotEmptyDirectoryException pathIsNotEmptyDirectoryException) {
            // empty catch block
        }
    }

    @Test
    public void testRMRf() throws Throwable {
        this.mkPath("/rm", CreateMode.PERSISTENT);
        this.mkPath("/rm/child", CreateMode.PERSISTENT);
        this.curatorService.zkDelete("/rm", true, null);
        this.verifyNotExists("/rm");
        this.curatorService.zkDelete("/rm", true, null);
    }

    @Test
    public void testBackgroundDelete() throws Throwable {
        this.mkPath("/rm", CreateMode.PERSISTENT);
        this.mkPath("/rm/child", CreateMode.PERSISTENT);
        CuratorEventCatcher events = new CuratorEventCatcher();
        this.curatorService.zkDelete("/rm", true, (BackgroundCallback)events);
        CuratorEvent taken = events.take();
        LOG.info("took {}", (Object)taken);
        TestCuratorService.assertEquals((int)1, (int)events.getCount());
    }

    @Test
    public void testCreate() throws Throwable {
        this.curatorService.zkCreate("/testcreate", CreateMode.PERSISTENT, this.getTestBuffer(), this.rootACL);
        this.pathMustExist("/testcreate");
    }

    @Test
    public void testCreateTwice() throws Throwable {
        byte[] buffer = this.getTestBuffer();
        this.curatorService.zkCreate("/testcreatetwice", CreateMode.PERSISTENT, buffer, this.rootACL);
        try {
            this.curatorService.zkCreate("/testcreatetwice", CreateMode.PERSISTENT, buffer, this.rootACL);
            TestCuratorService.fail();
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateUpdate() throws Throwable {
        byte[] buffer = this.getTestBuffer();
        this.curatorService.zkCreate("/testcreateupdate", CreateMode.PERSISTENT, buffer, this.rootACL);
        this.curatorService.zkUpdate("/testcreateupdate", buffer);
    }

    @Test
    public void testUpdateMissing() throws Throwable {
        TestCuratorService.assertThrows(PathNotFoundException.class, () -> this.curatorService.zkUpdate("/testupdatemissing", this.getTestBuffer()));
    }

    @Test
    public void testUpdateDirectory() throws Throwable {
        this.mkPath("/testupdatedirectory", CreateMode.PERSISTENT);
        this.curatorService.zkUpdate("/testupdatedirectory", this.getTestBuffer());
    }

    @Test
    public void testUpdateDirectorywithChild() throws Throwable {
        this.mkPath("/testupdatedirectorywithchild", CreateMode.PERSISTENT);
        this.mkPath("/testupdatedirectorywithchild/child", CreateMode.PERSISTENT);
        this.curatorService.zkUpdate("/testupdatedirectorywithchild", this.getTestBuffer());
    }

    @Test
    public void testUseZKServiceForBinding() throws Throwable {
        CuratorService cs2 = new CuratorService("curator", (RegistryBindingSource)zookeeper);
        cs2.init(new Configuration());
        cs2.start();
    }

    protected byte[] getTestBuffer() {
        byte[] buffer = new byte[]{48};
        return buffer;
    }

    public void verifyNotExists(String path) throws IOException {
        if (this.curatorService.zkPathExists(path)) {
            TestCuratorService.fail((String)("Path should not exist: " + path));
        }
    }
}

