/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.binding;

import org.apache.hadoop.registry.RegistryTestHelper;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=10L)
public class TestMarshalling
extends RegistryTestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TestMarshalling.class);
    private static RegistryUtils.ServiceRecordMarshal marshal;

    @BeforeAll
    public static void setupClass() {
        marshal = new RegistryUtils.ServiceRecordMarshal();
    }

    @Test
    public void testRoundTrip() throws Throwable {
        String persistence = "permanent";
        ServiceRecord record = TestMarshalling.createRecord(persistence);
        record.set("customkey", (Object)"customvalue");
        record.set("customkey2", (Object)"customvalue2");
        RegistryTypeUtils.validateServiceRecord((String)"", (ServiceRecord)record);
        LOG.info(marshal.toJson((Object)record));
        byte[] bytes = marshal.toBytes((Object)record);
        ServiceRecord r2 = (ServiceRecord)marshal.fromBytes("", bytes);
        TestMarshalling.assertMatches(record, r2);
        RegistryTypeUtils.validateServiceRecord((String)"", (ServiceRecord)r2);
    }

    @Test
    public void testUnmarshallNoData() throws Throwable {
        TestMarshalling.assertThrows(NoRecordException.class, () -> marshal.fromBytes("src", new byte[0]));
    }

    @Test
    public void testUnmarshallNotEnoughData() throws Throwable {
        TestMarshalling.assertThrows(NoRecordException.class, () -> marshal.fromBytes("src", new byte[]{123, 125}, "JSONServiceRecord"));
    }

    @Test
    public void testUnmarshallNoBody() throws Throwable {
        TestMarshalling.assertThrows(InvalidRecordException.class, () -> {
            byte[] bytes = "this is not valid JSON at all and should fail".getBytes();
            marshal.fromBytes("src", bytes);
        });
    }

    @Test
    public void testUnmarshallWrongType() throws Throwable {
        TestMarshalling.assertThrows(InvalidRecordException.class, () -> {
            byte[] bytes = "{'type':''}".getBytes();
            ServiceRecord serviceRecord = (ServiceRecord)marshal.fromBytes("marshalling", bytes);
            RegistryTypeUtils.validateServiceRecord((String)"validating", (ServiceRecord)serviceRecord);
        });
    }

    @Test
    public void testUnmarshallWrongLongType() throws Throwable {
        TestMarshalling.assertThrows(NoRecordException.class, () -> {
            ServiceRecord record = new ServiceRecord();
            record.type = "ThisRecordHasALongButNonMatchingType";
            byte[] bytes = marshal.toBytes((Object)record);
            ServiceRecord serviceRecord = (ServiceRecord)marshal.fromBytes("marshalling", bytes, "JSONServiceRecord");
        });
    }

    @Test
    public void testUnmarshallNoType() throws Throwable {
        TestMarshalling.assertThrows(NoRecordException.class, () -> {
            ServiceRecord record = new ServiceRecord();
            record.type = "NoRecord";
            byte[] bytes = marshal.toBytes((Object)record);
            ServiceRecord serviceRecord = (ServiceRecord)marshal.fromBytes("marshalling", bytes, "JSONServiceRecord");
        });
    }

    @Test
    public void testRecordValidationWrongType() throws Throwable {
        TestMarshalling.assertThrows(InvalidRecordException.class, () -> {
            ServiceRecord record = new ServiceRecord();
            record.type = "NotAServiceRecordType";
            RegistryTypeUtils.validateServiceRecord((String)"validating", (ServiceRecord)record);
        });
    }

    @Test
    public void testUnknownFieldsRoundTrip() throws Throwable {
        ServiceRecord record = TestMarshalling.createRecord("application-attempt");
        record.set("key", (Object)"value");
        record.set("intval", (Object)"2");
        TestMarshalling.assertEquals((Object)"value", (Object)record.get("key"));
        TestMarshalling.assertEquals((Object)"2", (Object)record.get("intval"));
        TestMarshalling.assertNull((Object)record.get("null"));
        TestMarshalling.assertEquals((Object)"defval", (Object)record.get("null", "defval"));
        byte[] bytes = marshal.toBytes((Object)record);
        ServiceRecord r2 = (ServiceRecord)marshal.fromBytes("", bytes);
        TestMarshalling.assertEquals((Object)"value", (Object)r2.get("key"));
        TestMarshalling.assertEquals((Object)"2", (Object)r2.get("intval"));
    }

    @Test
    public void testFieldPropagationInCopy() throws Throwable {
        ServiceRecord record = TestMarshalling.createRecord("application-attempt");
        record.set("key", (Object)"value");
        record.set("intval", (Object)"2");
        ServiceRecord that = new ServiceRecord(record);
        TestMarshalling.assertMatches(record, that);
    }
}

