/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.dns.RecordCreatorFactory;
import org.apache.hadoop.registry.server.dns.RegistryDNS;
import org.apache.hadoop.registry.server.dns.ServiceRecordProcessor;
import org.apache.hadoop.registry.server.dns.ZoneSelector;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

public abstract class BaseServiceRecordProcessor
implements ServiceRecordProcessor {
    private final ZoneSelector zoneSelctor;
    private Map<Integer, List<RecordDescriptor>> typeToDescriptorMap = new HashMap<Integer, List<RecordDescriptor>>();
    private String path;
    private String domain;
    private static final String YARN_SERVICE_API_PREFIX = "classpath:org.apache.hadoop.yarn.service.";
    private static final String HTTP_API_TYPE = "http://";

    public BaseServiceRecordProcessor(ServiceRecord record, String path, String domain, ZoneSelector zoneSelector) throws Exception {
        this.setPath(path);
        this.domain = domain;
        this.zoneSelctor = zoneSelector;
        this.initTypeToInfoMapping(record);
    }

    static InetAddress getIpv6Address(InetAddress address) throws UnknownHostException {
        String[] octets = address.getHostAddress().split("\\.");
        byte[] octetBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            octetBytes[i] = (byte)Integer.parseInt(octets[i]);
        }
        byte[] ipv4asIpV6addr = new byte[16];
        ipv4asIpV6addr[10] = -1;
        ipv4asIpV6addr[11] = -1;
        ipv4asIpV6addr[12] = octetBytes[0];
        ipv4asIpV6addr[13] = octetBytes[1];
        ipv4asIpV6addr[14] = octetBytes[2];
        ipv4asIpV6addr[15] = octetBytes[3];
        return Inet6Address.getByAddress(null, ipv4asIpV6addr, 0);
    }

    protected Name reverseIP(String ip) throws UnknownHostException {
        return ReverseMap.fromAddress((String)ip);
    }

    @Override
    public void manageDNSRecords(RegistryDNS.RegistryCommand command) throws IOException {
        for (Map.Entry<Integer, List<RecordDescriptor>> entry : this.typeToDescriptorMap.entrySet()) {
            for (RecordDescriptor recordDescriptor : entry.getValue()) {
                for (Name name : recordDescriptor.getNames()) {
                    RecordCreatorFactory.RecordCreator recordCreator = RecordCreatorFactory.getRecordCreator(entry.getKey());
                    command.exec(this.zoneSelctor.findBestZone(name), (Record)recordCreator.create(name, recordDescriptor.getTarget()));
                }
            }
        }
    }

    protected void registerRecordDescriptor(int type, RecordDescriptor recordDescriptor) {
        ArrayList<RecordDescriptor> infos = new ArrayList<RecordDescriptor>();
        infos.add(recordDescriptor);
        this.typeToDescriptorMap.put(type, infos);
    }

    protected void registerRecordDescriptor(int type, List<RecordDescriptor> recordDescriptors) {
        this.typeToDescriptorMap.put(type, recordDescriptors);
    }

    protected String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    abstract class RecordDescriptor<T> {
        private final ServiceRecord record;
        private Name[] names;
        private T target;

        public RecordDescriptor(ServiceRecord record) {
            this.record = record;
        }

        public Name[] getNames() {
            return this.names;
        }

        public T getTarget() {
            return this.target;
        }

        protected abstract void init(ServiceRecord var1) throws Exception;

        public ServiceRecord getRecord() {
            return this.record;
        }

        public void setNames(Name[] names) {
            this.names = names;
        }

        public void setTarget(T target) {
            this.target = target;
        }
    }

    abstract class ApplicationRecordDescriptor<T>
    extends RecordDescriptor<T> {
        private Endpoint srEndpoint;

        public ApplicationRecordDescriptor(ServiceRecord record) throws Exception {
            this(record, null);
        }

        public ApplicationRecordDescriptor(ServiceRecord record, Endpoint endpoint) throws Exception {
            super(record);
            this.setEndpoint(endpoint);
            this.init(record);
        }

        protected Name getServiceName() throws TextParseException {
            String user = RegistryPathUtils.getUsername(BaseServiceRecordProcessor.this.getPath());
            String service = String.format("%s.%s.%s", RegistryPathUtils.lastPathEntry(BaseServiceRecordProcessor.this.getPath()), user, BaseServiceRecordProcessor.this.domain);
            return Name.fromString((String)service);
        }

        protected String getHost(Endpoint endpoint) {
            String host = null;
            Map<String, String> address = endpoint.addresses.get(0);
            if (endpoint.addressType.equals("host/port")) {
                host = address.get("host");
            } else if (endpoint.addressType.equals("uri")) {
                URI uri = URI.create(address.get("uri"));
                host = uri.getHost();
            }
            return host;
        }

        protected int getPort(Endpoint endpoint) {
            int port = -1;
            Map<String, String> address = endpoint.addresses.get(0);
            if (endpoint.addressType.equals("host/port")) {
                port = Integer.parseInt(address.get("port"));
            } else if (endpoint.addressType.equals("uri")) {
                URI uri = URI.create(address.get("uri"));
                port = uri.getPort();
            }
            return port;
        }

        protected List<String> getTextRecords(Endpoint endpoint) {
            Map<String, String> address = endpoint.addresses.get(0);
            ArrayList<String> txtRecs = new ArrayList<String>();
            txtRecs.add("api=" + this.getDNSApiFragment(endpoint.api));
            if (endpoint.addressType.equals("uri")) {
                URI uri = URI.create(address.get("uri"));
                txtRecs.add("path=" + uri.getPath());
            }
            return txtRecs;
        }

        protected String getDNSApiFragment(String api) {
            String dnsApi = null;
            if (api.startsWith(BaseServiceRecordProcessor.YARN_SERVICE_API_PREFIX)) {
                dnsApi = api.substring(BaseServiceRecordProcessor.YARN_SERVICE_API_PREFIX.length());
            } else if (api.startsWith(BaseServiceRecordProcessor.HTTP_API_TYPE)) {
                dnsApi = "http";
            }
            assert (dnsApi != null);
            dnsApi = dnsApi.replace('.', '-');
            return dnsApi;
        }

        protected Name getEndpointName() throws TextParseException {
            return Name.fromString((String)String.format("%s-api.%s", this.getDNSApiFragment(this.getEndpoint().api), this.getServiceName()));
        }

        public Endpoint getEndpoint() {
            return this.srEndpoint;
        }

        public void setEndpoint(Endpoint endpoint) {
            this.srEndpoint = endpoint;
        }
    }

    abstract class ContainerRecordDescriptor<T>
    extends RecordDescriptor<T> {
        public ContainerRecordDescriptor(String path, ServiceRecord record) throws Exception {
            super(record);
            this.init(record);
        }

        protected Name getContainerIDName() throws TextParseException {
            String containerID = RegistryPathUtils.lastPathEntry(BaseServiceRecordProcessor.this.getPath());
            return Name.fromString((String)String.format("%s.%s", containerID, BaseServiceRecordProcessor.this.domain));
        }

        protected Name getContainerName() throws PathNotFoundException, TextParseException {
            String service = RegistryPathUtils.lastPathEntry(RegistryPathUtils.parentOf(RegistryPathUtils.parentOf(BaseServiceRecordProcessor.this.getPath())));
            String description = this.getRecord().description.toLowerCase();
            String user = RegistryPathUtils.getUsername(BaseServiceRecordProcessor.this.getPath());
            return Name.fromString((String)MessageFormat.format("{0}.{1}.{2}.{3}", description, service, user, BaseServiceRecordProcessor.this.domain));
        }

        protected Name getComponentName() throws PathNotFoundException, TextParseException {
            String service = RegistryPathUtils.lastPathEntry(RegistryPathUtils.parentOf(RegistryPathUtils.parentOf(BaseServiceRecordProcessor.this.getPath())));
            String component = this.getRecord().get("yarn:component").toLowerCase();
            String user = RegistryPathUtils.getUsername(BaseServiceRecordProcessor.this.getPath());
            return Name.fromString((String)MessageFormat.format("{0}.{1}.{2}.{3}", component, service, user, BaseServiceRecordProcessor.this.domain));
        }
    }
}

