/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.net.UnknownHostException;
import org.apache.hadoop.registry.server.dns.ReverseZoneUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReverseZoneUtils {
    private static final String NET = "172.17.4.0";
    private static final int RANGE = 256;
    private static final int INDEX = 0;

    @Test
    public void testGetReverseZoneNetworkAddress() throws Exception {
        Assertions.assertEquals((Object)NET, (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)256, (int)0));
    }

    @Test
    public void testSplitIp() throws Exception {
        long[] splitIp = ReverseZoneUtils.splitIp((String)NET);
        Assertions.assertEquals((long)172L, (long)splitIp[0]);
        Assertions.assertEquals((long)17L, (long)splitIp[1]);
        Assertions.assertEquals((long)4L, (long)splitIp[2]);
        Assertions.assertEquals((long)0L, (long)splitIp[3]);
    }

    @Test
    public void testThrowIllegalArgumentExceptionIfIndexIsNegative() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)256, (int)-1));
    }

    @Test
    public void testThrowUnknownHostExceptionIfIpIsInvalid() throws Exception {
        Assertions.assertThrows(UnknownHostException.class, () -> ReverseZoneUtils.getReverseZoneNetworkAddress((String)"213124.21231.14123.13", (int)256, (int)0));
    }

    @Test
    public void testThrowIllegalArgumentExceptionIfRangeIsNegative() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)-1, (int)0));
    }

    @Test
    public void testVariousRangeAndIndexValues() throws Exception {
        Assertions.assertEquals((Object)"172.17.9.0", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)256, (int)5));
        Assertions.assertEquals((Object)"172.17.4.128", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)128, (int)1));
        Assertions.assertEquals((Object)"172.18.0.0", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)256, (int)252));
        Assertions.assertEquals((Object)"172.17.12.0", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)1024, (int)2));
        Assertions.assertEquals((Object)NET, (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)0, (int)1));
        Assertions.assertEquals((Object)NET, (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)1, (int)0));
        Assertions.assertEquals((Object)"172.17.4.1", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)1, (int)1));
    }
}

