/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.secure;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.secure.AbstractSecureRegistryTest;
import org.apache.hadoop.registry.secure.KerberosConfiguration;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.util.PlatformName;
import org.apache.zookeeper.data.ACL;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSecureLogins
extends AbstractSecureRegistryTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestSecureLogins.class);

    @Test
    public void testHasRealm() throws Throwable {
        TestSecureLogins.assertNotNull((Object)TestSecureLogins.getRealm());
        LOG.info("ZK principal = {}", (Object)TestSecureLogins.getPrincipalAndRealm("zookeeper/localhost"));
    }

    @Test
    public void testJaasFileSetup() throws Throwable {
        TestSecureLogins.assertNotNull((Object)jaasFile, (String)"jaasFile");
        String confFilename = System.getProperty("java.security.auth.login.config");
        TestSecureLogins.assertEquals((Object)jaasFile.getAbsolutePath(), (Object)confFilename);
    }

    @Test
    public void testJaasFileBinding() throws Throwable {
        TestSecureLogins.assertNotNull((Object)jaasFile, (String)"jaasFile");
        RegistrySecurity.bindJVMtoJAASFile((File)jaasFile);
        String confFilename = System.getProperty("java.security.auth.login.config");
        TestSecureLogins.assertEquals((Object)jaasFile.getAbsolutePath(), (Object)confFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientLogin() throws Throwable {
        LoginContext client = this.login("alice/localhost", "alice", keytab_alice);
        try {
            TestSecureLogins.logLoginDetails("alice/localhost", client);
            String confFilename = System.getProperty("java.security.auth.login.config");
            TestSecureLogins.assertNotNull((Object)confFilename, (String)"Unset: java.security.auth.login.config");
            String config = FileUtils.readFileToString((File)new File(confFilename), (Charset)StandardCharsets.UTF_8);
            LOG.info("{}=\n{}", (Object)confFilename, (Object)config);
            RegistrySecurity.setZKSaslClientProperties((String)"alice", (String)"alice");
        }
        finally {
            client.logout();
        }
    }

    @Test
    public void testZKServerContextLogin() throws Throwable {
        LoginContext client = this.login("zookeeper/localhost", "ZOOKEEPER_SERVER", keytab_zk);
        TestSecureLogins.logLoginDetails("zookeeper/localhost", client);
        client.logout();
    }

    @Test
    public void testServerLogin() throws Throwable {
        LoginContext loginContext = this.createLoginContextZookeeperLocalhost();
        loginContext.login();
        loginContext.logout();
    }

    public LoginContext createLoginContextZookeeperLocalhost() throws LoginException {
        String principalAndRealm = TestSecureLogins.getPrincipalAndRealm("zookeeper/localhost");
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal("zookeeper/localhost"));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        return new LoginContext("", subject, null, KerberosConfiguration.createServerConfig("zookeeper/localhost", keytab_zk));
    }

    @Test
    public void testKerberosAuth() throws Throwable {
        File krb5conf = TestSecureLogins.getKdc().getKrb5conf();
        String krbConfig = FileUtils.readFileToString((File)krb5conf, (Charset)StandardCharsets.UTF_8);
        LOG.info("krb5.conf at {}:\n{}", (Object)krb5conf, (Object)krbConfig);
        Subject subject = new Subject();
        Class<?> kerb5LoginClass = Class.forName(KerberosUtil.getKrb5LoginModuleName());
        Constructor<?> kerb5LoginConstr = kerb5LoginClass.getConstructor(new Class[0]);
        Object kerb5LoginObject = kerb5LoginConstr.newInstance(new Object[0]);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("debug", "true");
        if (PlatformName.IBM_JAVA) {
            options.put("useKeytab", keytab_alice.getAbsolutePath().startsWith("file://") ? keytab_alice.getAbsolutePath() : "file://" + keytab_alice.getAbsolutePath());
            options.put("principal", "alice/localhost");
            options.put("refreshKrb5Config", "true");
            options.put("credsType", "both");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                System.setProperty("KRB5CCNAME", ticketCache);
                options.put("useDefaultCcache", "true");
                options.put("renewTGT", "true");
            }
        } else {
            options.put("keyTab", keytab_alice.getAbsolutePath());
            options.put("principal", "alice/localhost");
            options.put("doNotPrompt", "true");
            options.put("isInitiator", "true");
            options.put("refreshKrb5Config", "true");
            options.put("renewTGT", "true");
            options.put("storeKey", "true");
            options.put("useKeyTab", "true");
            options.put("useTicketCache", "true");
        }
        Method methodInitialize = kerb5LoginObject.getClass().getMethod("initialize", Subject.class, CallbackHandler.class, Map.class, Map.class);
        methodInitialize.invoke(kerb5LoginObject, subject, null, new HashMap(), options);
        Method methodLogin = kerb5LoginObject.getClass().getMethod("login", new Class[0]);
        boolean loginOk = (Boolean)methodLogin.invoke(kerb5LoginObject, new Object[0]);
        TestSecureLogins.assertTrue((boolean)loginOk, (String)"Failed to login");
        Method methodCommit = kerb5LoginObject.getClass().getMethod("commit", new Class[0]);
        boolean commitOk = (Boolean)methodCommit.invoke(kerb5LoginObject, new Object[0]);
        TestSecureLogins.assertTrue((boolean)commitOk, (String)"Failed to Commit");
    }

    @Test
    public void testDefaultRealmValid() throws Throwable {
        String defaultRealm = KerberosUtil.getDefaultRealm();
        TestSecureLogins.assertNotEmpty("No default Kerberos Realm", defaultRealm);
        LOG.info("Default Realm '{}'", (Object)defaultRealm);
    }

    @Test
    public void testKerberosRulesValid() throws Throwable {
        TestSecureLogins.assertTrue((boolean)KerberosName.hasRulesBeenSet(), (String)"!KerberosName.hasRulesBeenSet()");
        String rules = KerberosName.getRules();
        TestSecureLogins.assertEquals((Object)"RULE:[1:$1@$0](.*@EXAMPLE.COM)s/@.*//\nDEFAULT", (Object)rules);
        LOG.info(rules);
    }

    @Test
    public void testValidKerberosName() throws Throwable {
        KerberosName.setRuleMechanism((String)"hadoop");
        new HadoopKerberosName("zookeeper").getShortName();
        KerberosName.setRuleMechanism((String)"mit");
        new HadoopKerberosName("zookeeper").getShortName();
        new HadoopKerberosName("zookeeper/localhost").getShortName();
        new HadoopKerberosName("zookeeper@EXAMPLE.COM").getShortName();
        new HadoopKerberosName("zookeeper/localhost@EXAMPLE.COM").getShortName();
        KerberosName.setRuleMechanism((String)"hadoop");
    }

    @Test
    public void testUGILogin() throws Throwable {
        UserGroupInformation ugi = TestSecureLogins.loginUGI("zookeeper", keytab_zk);
        RegistrySecurity.UgiInfo ugiInfo = new RegistrySecurity.UgiInfo(ugi);
        LOG.info("logged in as: {}", (Object)ugiInfo);
        TestSecureLogins.assertTrue((boolean)UserGroupInformation.isSecurityEnabled(), (String)("security is not enabled: " + ugiInfo));
        TestSecureLogins.assertTrue((boolean)ugi.isFromKeytab(), (String)("login is keytab based: " + ugiInfo));
        ACL acl = (ACL)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ACL>(){

            @Override
            public ACL run() throws Exception {
                return AbstractSecureRegistryTest.registrySecurity.createSaslACLFromCurrentUser(0);
            }
        });
        TestSecureLogins.assertEquals((Object)"zookeeper@EXAMPLE.COM", (Object)acl.getId().getId());
        TestSecureLogins.assertEquals((Object)"sasl", (Object)acl.getId().getScheme());
        registrySecurity.addSystemACL(acl);
    }
}

