/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.integration;

import org.apache.hadoop.registry.RegistryTestHelper;
import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.integration.SelectByYarnPersistence;
import org.apache.hadoop.registry.server.services.RegistryAdminService;
import org.junit.jupiter.api.Test;

public class TestYarnPolicySelector
extends RegistryTestHelper {
    private ServiceRecord record = TestYarnPolicySelector.createRecord("1", "application", "one", null);
    private RegistryPathStatus status = new RegistryPathStatus("/", 0L, 0L, 1);

    public void assertSelected(boolean outcome, RegistryAdminService.NodeSelector selector) {
        boolean select = selector.shouldSelect("/", this.status, this.record);
        TestYarnPolicySelector.assertEquals((Object)outcome, (Object)select, (String)selector.toString());
    }

    @Test
    public void testByContainer() throws Throwable {
        this.assertSelected(false, (RegistryAdminService.NodeSelector)new SelectByYarnPersistence("1", "container"));
    }

    @Test
    public void testByApp() throws Throwable {
        this.assertSelected(true, (RegistryAdminService.NodeSelector)new SelectByYarnPersistence("1", "application"));
    }

    @Test
    public void testByAppName() throws Throwable {
        this.assertSelected(false, (RegistryAdminService.NodeSelector)new SelectByYarnPersistence("2", "application"));
    }
}

