/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.binding;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidPathnameException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRegistryPathUtils
extends Assertions {
    public static final String EURO = "\u20ac";

    @Test
    public void testFormatAscii() throws Throwable {
        String in = "hostname01101101-1";
        this.assertConverted(in, in);
    }

    @Test
    public void testFormatEuroSymbol() throws Throwable {
        this.assertConverted("xn--lzg", EURO);
    }

    @Test
    public void testFormatIdempotent() throws Throwable {
        this.assertConverted("xn--lzg", RegistryPathUtils.encodeForRegistry((String)EURO));
    }

    @Test
    public void testFormatCyrillicSpaced() throws Throwable {
        this.assertConverted("xn--pa 3-k4di", "\u0413PA\u0414 3");
    }

    protected void assertConverted(String expected, String in) {
        String out = RegistryPathUtils.encodeForRegistry((String)in);
        TestRegistryPathUtils.assertEquals((Object)expected, (Object)out, (String)("Conversion of " + in));
    }

    @Test
    public void testPaths() throws Throwable {
        TestRegistryPathUtils.assertCreatedPathEquals("/", "/", "");
        TestRegistryPathUtils.assertCreatedPathEquals("/", "", "");
        TestRegistryPathUtils.assertCreatedPathEquals("/", "", "/");
        TestRegistryPathUtils.assertCreatedPathEquals("/", "/", "/");
        TestRegistryPathUtils.assertCreatedPathEquals("/a", "/a", "");
        TestRegistryPathUtils.assertCreatedPathEquals("/a", "/", "a");
        TestRegistryPathUtils.assertCreatedPathEquals("/a/b", "/a", "b");
        TestRegistryPathUtils.assertCreatedPathEquals("/a/b", "/a/", "b");
        TestRegistryPathUtils.assertCreatedPathEquals("/a/b", "/a", "/b");
        TestRegistryPathUtils.assertCreatedPathEquals("/a/b", "/a", "/b/");
        TestRegistryPathUtils.assertCreatedPathEquals("/a", "/a", "/");
        TestRegistryPathUtils.assertCreatedPathEquals("/alice", "/", "/alice");
        TestRegistryPathUtils.assertCreatedPathEquals("/alice", "/alice", "/");
    }

    @Test
    public void testGetUserFromPath() throws Exception {
        TestRegistryPathUtils.assertEquals((Object)"bob", (Object)RegistryPathUtils.getUsername((String)"/registry/users/bob/services/yarn-service/test1/"));
        TestRegistryPathUtils.assertEquals((Object)"bob-dev", (Object)RegistryPathUtils.getUsername((String)"/registry/users/bob-dev/services/yarn-service/test1"));
        TestRegistryPathUtils.assertEquals((Object)"bob.dev", (Object)RegistryPathUtils.getUsername((String)"/registry/users/bob.dev/services/yarn-service/test1"));
    }

    @Test
    public void testComplexPaths() throws Throwable {
        TestRegistryPathUtils.assertCreatedPathEquals("/", "", "");
        TestRegistryPathUtils.assertCreatedPathEquals("/yarn/registry/users/hadoop/org-apache-hadoop", "/yarn/registry", "users/hadoop/org-apache-hadoop/");
    }

    private static void assertCreatedPathEquals(String expected, String base, String path) throws IOException {
        String fullPath = RegistryPathUtils.createFullPath((String)base, (String)path);
        TestRegistryPathUtils.assertEquals((Object)expected, (Object)fullPath, (String)("\"" + base + "\" + \"" + path + "\" =\"" + fullPath + "\""));
    }

    @Test
    public void testSplittingEmpty() throws Throwable {
        TestRegistryPathUtils.assertEquals((int)0, (int)RegistryPathUtils.split((String)"").size());
        TestRegistryPathUtils.assertEquals((int)0, (int)RegistryPathUtils.split((String)"/").size());
        TestRegistryPathUtils.assertEquals((int)0, (int)RegistryPathUtils.split((String)"///").size());
    }

    @Test
    public void testSplitting() throws Throwable {
        TestRegistryPathUtils.assertEquals((int)1, (int)RegistryPathUtils.split((String)"/a").size());
        TestRegistryPathUtils.assertEquals((int)0, (int)RegistryPathUtils.split((String)"/").size());
        TestRegistryPathUtils.assertEquals((int)3, (int)RegistryPathUtils.split((String)"/a/b/c").size());
        TestRegistryPathUtils.assertEquals((int)3, (int)RegistryPathUtils.split((String)"/a/b/c/").size());
        TestRegistryPathUtils.assertEquals((int)3, (int)RegistryPathUtils.split((String)"a/b/c").size());
        TestRegistryPathUtils.assertEquals((int)3, (int)RegistryPathUtils.split((String)"/a/b//c").size());
        TestRegistryPathUtils.assertEquals((int)3, (int)RegistryPathUtils.split((String)"//a/b/c/").size());
        List split = RegistryPathUtils.split((String)"//a/b/c/");
        TestRegistryPathUtils.assertEquals((Object)"a", split.get(0));
        TestRegistryPathUtils.assertEquals((Object)"b", split.get(1));
        TestRegistryPathUtils.assertEquals((Object)"c", split.get(2));
    }

    @Test
    public void testParentOf() throws Throwable {
        TestRegistryPathUtils.assertEquals((Object)"/", (Object)RegistryPathUtils.parentOf((String)"/a"));
        TestRegistryPathUtils.assertEquals((Object)"/", (Object)RegistryPathUtils.parentOf((String)"/a/"));
        TestRegistryPathUtils.assertEquals((Object)"/a", (Object)RegistryPathUtils.parentOf((String)"/a/b"));
        TestRegistryPathUtils.assertEquals((Object)"/a/b", (Object)RegistryPathUtils.parentOf((String)"/a/b/c"));
    }

    @Test
    public void testLastPathEntry() throws Throwable {
        TestRegistryPathUtils.assertEquals((Object)"", (Object)RegistryPathUtils.lastPathEntry((String)"/"));
        TestRegistryPathUtils.assertEquals((Object)"", (Object)RegistryPathUtils.lastPathEntry((String)"//"));
        TestRegistryPathUtils.assertEquals((Object)"c", (Object)RegistryPathUtils.lastPathEntry((String)"/a/b/c"));
        TestRegistryPathUtils.assertEquals((Object)"c", (Object)RegistryPathUtils.lastPathEntry((String)"/a/b/c/"));
    }

    @Test
    public void testParentOfRoot() throws Throwable {
        TestRegistryPathUtils.assertThrows(PathNotFoundException.class, () -> RegistryPathUtils.parentOf((String)"/"));
    }

    @Test
    public void testValidPaths() throws Throwable {
        this.assertValidPath("/");
        this.assertValidPath("/a/b/c");
        this.assertValidPath("/users/drwho/org-apache-hadoop/registry/appid-55-55");
        this.assertValidPath("/a50");
    }

    @Test
    public void testInvalidPaths() throws Throwable {
        this.assertInvalidPath("/a_b");
        this.assertInvalidPath("/UpperAndLowerCase");
        this.assertInvalidPath("/space in string");
    }

    private void assertValidPath(String path) throws InvalidPathnameException {
        RegistryPathUtils.validateZKPath((String)path);
    }

    private void assertInvalidPath(String path) throws InvalidPathnameException {
        try {
            RegistryPathUtils.validateElementsAsDNS((String)path);
            TestRegistryPathUtils.fail((String)("path considered valid: " + path));
        }
        catch (InvalidPathnameException invalidPathnameException) {
            // empty catch block
        }
    }
}

