/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.secure;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.registry.RegistryTestHelper;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.secure.KerberosConfiguration;
import org.apache.hadoop.registry.server.services.AddingCompositeService;
import org.apache.hadoop.registry.server.services.MicroZookeeperService;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSecureRegistryTest
extends RegistryTestHelper {
    public static final String REALM = "EXAMPLE.COM";
    public static final String ZOOKEEPER = "zookeeper";
    public static final String ZOOKEEPER_LOCALHOST = "zookeeper/localhost";
    public static final String ZOOKEEPER_1270001 = "zookeeper/127.0.0.1";
    public static final String ZOOKEEPER_REALM = "zookeeper@EXAMPLE.COM";
    public static final String ZOOKEEPER_CLIENT_CONTEXT = "zookeeper";
    public static final String ZOOKEEPER_SERVER_CONTEXT = "ZOOKEEPER_SERVER";
    public static final String ZOOKEEPER_LOCALHOST_REALM = "zookeeper/localhost@EXAMPLE.COM";
    public static final String ALICE = "alice";
    public static final String ALICE_CLIENT_CONTEXT = "alice";
    public static final String ALICE_LOCALHOST = "alice/localhost";
    public static final String BOB = "bob";
    public static final String BOB_CLIENT_CONTEXT = "bob";
    public static final String BOB_LOCALHOST = "bob/localhost";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSecureRegistryTest.class);
    public static final Configuration CONF = new Configuration();
    private static final AddingCompositeService classTeardown;
    public static final String SUN_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    private final AddingCompositeService teardown = new AddingCompositeService("teardown");
    protected static MiniKdc kdc;
    protected static File keytab_zk;
    protected static File keytab_bob;
    protected static File keytab_alice;
    protected static File kdcWorkDir;
    protected static Properties kdcConf;
    protected static RegistrySecurity registrySecurity;
    @Rule
    public final Timeout testTimeout = new Timeout(900000);
    @Rule
    public TestName methodName = new TestName();
    protected MicroZookeeperService secureZK;
    protected static File jaasFile;
    private LoginContext zookeeperLogin;
    private static String zkServerPrincipal;
    protected static final String kerberosRule = "RULE:[1:$1@$0](.*@EXAMPLE.COM)s/@.*//\nDEFAULT";

    @BeforeClass
    public static void beforeSecureRegistryTestClass() throws Exception {
        registrySecurity = new RegistrySecurity("registrySecurity");
        registrySecurity.init(CONF);
        AbstractSecureRegistryTest.setupKDCAndPrincipals();
        RegistrySecurity.clearJaasSystemProperties();
        RegistrySecurity.bindJVMtoJAASFile((File)jaasFile);
        AbstractSecureRegistryTest.initHadoopSecurity();
    }

    @AfterClass
    public static void afterSecureRegistryTestClass() throws Exception {
        AbstractSecureRegistryTest.describe(LOG, "teardown of class", new Object[0]);
        classTeardown.close();
        AbstractSecureRegistryTest.teardownKDC();
    }

    @Before
    public void nameThread() {
        Thread.currentThread().setName("JUnit");
    }

    @Before
    public void beforeSecureRegistryTest() {
    }

    @After
    public void afterSecureRegistryTest() throws IOException {
        AbstractSecureRegistryTest.describe(LOG, "teardown of instance", new Object[0]);
        this.teardown.close();
        this.stopSecureZK();
    }

    protected static void addToClassTeardown(Service svc) {
        classTeardown.addService(svc);
    }

    protected void addToTeardown(Service svc) {
        this.teardown.addService(svc);
    }

    public static void teardownKDC() throws Exception {
        if (kdc != null) {
            kdc.stop();
            kdc = null;
        }
    }

    public static void setupKDCAndPrincipals() throws Exception {
        File target = new File(System.getProperty("test.dir", "target"));
        kdcWorkDir = new File(target, "kdc");
        kdcWorkDir.mkdirs();
        if (!kdcWorkDir.mkdirs()) {
            AbstractSecureRegistryTest.assertTrue((boolean)kdcWorkDir.isDirectory());
        }
        kdcConf = MiniKdc.createConf();
        kdcConf.setProperty("debug", "true");
        kdc = new MiniKdc(kdcConf, kdcWorkDir);
        kdc.start();
        keytab_zk = AbstractSecureRegistryTest.createKeytab("zookeeper", "zookeeper.keytab");
        keytab_alice = AbstractSecureRegistryTest.createKeytab("alice", "alice.keytab");
        keytab_bob = AbstractSecureRegistryTest.createKeytab("bob", "bob.keytab");
        zkServerPrincipal = Shell.WINDOWS ? ZOOKEEPER_1270001 : ZOOKEEPER_LOCALHOST;
        StringBuilder jaas = new StringBuilder(1024);
        jaas.append(registrySecurity.createJAASEntry("zookeeper", "zookeeper", keytab_zk));
        jaas.append(registrySecurity.createJAASEntry(ZOOKEEPER_SERVER_CONTEXT, zkServerPrincipal, keytab_zk));
        jaas.append(registrySecurity.createJAASEntry("alice", ALICE_LOCALHOST, keytab_alice));
        jaas.append(registrySecurity.createJAASEntry("bob", BOB_LOCALHOST, keytab_bob));
        jaasFile = new File(kdcWorkDir, "jaas.txt");
        FileUtils.write((File)jaasFile, (CharSequence)jaas.toString(), (Charset)StandardCharsets.UTF_8);
        LOG.info("\n" + jaas);
        RegistrySecurity.bindJVMtoJAASFile((File)jaasFile);
    }

    public static void initHadoopSecurity() {
        UserGroupInformation.setConfiguration((Configuration)CONF);
        KerberosName.setRules((String)kerberosRule);
    }

    public synchronized void stopSecureZK() {
        ServiceOperations.stop((Service)this.secureZK);
        this.secureZK = null;
        AbstractSecureRegistryTest.logout(this.zookeeperLogin);
        this.zookeeperLogin = null;
    }

    public static MiniKdc getKdc() {
        return kdc;
    }

    public static File getKdcWorkDir() {
        return kdcWorkDir;
    }

    public static Properties getKdcConf() {
        return kdcConf;
    }

    protected static MicroZookeeperService createSecureZKInstance(String name) throws Exception {
        String context = ZOOKEEPER_SERVER_CONTEXT;
        Configuration conf = new Configuration();
        File testdir = new File(System.getProperty("test.dir", "target"));
        File workDir = new File(testdir, name);
        if (!workDir.mkdirs()) {
            AbstractSecureRegistryTest.assertTrue((boolean)workDir.isDirectory());
        }
        System.setProperty("zookeeper.maintain_connection_despite_sasl_failure", "false");
        RegistrySecurity.validateContext((String)context);
        conf.set("hadoop.registry.zk.service.service.jaas.context", context);
        MicroZookeeperService secureZK = new MicroZookeeperService(name);
        secureZK.init(conf);
        LOG.info(secureZK.getDiagnostics());
        return secureZK;
    }

    public static File createKeytab(String principal, String filename) throws Exception {
        AbstractSecureRegistryTest.assertNotEmpty("empty principal", principal);
        AbstractSecureRegistryTest.assertNotEmpty("empty host", filename);
        AbstractSecureRegistryTest.assertNotNull((String)"Null KDC", (Object)kdc);
        File keytab = new File(kdcWorkDir, filename);
        kdc.createPrincipal(keytab, new String[]{principal, principal + "/localhost", principal + "/127.0.0.1"});
        return keytab;
    }

    public static String getPrincipalAndRealm(String principal) {
        return principal + "@" + AbstractSecureRegistryTest.getRealm();
    }

    protected static String getRealm() {
        return kdc.getRealm();
    }

    protected LoginContext login(String principal, String context, File keytab) throws LoginException, FileNotFoundException {
        LOG.info("Logging in as {} in context {} with keytab {}", new Object[]{principal, context, keytab});
        if (!keytab.exists()) {
            throw new FileNotFoundException(keytab.getAbsolutePath());
        }
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(principal));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        LoginContext login = new LoginContext(context, subject, null, KerberosConfiguration.createClientConfig(principal, keytab));
        login.login();
        return login;
    }

    protected synchronized void startSecureZK() throws Exception {
        AbstractSecureRegistryTest.assertNull((String)"Zookeeper is already running", (Object)this.secureZK);
        this.zookeeperLogin = this.login(zkServerPrincipal, ZOOKEEPER_SERVER_CONTEXT, keytab_zk);
        this.secureZK = AbstractSecureRegistryTest.createSecureZKInstance("test-" + this.methodName.getMethodName());
        this.secureZK.start();
    }

    static {
        CONF.set("hadoop.security.authentication", "kerberos");
        CONF.setBoolean("hadoop.security.authorization", true);
        classTeardown = new AddingCompositeService("classTeardown");
        classTeardown.init(CONF);
        classTeardown.start();
    }
}

