/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.rpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderTokenIssuer;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneKeyLocation;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.client.io.KeyInputStream;
import org.apache.hadoop.ozone.client.io.KeyOutputStream;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rpc.OzoneKMSUtil;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.ha.OMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.logging.log4j.util.Strings;
import org.apache.ratis.protocol.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient
implements ClientProtocol,
KeyProviderTokenIssuer {
    private static final Logger LOG = LoggerFactory.getLogger(RpcClient.class);
    private final OzoneConfiguration conf;
    private final StorageContainerLocationProtocol storageContainerLocationClient;
    private final OzoneManagerProtocol ozoneManagerClient;
    private final XceiverClientManager xceiverClientManager;
    private final int chunkSize;
    private final ContainerProtos.ChecksumType checksumType;
    private final int bytesPerChecksum;
    private boolean verifyChecksum;
    private final UserGroupInformation ugi;
    private final OzoneAcl.OzoneACLRights userRights;
    private final OzoneAcl.OzoneACLRights groupRights;
    private final long streamBufferFlushSize;
    private final long streamBufferMaxSize;
    private final long blockSize;
    private final long watchTimeout;
    private final int maxRetryCount;
    private final ClientId clientId = ClientId.randomId();
    private Text dtService;

    public RpcClient(Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)conf);
        this.conf = new OzoneConfiguration(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.userRights = (OzoneAcl.OzoneACLRights)conf.getEnum("ozone.om.user.rights", (Enum)OMConfigKeys.OZONE_OM_USER_RIGHTS_DEFAULT);
        this.groupRights = (OzoneAcl.OzoneACLRights)conf.getEnum("ozone.om.group.rights", (Enum)OMConfigKeys.OZONE_OM_GROUP_RIGHTS_DEFAULT);
        this.ozoneManagerClient = new OzoneManagerProtocolClientSideTranslatorPB(this.conf, this.clientId.toString(), this.ugi);
        long scmVersion = RPC.getProtocolVersion(StorageContainerLocationProtocolPB.class);
        InetSocketAddress scmAddress = this.getScmAddressForClient();
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        StorageContainerLocationProtocolClientSideTranslatorPB client = new StorageContainerLocationProtocolClientSideTranslatorPB((StorageContainerLocationProtocolPB)RPC.getProxy(StorageContainerLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmAddress, (UserGroupInformation)this.ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        this.storageContainerLocationClient = (StorageContainerLocationProtocol)TracingUtil.createProxy((Object)client, StorageContainerLocationProtocol.class);
        this.xceiverClientManager = new XceiverClientManager(conf);
        int configuredChunkSize = (int)conf.getStorageSize("ozone.scm.chunk.size", "16MB", StorageUnit.BYTES);
        if (configuredChunkSize > 0x2000000) {
            LOG.warn("The chunk size ({}) is not allowed to be more than the maximum size ({}), resetting to the maximum size.", (Object)configuredChunkSize, (Object)0x2000000);
            this.chunkSize = 0x2000000;
        } else {
            this.chunkSize = configuredChunkSize;
        }
        this.streamBufferFlushSize = (long)conf.getStorageSize("ozone.client.stream.buffer.flush.size", "64MB", StorageUnit.BYTES);
        this.streamBufferMaxSize = (long)conf.getStorageSize("ozone.client.stream.buffer.max.size", "128MB", StorageUnit.BYTES);
        this.blockSize = (long)conf.getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
        this.watchTimeout = conf.getTimeDuration("ozone.client.watch.request.timeout", "30s", TimeUnit.MILLISECONDS);
        int configuredChecksumSize = (int)conf.getStorageSize("ozone.client.bytes.per.checksum", "1MB", StorageUnit.BYTES);
        if (configuredChecksumSize < 262144) {
            LOG.warn("The checksum size ({}) is not allowed to be less than the minimum size ({}), resetting to the minimum size.", (Object)configuredChecksumSize, (Object)262144);
            this.bytesPerChecksum = 262144;
        } else {
            this.bytesPerChecksum = configuredChecksumSize;
        }
        String checksumTypeStr = conf.get("ozone.client.checksum.type", "SHA256");
        this.checksumType = ContainerProtos.ChecksumType.valueOf((String)checksumTypeStr);
        this.verifyChecksum = conf.getBoolean("ozone.client.verify.checksum", true);
        this.maxRetryCount = conf.getInt("ozone.client.max.retries", 5);
        this.dtService = this.getOMProxyProvider().getProxy().getDelegationTokenService();
    }

    private InetSocketAddress getScmAddressForClient() throws IOException {
        List services = this.ozoneManagerClient.getServiceList();
        ServiceInfo scmInfo = (ServiceInfo)services.stream().filter(a -> a.getNodeType().equals((Object)HddsProtos.NodeType.SCM)).collect(Collectors.toList()).get(0);
        return NetUtils.createSocketAddr((String)scmInfo.getServiceAddress(OzoneManagerProtocolProtos.ServicePort.Type.RPC));
    }

    @Override
    public void createVolume(String volumeName) throws IOException {
        this.createVolume(volumeName, VolumeArgs.newBuilder().build());
    }

    @Override
    public void createVolume(String volumeName, VolumeArgs volArgs) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        Preconditions.checkNotNull((Object)volArgs);
        String admin = volArgs.getAdmin() == null ? this.ugi.getUserName() : volArgs.getAdmin();
        String owner = volArgs.getOwner() == null ? this.ugi.getUserName() : volArgs.getOwner();
        long quota = volArgs.getQuota() == null ? 0x1000000000000000L : OzoneQuota.parseQuota((String)volArgs.getQuota()).sizeInBytes();
        ArrayList<OzoneAcl> listOfAcls = new ArrayList<OzoneAcl>();
        listOfAcls.add(new OzoneAcl(OzoneAcl.OzoneACLType.USER, owner, this.userRights));
        List<String> userGroups = Arrays.asList(UserGroupInformation.createRemoteUser((String)owner).getGroupNames());
        userGroups.stream().forEach(group -> listOfAcls.add(new OzoneAcl(OzoneAcl.OzoneACLType.GROUP, group, this.groupRights)));
        if (volArgs.getAcls() != null) {
            listOfAcls.addAll(volArgs.getAcls());
        }
        OmVolumeArgs.Builder builder = OmVolumeArgs.newBuilder();
        builder.setVolume(volumeName);
        builder.setAdminName(admin);
        builder.setOwnerName(owner);
        builder.setQuotaInBytes(quota);
        builder.addAllMetadata(volArgs.getMetadata());
        for (OzoneAcl ozoneAcl : listOfAcls.stream().distinct().collect(Collectors.toList())) {
            builder.addOzoneAcls(OMPBHelper.convertOzoneAcl((OzoneAcl)ozoneAcl));
        }
        if (volArgs.getQuota() == null) {
            LOG.info("Creating Volume: {}, with {} as owner.", (Object)volumeName, (Object)owner);
        } else {
            LOG.info("Creating Volume: {}, with {} as owner and quota set to {} bytes.", new Object[]{volumeName, owner, quota});
        }
        this.ozoneManagerClient.createVolume(builder.build());
    }

    @Override
    public void setVolumeOwner(String volumeName, String owner) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        Preconditions.checkNotNull((Object)owner);
        this.ozoneManagerClient.setOwner(volumeName, owner);
    }

    @Override
    public void setVolumeQuota(String volumeName, OzoneQuota quota) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        Preconditions.checkNotNull((Object)quota);
        long quotaInBytes = quota.sizeInBytes();
        this.ozoneManagerClient.setQuota(volumeName, quotaInBytes);
    }

    @Override
    public OzoneVolume getVolumeDetails(String volumeName) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        OmVolumeArgs volume = this.ozoneManagerClient.getVolumeInfo(volumeName);
        return new OzoneVolume((Configuration)this.conf, this, volume.getVolume(), volume.getAdminName(), volume.getOwnerName(), volume.getQuotaInBytes(), volume.getCreationTime(), volume.getAclMap().ozoneAclGetProtobuf().stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()), volume.getMetadata());
    }

    @Override
    public boolean checkVolumeAccess(String volumeName, OzoneAcl acl) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void deleteVolume(String volumeName) throws IOException {
        HddsClientUtils.verifyResourceName((String)volumeName);
        this.ozoneManagerClient.deleteVolume(volumeName);
    }

    @Override
    public List<OzoneVolume> listVolumes(String volumePrefix, String prevVolume, int maxListResult) throws IOException {
        List volumes = this.ozoneManagerClient.listAllVolumes(volumePrefix, prevVolume, maxListResult);
        return volumes.stream().map(volume -> new OzoneVolume((Configuration)this.conf, this, volume.getVolume(), volume.getAdminName(), volume.getOwnerName(), volume.getQuotaInBytes(), volume.getCreationTime(), volume.getAclMap().ozoneAclGetProtobuf().stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    @Override
    public List<OzoneVolume> listVolumes(String user, String volumePrefix, String prevVolume, int maxListResult) throws IOException {
        List volumes = this.ozoneManagerClient.listVolumeByUser(user, volumePrefix, prevVolume, maxListResult);
        return volumes.stream().map(volume -> new OzoneVolume((Configuration)this.conf, this, volume.getVolume(), volume.getAdminName(), volume.getOwnerName(), volume.getQuotaInBytes(), volume.getCreationTime(), volume.getAclMap().ozoneAclGetProtobuf().stream().map(OMPBHelper::convertOzoneAcl).collect(Collectors.toList()), volume.getMetadata())).collect(Collectors.toList());
    }

    @Override
    public void createBucket(String volumeName, String bucketName) throws IOException {
        this.createBucket(volumeName, bucketName, BucketArgs.newBuilder().build());
    }

    @Override
    public void createBucket(String volumeName, String bucketName, BucketArgs bucketArgs) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)bucketArgs);
        Boolean isVersionEnabled = bucketArgs.getVersioning() == null ? Boolean.FALSE : bucketArgs.getVersioning();
        StorageType storageType = bucketArgs.getStorageType() == null ? StorageType.DEFAULT : bucketArgs.getStorageType();
        BucketEncryptionKeyInfo bek = null;
        if (bucketArgs.getEncryptionKey() != null) {
            bek = new BucketEncryptionKeyInfo.Builder().setKeyName(bucketArgs.getEncryptionKey()).build();
        }
        ArrayList<OzoneAcl> listOfAcls = new ArrayList<OzoneAcl>();
        listOfAcls.add(new OzoneAcl(OzoneAcl.OzoneACLType.USER, this.ugi.getUserName(), this.userRights));
        List<String> userGroups = Arrays.asList(UserGroupInformation.createRemoteUser((String)this.ugi.getUserName()).getGroupNames());
        userGroups.stream().forEach(group -> listOfAcls.add(new OzoneAcl(OzoneAcl.OzoneACLType.GROUP, group, this.groupRights)));
        if (bucketArgs.getAcls() != null) {
            listOfAcls.addAll(bucketArgs.getAcls());
        }
        OmBucketInfo.Builder builder = OmBucketInfo.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setIsVersionEnabled(isVersionEnabled).addAllMetadata(bucketArgs.getMetadata()).setStorageType(storageType).setAcls(listOfAcls.stream().distinct().collect(Collectors.toList()));
        if (bek != null) {
            builder.setBucketEncryptionKey(bek);
        }
        LOG.info("Creating Bucket: {}/{}, with Versioning {} and Storage Type set to {} and Encryption set to {} ", new Object[]{volumeName, bucketName, isVersionEnabled, storageType, bek != null});
        this.ozoneManagerClient.createBucket(builder.build());
    }

    @Override
    public void addBucketAcls(String volumeName, String bucketName, List<OzoneAcl> addAcls) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull(addAcls);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setAddAcls(addAcls);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void removeBucketAcls(String volumeName, String bucketName, List<OzoneAcl> removeAcls) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull(removeAcls);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setRemoveAcls(removeAcls);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        Token token = this.ozoneManagerClient.getDelegationToken(renewer);
        if (token != null) {
            token.setService(this.dtService);
            LOG.debug("Created token {} for dtService {}", (Object)token, (Object)this.dtService);
        } else {
            LOG.debug("Cannot get ozone delegation token for renewer {} to access service {}", (Object)renewer, (Object)this.dtService);
        }
        return token;
    }

    @Override
    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        return this.ozoneManagerClient.renewDelegationToken(token);
    }

    @Override
    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        this.ozoneManagerClient.cancelDelegationToken(token);
    }

    @Override
    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)kerberosID), (Object)"kerberosID cannot be null or empty.");
        return this.ozoneManagerClient.getS3Secret(kerberosID);
    }

    @Override
    @VisibleForTesting
    public OMFailoverProxyProvider getOMProxyProvider() {
        return this.ozoneManagerClient.getOMFailoverProxyProvider();
    }

    @Override
    public void setBucketVersioning(String volumeName, String bucketName, Boolean versioning) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)versioning);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setIsVersionEnabled(versioning);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void setBucketStorageType(String volumeName, String bucketName, StorageType storageType) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)storageType);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setStorageType(storageType);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void deleteBucket(String volumeName, String bucketName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        this.ozoneManagerClient.deleteBucket(volumeName, bucketName);
    }

    @Override
    public void checkBucketAccess(String volumeName, String bucketName) throws IOException {
    }

    @Override
    public OzoneBucket getBucketDetails(String volumeName, String bucketName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        OmBucketInfo bucketInfo = this.ozoneManagerClient.getBucketInfo(volumeName, bucketName);
        return new OzoneBucket((Configuration)this.conf, this, bucketInfo.getVolumeName(), bucketInfo.getBucketName(), bucketInfo.getAcls(), bucketInfo.getStorageType(), bucketInfo.getIsVersionEnabled(), bucketInfo.getCreationTime(), bucketInfo.getMetadata(), bucketInfo.getEncryptionKeyInfo() != null ? bucketInfo.getEncryptionKeyInfo().getKeyName() : null);
    }

    @Override
    public List<OzoneBucket> listBuckets(String volumeName, String bucketPrefix, String prevBucket, int maxListResult) throws IOException {
        List buckets = this.ozoneManagerClient.listBuckets(volumeName, prevBucket, bucketPrefix, maxListResult);
        return buckets.stream().map(bucket -> new OzoneBucket((Configuration)this.conf, this, bucket.getVolumeName(), bucket.getBucketName(), bucket.getAcls(), bucket.getStorageType(), bucket.getIsVersionEnabled(), bucket.getCreationTime(), bucket.getMetadata(), bucket.getEncryptionKeyInfo() != null ? bucket.getEncryptionKeyInfo().getKeyName() : null)).collect(Collectors.toList());
    }

    @Override
    public OzoneOutputStream createKey(String volumeName, String bucketName, String keyName, long size, ReplicationType type, ReplicationFactor factor, Map<String, String> metadata) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        HddsClientUtils.checkNotNull((Object[])new Serializable[]{keyName, type, factor});
        String requestId = UUID.randomUUID().toString();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(size).setType(HddsProtos.ReplicationType.valueOf((String)type.toString())).setFactor(HddsProtos.ReplicationFactor.valueOf((int)factor.getValue())).addAllMetadata(metadata).build();
        OpenKeySession openKey = this.ozoneManagerClient.openKey(keyArgs);
        KeyOutputStream keyOutputStream = new KeyOutputStream.Builder().setHandler(openKey).setXceiverClientManager(this.xceiverClientManager).setOmClient(this.ozoneManagerClient).setChunkSize(this.chunkSize).setRequestID(requestId).setType(HddsProtos.ReplicationType.valueOf((String)type.toString())).setFactor(HddsProtos.ReplicationFactor.valueOf((int)factor.getValue())).setStreamBufferFlushSize(this.streamBufferFlushSize).setStreamBufferMaxSize(this.streamBufferMaxSize).setWatchTimeout(this.watchTimeout).setBlockSize(this.blockSize).setChecksumType(this.checksumType).setBytesPerChecksum(this.bytesPerChecksum).setMaxRetryCount(this.maxRetryCount).build();
        keyOutputStream.addPreallocateBlocks(openKey.getKeyInfo().getLatestVersionLocations(), openKey.getOpenVersion());
        FileEncryptionInfo feInfo = keyOutputStream.getFileEncryptionInfo();
        if (feInfo != null) {
            KeyProvider.KeyVersion decrypted = this.getDEK(feInfo);
            CryptoOutputStream cryptoOut = new CryptoOutputStream((OutputStream)keyOutputStream, OzoneKMSUtil.getCryptoCodec((Configuration)this.conf, feInfo), decrypted.getMaterial(), feInfo.getIV());
            return new OzoneOutputStream((OutputStream)cryptoOut);
        }
        return new OzoneOutputStream(keyOutputStream);
    }

    private KeyProvider.KeyVersion getDEK(FileEncryptionInfo feInfo) throws IOException {
        OzoneKMSUtil.checkCryptoProtocolVersion(feInfo);
        KeyProvider.KeyVersion decrypted = OzoneKMSUtil.decryptEncryptedDataEncryptionKey(feInfo, this.getKeyProvider());
        return decrypted;
    }

    @Override
    public OzoneInputStream getKey(String volumeName, String bucketName, String keyName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)keyName);
        String requestId = UUID.randomUUID().toString();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setRefreshPipeline(true).build();
        OmKeyInfo keyInfo = this.ozoneManagerClient.lookupKey(keyArgs);
        LengthInputStream lengthInputStream = KeyInputStream.getFromOmKeyInfo(keyInfo, this.xceiverClientManager, this.storageContainerLocationClient, requestId, this.verifyChecksum);
        FileEncryptionInfo feInfo = keyInfo.getFileEncryptionInfo();
        if (feInfo != null) {
            KeyProvider.KeyVersion decrypted = this.getDEK(feInfo);
            CryptoInputStream cryptoIn = new CryptoInputStream(lengthInputStream.getWrappedStream(), OzoneKMSUtil.getCryptoCodec((Configuration)this.conf, feInfo), decrypted.getMaterial(), feInfo.getIV());
            return new OzoneInputStream((InputStream)cryptoIn);
        }
        return new OzoneInputStream(lengthInputStream.getWrappedStream());
    }

    @Override
    public void deleteKey(String volumeName, String bucketName, String keyName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).build();
        this.ozoneManagerClient.deleteKey(keyArgs);
    }

    @Override
    public void renameKey(String volumeName, String bucketName, String fromKeyName, String toKeyName) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        HddsClientUtils.checkNotNull((Object[])new String[]{fromKeyName, toKeyName});
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(fromKeyName).build();
        this.ozoneManagerClient.renameKey(keyArgs, toKeyName);
    }

    @Override
    public List<OzoneKey> listKeys(String volumeName, String bucketName, String keyPrefix, String prevKey, int maxListResult) throws IOException {
        List keys = this.ozoneManagerClient.listKeys(volumeName, bucketName, prevKey, keyPrefix, maxListResult);
        return keys.stream().map(key -> new OzoneKey(key.getVolumeName(), key.getBucketName(), key.getKeyName(), key.getDataSize(), key.getCreationTime(), key.getModificationTime(), ReplicationType.valueOf((String)key.getType().toString()))).collect(Collectors.toList());
    }

    @Override
    public OzoneKeyDetails getKeyDetails(String volumeName, String bucketName, String keyName) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setRefreshPipeline(true).build();
        OmKeyInfo keyInfo = this.ozoneManagerClient.lookupKey(keyArgs);
        ArrayList<OzoneKeyLocation> ozoneKeyLocations = new ArrayList<OzoneKeyLocation>();
        keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly().forEach(a -> ozoneKeyLocations.add(new OzoneKeyLocation(a.getContainerID(), a.getLocalID(), a.getLength(), a.getOffset())));
        return new OzoneKeyDetails(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName(), keyInfo.getDataSize(), keyInfo.getCreationTime(), keyInfo.getModificationTime(), ozoneKeyLocations, ReplicationType.valueOf((String)keyInfo.getType().toString()), keyInfo.getMetadata(), keyInfo.getFileEncryptionInfo());
    }

    @Override
    public void createS3Bucket(String userName, String s3BucketName) throws IOException {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)userName), (Object)"user name cannot be null or empty.");
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)s3BucketName), (Object)"bucket name cannot be null or empty.");
        this.ozoneManagerClient.createS3Bucket(userName, s3BucketName);
    }

    @Override
    public void deleteS3Bucket(String s3BucketName) throws IOException {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)s3BucketName), (Object)"bucket name cannot be null or empty.");
        this.ozoneManagerClient.deleteS3Bucket(s3BucketName);
    }

    @Override
    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)s3BucketName), (Object)"bucket name cannot be null or empty.");
        return this.ozoneManagerClient.getOzoneBucketMapping(s3BucketName);
    }

    @Override
    public String getOzoneVolumeName(String s3BucketName) throws IOException {
        String mapping = this.getOzoneBucketMapping(s3BucketName);
        return mapping.split("/")[0];
    }

    @Override
    public String getOzoneBucketName(String s3BucketName) throws IOException {
        String mapping = this.getOzoneBucketMapping(s3BucketName);
        return mapping.split("/")[1];
    }

    @Override
    public List<OzoneBucket> listS3Buckets(String userName, String bucketPrefix, String prevBucket, int maxListResult) throws IOException {
        List buckets = this.ozoneManagerClient.listS3Buckets(userName, prevBucket, bucketPrefix, maxListResult);
        return buckets.stream().map(bucket -> new OzoneBucket((Configuration)this.conf, this, bucket.getVolumeName(), bucket.getBucketName(), bucket.getAcls(), bucket.getStorageType(), bucket.getIsVersionEnabled(), bucket.getCreationTime(), bucket.getMetadata(), bucket.getEncryptionKeyInfo() != null ? bucket.getEncryptionKeyInfo().getKeyName() : null)).collect(Collectors.toList());
    }

    @Override
    public void close() throws IOException {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.storageContainerLocationClient});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.ozoneManagerClient});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.xceiverClientManager});
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(String volumeName, String bucketName, String keyName, ReplicationType type, ReplicationFactor factor) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        HddsClientUtils.checkNotNull((Object[])new Serializable[]{keyName, type, factor});
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setType(HddsProtos.ReplicationType.valueOf((String)type.toString())).setFactor(HddsProtos.ReplicationFactor.valueOf((int)factor.getValue())).build();
        OmMultipartInfo multipartInfo = this.ozoneManagerClient.initiateMultipartUpload(keyArgs);
        return multipartInfo;
    }

    @Override
    public OzoneOutputStream createMultipartKey(String volumeName, String bucketName, String keyName, long size, int partNumber, String uploadID) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        HddsClientUtils.checkNotNull((Object[])new String[]{keyName, uploadID});
        Preconditions.checkArgument((partNumber > 0 && partNumber <= 10000 ? 1 : 0) != 0, (Object)"Part number should be greater than zero and less than or equal to 10000");
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size should be greater than or equal to zero");
        String requestId = UUID.randomUUID().toString();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(size).setIsMultipartKey(true).setMultipartUploadID(uploadID).setMultipartUploadPartNumber(partNumber).build();
        OpenKeySession openKey = this.ozoneManagerClient.openKey(keyArgs);
        KeyOutputStream keyOutputStream = new KeyOutputStream.Builder().setHandler(openKey).setXceiverClientManager(this.xceiverClientManager).setOmClient(this.ozoneManagerClient).setChunkSize(this.chunkSize).setRequestID(requestId).setType(openKey.getKeyInfo().getType()).setFactor(openKey.getKeyInfo().getFactor()).setStreamBufferFlushSize(this.streamBufferFlushSize).setStreamBufferMaxSize(this.streamBufferMaxSize).setWatchTimeout(this.watchTimeout).setBlockSize(this.blockSize).setBytesPerChecksum(this.bytesPerChecksum).setChecksumType(this.checksumType).setMultipartNumber(partNumber).setMultipartUploadID(uploadID).setIsMultipartKey(true).setMaxRetryCount(this.maxRetryCount).build();
        keyOutputStream.addPreallocateBlocks(openKey.getKeyInfo().getLatestVersionLocations(), openKey.getOpenVersion());
        return new OzoneOutputStream(keyOutputStream);
    }

    @Override
    public OmMultipartUploadCompleteInfo completeMultipartUpload(String volumeName, String bucketName, String keyName, String uploadID, Map<Integer, String> partsMap) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        HddsClientUtils.checkNotNull((Object[])new String[]{keyName, uploadID});
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setMultipartUploadID(uploadID).build();
        OmMultipartUploadList omMultipartUploadList = new OmMultipartUploadList(partsMap);
        OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo = this.ozoneManagerClient.completeMultipartUpload(keyArgs, omMultipartUploadList);
        return omMultipartUploadCompleteInfo;
    }

    @Override
    public void abortMultipartUpload(String volumeName, String bucketName, String keyName, String uploadID) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        HddsClientUtils.checkNotNull((Object[])new String[]{keyName, uploadID});
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setMultipartUploadID(uploadID).build();
        this.ozoneManagerClient.abortMultipartUpload(omKeyArgs);
    }

    @Override
    public OzoneMultipartUploadPartListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
        HddsClientUtils.checkNotNull((Object[])new String[]{uploadID});
        Preconditions.checkArgument((maxParts > 0 ? 1 : 0) != 0, (Object)"Max Parts Should be greater than zero");
        Preconditions.checkArgument((partNumberMarker >= 0 ? 1 : 0) != 0, (Object)"Part Number Marker Should be greater than or equal to zero, as part numbers starts from 1 and ranges till 10000");
        OmMultipartUploadListParts omMultipartUploadListParts = this.ozoneManagerClient.listParts(volumeName, bucketName, keyName, uploadID, partNumberMarker, maxParts);
        OzoneMultipartUploadPartListParts ozoneMultipartUploadPartListParts = new OzoneMultipartUploadPartListParts(ReplicationType.valueOf((String)omMultipartUploadListParts.getReplicationType().toString()), omMultipartUploadListParts.getNextPartNumberMarker(), omMultipartUploadListParts.isTruncated());
        for (OmPartInfo omPartInfo : omMultipartUploadListParts.getPartInfoList()) {
            ozoneMultipartUploadPartListParts.addPart(new OzoneMultipartUploadPartListParts.PartInfo(omPartInfo.getPartNumber(), omPartInfo.getPartName(), omPartInfo.getModificationTime(), omPartInfo.getSize()));
        }
        return ozoneMultipartUploadPartListParts;
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        return OzoneKMSUtil.getKeyProvider((Configuration)this.conf, this.getKeyProviderUri());
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        return OzoneKMSUtil.getKeyProviderUri(this.ugi, null, null, (Configuration)this.conf);
    }

    @Override
    public String getCanonicalServiceName() {
        return this.dtService != null ? this.dtService.toString() : null;
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.getDelegationToken(renewer == null ? null : new Text(renewer));
    }
}

