/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneKeyLocation;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rest.DefaultRestServerSelector;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.client.rest.RestServerSelector;
import org.apache.hadoop.ozone.client.rest.response.BucketInfo;
import org.apache.hadoop.ozone.client.rest.response.KeyInfoDetails;
import org.apache.hadoop.ozone.client.rest.response.VolumeInfo;
import org.apache.hadoop.ozone.client.rpc.OzoneKMSUtil;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.ha.OMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.web.response.ListBuckets;
import org.apache.hadoop.ozone.web.response.ListKeys;
import org.apache.hadoop.ozone.web.response.ListVolumes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient
implements ClientProtocol {
    private static final String PATH_SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(RestClient.class);
    private final Configuration conf;
    private final URI ozoneRestUri;
    private final CloseableHttpClient httpClient;
    private final UserGroupInformation ugi;
    private final OzoneAcl.OzoneACLRights userRights;

    public RestClient(Configuration conf) throws IOException {
        try {
            Preconditions.checkNotNull((Object)conf);
            this.conf = conf;
            this.ugi = UserGroupInformation.getCurrentUser();
            long socketTimeout = conf.getTimeDuration("ozone.client.socket.timeout", 5000L, TimeUnit.MILLISECONDS);
            long connectionTimeout = conf.getTimeDuration("ozone.client.connection.timeout", 5000L, TimeUnit.MILLISECONDS);
            int maxConnection = conf.getInt("ozone.rest.client.http.connection.max", 100);
            int maxConnectionPerRoute = conf.getInt("ozone.rest.client.http.connection.per-route.max", 20);
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
            connManager.setMaxTotal(maxConnection);
            connManager.setDefaultMaxPerRoute(maxConnectionPerRoute);
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(Math.toIntExact(socketTimeout)).setConnectTimeout(Math.toIntExact(connectionTimeout)).build()).build();
            this.userRights = (OzoneAcl.OzoneACLRights)conf.getEnum("ozone.om.user.rights", (Enum)OMConfigKeys.OZONE_OM_USER_RIGHTS_DEFAULT);
            DefaultRestServerSelector defaultSelector = new DefaultRestServerSelector();
            InetSocketAddress restServer = this.getOzoneRestServerAddress(defaultSelector);
            URIBuilder uriBuilder = new URIBuilder().setScheme("http").setHost(restServer.getHostName()).setPort(restServer.getPort());
            this.ozoneRestUri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress getOzoneRestServerAddress(RestServerSelector selector) throws IOException {
        String httpAddress = this.conf.get("ozone.om.http-address");
        if (httpAddress == null) {
            throw new IllegalArgumentException("ozone.om.http-address must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        HttpGet httpGet = new HttpGet("http://" + httpAddress + "/serviceList");
        HttpEntity entity = this.executeHttpRequest((HttpUriRequest)httpGet);
        try {
            String serviceListJson = EntityUtils.toString((HttpEntity)entity);
            ObjectMapper objectMapper = new ObjectMapper();
            TypeReference<List<ServiceInfo>> serviceInfoReference = new TypeReference<List<ServiceInfo>>(){};
            List services = (List)objectMapper.readValue(serviceListJson, (TypeReference)serviceInfoReference);
            List<ServiceInfo> dataNodeInfos = services.stream().filter(a -> a.getNodeType().equals((Object)HddsProtos.NodeType.DATANODE)).collect(Collectors.toList());
            ServiceInfo restServer = selector.getRestServer(dataNodeInfos);
            InetSocketAddress inetSocketAddress = NetUtils.createSocketAddr((String)(NetUtils.normalizeHostName((String)restServer.getHostname()) + ":" + restServer.getPort(OzoneManagerProtocolProtos.ServicePort.Type.HTTP)));
            return inetSocketAddress;
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    @Override
    public void createVolume(String volumeName) throws IOException {
        this.createVolume(volumeName, VolumeArgs.newBuilder().build());
    }

    @Override
    public void createVolume(String volumeName, VolumeArgs volArgs) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String)volumeName);
            Preconditions.checkNotNull((Object)volArgs);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            String owner = volArgs.getOwner() == null ? this.ugi.getUserName() : volArgs.getOwner();
            builder.setPath(PATH_SEPARATOR + volumeName);
            String quota = volArgs.getQuota();
            if (quota != null) {
                builder.setParameter("quota", quota);
            }
            HttpPost httpPost = new HttpPost(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpPost);
            if (volArgs.getAdmin() != null) {
                httpPost.removeHeaders("Authorization");
                httpPost.addHeader("Authorization", "OZONE " + volArgs.getAdmin());
            }
            httpPost.addHeader("x-ozone-user", owner);
            LOG.info("Creating Volume: {}, with {} as owner and quota set to {}.", new Object[]{volumeName, owner, quota == null ? "default" : quota});
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpPost));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setVolumeOwner(String volumeName, String owner) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String)volumeName);
            Preconditions.checkNotNull((Object)owner);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName);
            HttpPut httpPut = new HttpPut(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpPut);
            httpPut.addHeader("x-ozone-user", owner);
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpPut));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setVolumeQuota(String volumeName, OzoneQuota quota) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String)volumeName);
            Preconditions.checkNotNull((Object)quota);
            String quotaString = quota.toString();
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName);
            builder.setParameter("quota", quotaString);
            HttpPut httpPut = new HttpPut(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpPut);
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpPut));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public OzoneVolume getVolumeDetails(String volumeName) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String)volumeName);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName);
            builder.setParameter("info", "volume");
            HttpGet httpGet = new HttpGet(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpGet);
            HttpEntity response = this.executeHttpRequest((HttpUriRequest)httpGet);
            VolumeInfo volInfo = VolumeInfo.parse((String)EntityUtils.toString((HttpEntity)response));
            OzoneVolume volume = new OzoneVolume(this.conf, this, volInfo.getVolumeName(), volInfo.getCreatedBy(), volInfo.getOwner().getName(), volInfo.getQuota().sizeInBytes(), HddsClientUtils.formatDateTime((String)volInfo.getCreatedOn()), null);
            EntityUtils.consume((HttpEntity)response);
            return volume;
        }
        catch (URISyntaxException | ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean checkVolumeAccess(String volumeName, OzoneAcl acl) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void deleteVolume(String volumeName) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String)volumeName);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName);
            HttpDelete httpDelete = new HttpDelete(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpDelete);
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpDelete));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<OzoneVolume> listVolumes(String volumePrefix, String prevKey, int maxListResult) throws IOException {
        return this.listVolumes(null, volumePrefix, prevKey, maxListResult);
    }

    @Override
    public List<OzoneVolume> listVolumes(String user, String volumePrefix, String prevKey, int maxListResult) throws IOException {
        try {
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR);
            builder.addParameter("info", "service");
            builder.addParameter("max-keys", String.valueOf(maxListResult));
            this.addQueryParamter("prefix", volumePrefix, builder);
            this.addQueryParamter("prev-key", prevKey, builder);
            HttpGet httpGet = new HttpGet(builder.build());
            if (!Strings.isNullOrEmpty((String)user)) {
                httpGet.addHeader("x-ozone-user", user);
            }
            this.addOzoneHeaders((HttpUriRequest)httpGet);
            HttpEntity response = this.executeHttpRequest((HttpUriRequest)httpGet);
            ListVolumes volumeList = ListVolumes.parse((String)EntityUtils.toString((HttpEntity)response));
            EntityUtils.consume((HttpEntity)response);
            return volumeList.getVolumes().stream().map(volInfo -> {
                long creationTime = 0L;
                try {
                    creationTime = HddsClientUtils.formatDateTime((String)volInfo.getCreatedOn());
                }
                catch (ParseException e) {
                    LOG.warn("Parse exception in getting creation time for volume", (Throwable)e);
                }
                return new OzoneVolume(this.conf, this, volInfo.getVolumeName(), volInfo.getCreatedBy(), volInfo.getOwner().getName(), volInfo.getQuota().sizeInBytes(), creationTime, null);
            }).collect(Collectors.toList());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void createBucket(String volumeName, String bucketName) throws IOException {
        this.createBucket(volumeName, bucketName, BucketArgs.newBuilder().build());
    }

    @Override
    public void createBucket(String volumeName, String bucketName, BucketArgs bucketArgs) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            Preconditions.checkNotNull((Object)bucketArgs);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            OzoneConsts.Versioning versioning = OzoneConsts.Versioning.DISABLED;
            if (bucketArgs.getVersioning() != null && bucketArgs.getVersioning().booleanValue()) {
                versioning = OzoneConsts.Versioning.ENABLED;
            }
            StorageType storageType = bucketArgs.getStorageType() == null ? StorageType.DEFAULT : bucketArgs.getStorageType();
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName);
            HttpPost httpPost = new HttpPost(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpPost);
            if (bucketArgs.getAcls() != null) {
                for (OzoneAcl acl : bucketArgs.getAcls()) {
                    httpPost.addHeader("x-ozone-acls", "ADD " + acl.toString());
                }
            }
            httpPost.addHeader("x-ozone-storage-type", storageType.toString());
            httpPost.addHeader("x-ozone-bucket-versioning", versioning.toString());
            LOG.info("Creating Bucket: {}/{}, with Versioning {} and Storage Type set to {}", new Object[]{volumeName, bucketName, versioning, storageType});
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpPost));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void addBucketAcls(String volumeName, String bucketName, List<OzoneAcl> addAcls) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            Preconditions.checkNotNull(addAcls);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName);
            HttpPut httpPut = new HttpPut(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpPut);
            for (OzoneAcl acl : addAcls) {
                httpPut.addHeader("x-ozone-acls", "ADD " + acl.toString());
            }
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpPut));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeBucketAcls(String volumeName, String bucketName, List<OzoneAcl> removeAcls) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            Preconditions.checkNotNull(removeAcls);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName);
            HttpPut httpPut = new HttpPut(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpPut);
            for (OzoneAcl acl : removeAcls) {
                httpPut.addHeader("x-ozone-acls", "REMOVE " + acl.toString());
            }
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpPut));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setBucketVersioning(String volumeName, String bucketName, Boolean versioning) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            Preconditions.checkNotNull((Object)versioning);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName);
            HttpPut httpPut = new HttpPut(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpPut);
            httpPut.addHeader("x-ozone-bucket-versioning", this.getBucketVersioning(versioning).toString());
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpPut));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setBucketStorageType(String volumeName, String bucketName, StorageType storageType) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            Preconditions.checkNotNull((Object)storageType);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName);
            HttpPut httpPut = new HttpPut(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpPut);
            httpPut.addHeader("x-ozone-storage-type", storageType.toString());
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpPut));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteBucket(String volumeName, String bucketName) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName);
            HttpDelete httpDelete = new HttpDelete(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpDelete);
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpDelete));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void checkBucketAccess(String volumeName, String bucketName) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public OzoneBucket getBucketDetails(String volumeName, String bucketName) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName);
            builder.setParameter("info", "bucket");
            HttpGet httpGet = new HttpGet(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpGet);
            HttpEntity response = this.executeHttpRequest((HttpUriRequest)httpGet);
            BucketInfo bucketInfo = BucketInfo.parse((String)EntityUtils.toString((HttpEntity)response));
            OzoneBucket bucket = new OzoneBucket(this.conf, this, bucketInfo.getVolumeName(), bucketInfo.getBucketName(), bucketInfo.getAcls(), bucketInfo.getStorageType(), this.getBucketVersioningFlag(bucketInfo.getVersioning()), HddsClientUtils.formatDateTime((String)bucketInfo.getCreatedOn()), new HashMap<String, String>());
            EntityUtils.consume((HttpEntity)response);
            return bucket;
        }
        catch (URISyntaxException | ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<OzoneBucket> listBuckets(String volumeName, String bucketPrefix, String prevBucket, int maxListResult) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String)volumeName);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName);
            builder.addParameter("info", "bucket");
            builder.addParameter("max-keys", String.valueOf(maxListResult));
            this.addQueryParamter("prefix", bucketPrefix, builder);
            this.addQueryParamter("prev-key", prevBucket, builder);
            HttpGet httpGet = new HttpGet(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpGet);
            HttpEntity response = this.executeHttpRequest((HttpUriRequest)httpGet);
            ListBuckets bucketList = ListBuckets.parse((String)EntityUtils.toString((HttpEntity)response));
            EntityUtils.consume((HttpEntity)response);
            return bucketList.getBuckets().stream().map(bucketInfo -> {
                long creationTime = 0L;
                try {
                    creationTime = HddsClientUtils.formatDateTime((String)bucketInfo.getCreatedOn());
                }
                catch (ParseException e) {
                    LOG.warn("Parse exception in getting creation time for volume", (Throwable)e);
                }
                return new OzoneBucket(this.conf, this, volumeName, bucketInfo.getBucketName(), bucketInfo.getAcls(), bucketInfo.getStorageType(), this.getBucketVersioningFlag(bucketInfo.getVersioning()), creationTime, new HashMap<String, String>(), bucketInfo.getEncryptionKeyName());
            }).collect(Collectors.toList());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public OzoneOutputStream createKey(String volumeName, String bucketName, String keyName, long size, ReplicationType type, ReplicationFactor factor, Map<String, String> metadata) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            HddsClientUtils.checkNotNull((Object[])new Serializable[]{keyName, type, factor});
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName + PATH_SEPARATOR + keyName);
            HttpPut putRequest = new HttpPut(builder.build());
            this.addOzoneHeaders((HttpUriRequest)putRequest);
            PipedInputStream in = new PipedInputStream();
            final PipedOutputStream out = new PipedOutputStream(in);
            putRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)in, size));
            final FutureTask<HttpEntity> futureTask = new FutureTask<HttpEntity>(() -> this.executeHttpRequest((HttpUriRequest)putRequest));
            new Thread(futureTask).start();
            OzoneOutputStream outputStream = new OzoneOutputStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    out.write(b);
                }

                @Override
                public void close() throws IOException {
                    try {
                        out.close();
                        EntityUtils.consume((HttpEntity)((HttpEntity)futureTask.get()));
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new IOException(e);
                    }
                }
            });
            return outputStream;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        throw new IOException("Method not supported");
    }

    @Override
    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        throw new IOException("Method not supported");
    }

    @Override
    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        throw new IOException("Method not supported");
    }

    @Override
    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public OMFailoverProxyProvider getOMProxyProvider() {
        return null;
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        return OzoneKMSUtil.getKeyProvider(this.conf, this.getKeyProviderUri());
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        return OzoneKMSUtil.getKeyProviderUri(this.ugi, null, null, this.conf);
    }

    @Override
    public OzoneInputStream getKey(String volumeName, String bucketName, String keyName) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            Preconditions.checkNotNull((Object)keyName);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName + PATH_SEPARATOR + keyName);
            HttpGet getRequest = new HttpGet(builder.build());
            this.addOzoneHeaders((HttpUriRequest)getRequest);
            final HttpEntity entity = this.executeHttpRequest((HttpUriRequest)getRequest);
            final PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            FutureTask<Void> futureTask = new FutureTask<Void>(() -> {
                entity.writeTo(out);
                out.close();
                return null;
            });
            new Thread(futureTask).start();
            OzoneInputStream inputStream = new OzoneInputStream(new InputStream(){

                @Override
                public int read() throws IOException {
                    return in.read();
                }

                @Override
                public void close() throws IOException {
                    in.close();
                    EntityUtils.consume((HttpEntity)entity);
                }
            });
            return inputStream;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteKey(String volumeName, String bucketName, String keyName) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            Preconditions.checkNotNull((Object)keyName);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName + PATH_SEPARATOR + keyName);
            HttpDelete httpDelete = new HttpDelete(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpDelete);
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpDelete));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void renameKey(String volumeName, String bucketName, String fromKeyName, String toKeyName) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            HddsClientUtils.checkNotNull((Object[])new String[]{fromKeyName, toKeyName});
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName + PATH_SEPARATOR + fromKeyName);
            builder.addParameter("toKey", toKeyName);
            HttpPost httpPost = new HttpPost(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpPost);
            EntityUtils.consume((HttpEntity)this.executeHttpRequest((HttpUriRequest)httpPost));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<OzoneKey> listKeys(String volumeName, String bucketName, String keyPrefix, String prevKey, int maxListResult) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String)volumeName);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName);
            builder.addParameter("info", "key");
            builder.addParameter("max-keys", String.valueOf(maxListResult));
            this.addQueryParamter("prefix", keyPrefix, builder);
            this.addQueryParamter("prev-key", prevKey, builder);
            HttpGet httpGet = new HttpGet(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpGet);
            HttpEntity response = this.executeHttpRequest((HttpUriRequest)httpGet);
            ListKeys keyList = ListKeys.parse((String)EntityUtils.toString((HttpEntity)response));
            EntityUtils.consume((HttpEntity)response);
            return keyList.getKeyList().stream().map(keyInfo -> {
                long creationTime = 0L;
                long modificationTime = 0L;
                try {
                    creationTime = HddsClientUtils.formatDateTime((String)keyInfo.getCreatedOn());
                    modificationTime = HddsClientUtils.formatDateTime((String)keyInfo.getModifiedOn());
                }
                catch (ParseException e) {
                    LOG.warn("Parse exception in getting creation time for volume", (Throwable)e);
                }
                return new OzoneKey(volumeName, bucketName, keyInfo.getKeyName(), keyInfo.getSize(), creationTime, modificationTime, ReplicationType.valueOf((String)keyInfo.getType().toString()));
            }).collect(Collectors.toList());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public OzoneKeyDetails getKeyDetails(String volumeName, String bucketName, String keyName) throws IOException {
        try {
            HddsClientUtils.verifyResourceName((String[])new String[]{volumeName, bucketName});
            Preconditions.checkNotNull((Object)keyName);
            URIBuilder builder = new URIBuilder(this.ozoneRestUri);
            builder.setPath(PATH_SEPARATOR + volumeName + PATH_SEPARATOR + bucketName + PATH_SEPARATOR + keyName);
            builder.setParameter("info", "key-detail");
            HttpGet httpGet = new HttpGet(builder.build());
            this.addOzoneHeaders((HttpUriRequest)httpGet);
            HttpEntity response = this.executeHttpRequest((HttpUriRequest)httpGet);
            KeyInfoDetails keyInfo = KeyInfoDetails.parse((String)EntityUtils.toString((HttpEntity)response));
            ArrayList<OzoneKeyLocation> ozoneKeyLocations = new ArrayList<OzoneKeyLocation>();
            keyInfo.getKeyLocations().forEach(a -> ozoneKeyLocations.add(new OzoneKeyLocation(a.getContainerID(), a.getLocalID(), a.getLength(), a.getOffset())));
            OzoneKeyDetails key = new OzoneKeyDetails(volumeName, bucketName, keyInfo.getKeyName(), keyInfo.getSize(), HddsClientUtils.formatDateTime((String)keyInfo.getCreatedOn()), HddsClientUtils.formatDateTime((String)keyInfo.getModifiedOn()), ozoneKeyLocations, ReplicationType.valueOf((String)keyInfo.getType().toString()), new HashMap<String, String>(), keyInfo.getFileEncryptionInfo());
            EntityUtils.consume((HttpEntity)response);
            return key;
        }
        catch (URISyntaxException | ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void createS3Bucket(String userName, String s3BucketName) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public void deleteS3Bucket(String s3BucketName) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public String getOzoneVolumeName(String s3BucketName) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public String getOzoneBucketName(String s3BucketName) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public List<OzoneBucket> listS3Buckets(String userName, String bucketPrefix, String prevBucket, int maxListResult) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    private void addOzoneHeaders(HttpUriRequest httpRequest) {
        httpRequest.addHeader("Authorization", "OZONE " + this.ugi.getUserName());
        httpRequest.addHeader("Date", HddsClientUtils.formatDateTime((long)Time.monotonicNow()));
        httpRequest.addHeader("x-ozone-version", "v1");
    }

    private HttpEntity executeHttpRequest(HttpUriRequest httpUriRequest) throws IOException {
        CloseableHttpResponse response = this.httpClient.execute(httpUriRequest);
        int errorCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (errorCode == 200 || errorCode == 201) {
            return entity;
        }
        if (entity != null) {
            throw new IOException((Throwable)OzoneException.parse((String)EntityUtils.toString((HttpEntity)entity)));
        }
        throw new IOException("Unexpected null in http payload, while processing request");
    }

    private Boolean getBucketVersioningFlag(OzoneConsts.Versioning version) {
        if (version != null) {
            switch (version) {
                case ENABLED: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private OzoneConsts.Versioning getBucketVersioning(Boolean flag) {
        if (flag != null) {
            if (flag.booleanValue()) {
                return OzoneConsts.Versioning.ENABLED;
            }
            return OzoneConsts.Versioning.DISABLED;
        }
        return OzoneConsts.Versioning.NOT_DEFINED;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private void addQueryParamter(String param, String value, URIBuilder builder) {
        if (!Strings.isNullOrEmpty((String)value)) {
            builder.addParameter(param, value);
        }
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(String volumeName, String bucketName, String keyName, ReplicationType type, ReplicationFactor factor) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public OzoneOutputStream createMultipartKey(String volumeName, String bucketName, String keyName, long size, int partNumber, String uploadID) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public OmMultipartUploadCompleteInfo completeMultipartUpload(String volumeName, String bucketName, String keyName, String uploadID, Map<Integer, String> partsMap) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public void abortMultipartUpload(String volumeName, String bucketName, String keyName, String uploadID) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public OzoneMultipartUploadPartListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }

    @Override
    public String getCanonicalServiceName() {
        throw new UnsupportedOperationException("Ozone REST protocol does not support this operation.");
    }
}

