/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerNotOpenException;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.io.BlockOutputStreamEntry;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.ratis.protocol.AlreadyClosedException;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.RaftRetryFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyOutputStream
extends OutputStream {
    public static final Logger LOG = LoggerFactory.getLogger(KeyOutputStream.class);
    private final ArrayList<BlockOutputStreamEntry> streamEntries = new ArrayList();
    private int currentStreamIndex;
    private final OzoneManagerProtocol omClient;
    private final OmKeyArgs keyArgs;
    private final long openID;
    private final XceiverClientManager xceiverClientManager;
    private final int chunkSize;
    private final String requestID;
    private boolean closed;
    private final long streamBufferFlushSize;
    private final long streamBufferMaxSize;
    private final long watchTimeout;
    private final long blockSize;
    private final int bytesPerChecksum;
    private final ContainerProtos.ChecksumType checksumType;
    private final BufferPool bufferPool;
    private OmMultipartCommitUploadPartInfo commitUploadPartInfo;
    private FileEncryptionInfo feInfo;
    private ExcludeList excludeList;
    private final RetryPolicy retryPolicy;
    private int retryCount;
    private long offset;

    @VisibleForTesting
    public KeyOutputStream() {
        this.omClient = null;
        this.keyArgs = null;
        this.openID = -1L;
        this.xceiverClientManager = null;
        this.chunkSize = 0;
        this.requestID = null;
        this.closed = false;
        this.streamBufferFlushSize = 0L;
        this.streamBufferMaxSize = 0L;
        this.bufferPool = new BufferPool(this.chunkSize, 1);
        this.watchTimeout = 0L;
        this.blockSize = 0L;
        this.checksumType = ContainerProtos.ChecksumType.valueOf((String)"SHA256");
        this.bytesPerChecksum = 0x100000;
        this.retryPolicy = RetryPolicies.TRY_ONCE_THEN_FAIL;
        this.retryCount = 0;
        this.offset = 0L;
    }

    @VisibleForTesting
    public List<BlockOutputStreamEntry> getStreamEntries() {
        return this.streamEntries;
    }

    @VisibleForTesting
    public XceiverClientManager getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    public List<OmKeyLocationInfo> getLocationInfoList() throws IOException {
        ArrayList<OmKeyLocationInfo> locationInfoList = new ArrayList<OmKeyLocationInfo>();
        for (BlockOutputStreamEntry streamEntry : this.streamEntries) {
            OmKeyLocationInfo info = new OmKeyLocationInfo.Builder().setBlockID(streamEntry.getBlockID()).setLength(streamEntry.getCurrentPosition()).setOffset(0L).setToken(streamEntry.getToken()).setPipeline(streamEntry.getPipeline()).build();
            LOG.debug("block written " + streamEntry.getBlockID() + ", length " + streamEntry.getCurrentPosition() + " bcsID " + streamEntry.getBlockID().getBlockCommitSequenceId());
            locationInfoList.add(info);
        }
        return locationInfoList;
    }

    @VisibleForTesting
    public int getRetryCount() {
        return this.retryCount;
    }

    public KeyOutputStream(OpenKeySession handler, XceiverClientManager xceiverClientManager, OzoneManagerProtocol omClient, int chunkSize, String requestId, HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType type, long bufferFlushSize, long bufferMaxSize, long size, long watchTimeout, ContainerProtos.ChecksumType checksumType, int bytesPerChecksum, String uploadID, int partNumber, boolean isMultipart, int maxRetryCount) {
        this.currentStreamIndex = 0;
        this.omClient = omClient;
        OmKeyInfo info = handler.getKeyInfo();
        this.feInfo = info.getFileEncryptionInfo();
        this.keyArgs = new OmKeyArgs.Builder().setVolumeName(info.getVolumeName()).setBucketName(info.getBucketName()).setKeyName(info.getKeyName()).setType(type).setFactor(factor).setDataSize(info.getDataSize()).setIsMultipartKey(isMultipart).setMultipartUploadID(uploadID).setMultipartUploadPartNumber(partNumber).build();
        this.openID = handler.getId();
        this.xceiverClientManager = xceiverClientManager;
        this.chunkSize = chunkSize;
        this.requestID = requestId;
        this.streamBufferFlushSize = bufferFlushSize;
        this.streamBufferMaxSize = bufferMaxSize;
        this.blockSize = size;
        this.watchTimeout = watchTimeout;
        this.bytesPerChecksum = bytesPerChecksum;
        this.checksumType = checksumType;
        Preconditions.checkState((chunkSize > 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.streamBufferFlushSize > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.streamBufferMaxSize > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.blockSize > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.streamBufferFlushSize % (long)chunkSize == 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.streamBufferMaxSize % this.streamBufferFlushSize == 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.blockSize % this.streamBufferMaxSize == 0L ? 1 : 0) != 0);
        this.bufferPool = new BufferPool(chunkSize, (int)this.streamBufferMaxSize / chunkSize);
        this.excludeList = new ExcludeList();
        this.retryPolicy = OzoneClientUtils.createRetryPolicy(maxRetryCount);
        this.retryCount = 0;
    }

    public void addPreallocateBlocks(OmKeyLocationInfoGroup version, long openVersion) throws IOException {
        for (OmKeyLocationInfo subKeyInfo : version.getLocationList()) {
            if (subKeyInfo.getCreateVersion() != openVersion) continue;
            this.addKeyLocationInfo(subKeyInfo);
        }
    }

    private void addKeyLocationInfo(OmKeyLocationInfo subKeyInfo) throws IOException {
        Preconditions.checkNotNull((Object)subKeyInfo.getPipeline());
        UserGroupInformation.getCurrentUser().addToken(subKeyInfo.getToken());
        BlockOutputStreamEntry.Builder builder = new BlockOutputStreamEntry.Builder().setBlockID(subKeyInfo.getBlockID()).setKey(this.keyArgs.getKeyName()).setXceiverClientManager(this.xceiverClientManager).setPipeline(subKeyInfo.getPipeline()).setRequestId(this.requestID).setChunkSize(this.chunkSize).setLength(subKeyInfo.getLength()).setStreamBufferFlushSize(this.streamBufferFlushSize).setStreamBufferMaxSize(this.streamBufferMaxSize).setWatchTimeout(this.watchTimeout).setbufferPool(this.bufferPool).setChecksumType(this.checksumType).setBytesPerChecksum(this.bytesPerChecksum).setToken((Token<OzoneBlockTokenIdentifier>)subKeyInfo.getToken());
        this.streamEntries.add(builder.build());
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkNotClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.handleWrite(b, off, len, false);
    }

    private long computeBufferData() {
        return this.bufferPool.computeBufferData();
    }

    private void handleWrite(byte[] b, int off, long len, boolean retry) throws IOException {
        int succeededAllocates = 0;
        while (len > 0L) {
            if (this.streamEntries.size() <= this.currentStreamIndex) {
                Preconditions.checkNotNull((Object)this.omClient);
                try {
                    this.allocateNewBlock(this.currentStreamIndex);
                    ++succeededAllocates;
                }
                catch (IOException ioe) {
                    LOG.error("Try to allocate more blocks for write failed, already allocated " + succeededAllocates + " blocks for this write.");
                    throw ioe;
                }
            }
            Preconditions.checkArgument((this.currentStreamIndex < this.streamEntries.size() ? 1 : 0) != 0);
            BlockOutputStreamEntry current = this.streamEntries.get(this.currentStreamIndex);
            int writeLen = Math.min((int)len, (int)current.getRemaining());
            long currentPos = current.getWrittenDataLength();
            try {
                if (retry) {
                    current.writeOnRetry(len);
                } else {
                    current.write(b, off, writeLen);
                    this.offset += (long)writeLen;
                }
            }
            catch (IOException ioe) {
                Preconditions.checkState((!retry || len <= this.streamBufferMaxSize ? 1 : 0) != 0);
                int dataWritten = (int)(current.getWrittenDataLength() - currentPos);
                int n = writeLen = retry ? (int)len : dataWritten;
                if (!retry) {
                    this.offset += (long)writeLen;
                }
                LOG.debug("writeLen {}, total len {}", (Object)writeLen, (Object)len);
                this.handleException(current, this.currentStreamIndex, ioe);
            }
            if (current.getRemaining() <= 0L) {
                this.handleFlushOrClose(StreamAction.FULL);
            }
            len -= (long)writeLen;
            off += writeLen;
        }
    }

    private void discardPreallocatedBlocks(long containerID, PipelineID pipelineId, int streamIndex) {
        if (streamIndex < this.streamEntries.size()) {
            ListIterator<BlockOutputStreamEntry> streamEntryIterator = this.streamEntries.listIterator(streamIndex);
            while (streamEntryIterator.hasNext()) {
                BlockOutputStreamEntry streamEntry = streamEntryIterator.next();
                Preconditions.checkArgument((streamEntry.getCurrentPosition() == 0L ? 1 : 0) != 0);
                if ((pipelineId == null || !streamEntry.getPipeline().getId().equals((Object)pipelineId)) && (containerID == -1L || streamEntry.getBlockID().getContainerID() != containerID)) continue;
                streamEntryIterator.remove();
            }
        }
    }

    private void removeEmptyBlocks() {
        if (this.currentStreamIndex < this.streamEntries.size()) {
            ListIterator<BlockOutputStreamEntry> streamEntryIterator = this.streamEntries.listIterator(this.currentStreamIndex);
            while (streamEntryIterator.hasNext()) {
                if (streamEntryIterator.next().getCurrentPosition() != 0L) continue;
                streamEntryIterator.remove();
            }
        }
    }

    private void handleException(BlockOutputStreamEntry streamEntry, int streamIndex, IOException exception) throws IOException {
        Throwable t = this.checkForException(exception);
        boolean retryFailure = this.checkForRetryFailure(t);
        boolean closedContainerException = false;
        if (!retryFailure) {
            closedContainerException = this.checkIfContainerIsClosed(t);
        }
        PipelineID pipelineId = null;
        long totalSuccessfulFlushedData = streamEntry.getTotalAckDataLength();
        streamEntry.setCurrentPosition(totalSuccessfulFlushedData);
        long bufferedDataLen = this.computeBufferData();
        LOG.warn("Encountered exception {}. The last committed block length is {}, uncommitted data length is {} retry count {}", new Object[]{exception, totalSuccessfulFlushedData, bufferedDataLen, this.retryCount});
        Preconditions.checkArgument((bufferedDataLen <= this.streamBufferMaxSize ? 1 : 0) != 0);
        Preconditions.checkArgument((this.offset - this.getKeyLength() == bufferedDataLen ? 1 : 0) != 0);
        long containerId = streamEntry.getBlockID().getContainerID();
        Collection<DatanodeDetails> failedServers = streamEntry.getFailedServers();
        Preconditions.checkNotNull(failedServers);
        if (!failedServers.isEmpty()) {
            this.excludeList.addDatanodes(failedServers);
        }
        if (closedContainerException) {
            this.excludeList.addConatinerId(ContainerID.valueof((long)containerId));
        } else if (retryFailure || t instanceof TimeoutException || t instanceof GroupMismatchException) {
            pipelineId = streamEntry.getPipeline().getId();
            this.excludeList.addPipeline(pipelineId);
        }
        streamEntry.cleanup(retryFailure);
        if (closedContainerException) {
            this.discardPreallocatedBlocks(streamEntry.getBlockID().getContainerID(), null, streamIndex + 1);
        } else {
            this.discardPreallocatedBlocks(-1L, pipelineId, streamIndex + 1);
        }
        if (bufferedDataLen > 0L) {
            ++this.currentStreamIndex;
            this.handleRetry(exception, bufferedDataLen);
            this.retryCount = 0;
        }
        if (totalSuccessfulFlushedData == 0L) {
            this.streamEntries.remove(streamIndex);
            --this.currentStreamIndex;
        }
    }

    private void handleRetry(IOException exception, long len) throws IOException {
        RetryPolicy.RetryAction action;
        try {
            action = this.retryPolicy.shouldRetry((Exception)exception, this.retryCount, 0, true);
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
        if (action.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
            String msg = "";
            if (action.reason != null) {
                msg = "Retry request failed. " + action.reason;
                LOG.error(msg, (Throwable)exception);
            }
            throw new IOException(msg, exception);
        }
        if (Thread.currentThread().isInterrupted()) {
            LOG.warn("Interrupted while trying for retry");
            throw exception;
        }
        Preconditions.checkArgument((action.action == RetryPolicy.RetryAction.RetryDecision.RETRY ? 1 : 0) != 0);
        if (action.delayMillis > 0L) {
            try {
                Thread.sleep(action.delayMillis);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException("Interrupted: action=" + action + ", retry policy=" + this.retryPolicy).initCause(e);
            }
        }
        ++this.retryCount;
        LOG.trace("Retrying Write request. Already tried " + this.retryCount + " time(s); retry policy is " + this.retryPolicy);
        this.handleWrite(null, 0, len, true);
    }

    private boolean checkForRetryFailure(Throwable t) {
        return t instanceof RaftRetryFailureException || t instanceof AlreadyClosedException;
    }

    private boolean checkIfContainerIsClosed(Throwable t) {
        return t instanceof ContainerNotOpenException;
    }

    public Throwable checkForException(IOException ioe) throws IOException {
        for (Throwable t = ioe.getCause(); t != null; t = t.getCause()) {
            for (Class<? extends Exception> cls : OzoneClientUtils.getExceptionList()) {
                if (!cls.isInstance(t)) continue;
                return t;
            }
        }
        throw ioe;
    }

    private long getKeyLength() {
        return this.streamEntries.stream().mapToLong(e -> e.getCurrentPosition()).sum();
    }

    private void allocateNewBlock(int index) throws IOException {
        OmKeyLocationInfo subKeyInfo = this.omClient.allocateBlock(this.keyArgs, this.openID, this.excludeList);
        this.addKeyLocationInfo(subKeyInfo);
    }

    @Override
    public void flush() throws IOException {
        this.checkNotClosed();
        this.handleFlushOrClose(StreamAction.FLUSH);
    }

    private void handleFlushOrClose(StreamAction op) throws IOException {
        int size;
        int streamIndex;
        BlockOutputStreamEntry entry;
        if (this.streamEntries.size() == 0) {
            return;
        }
        block7: while ((entry = this.streamEntries.get(streamIndex = this.currentStreamIndex >= (size = this.streamEntries.size()) ? size - 1 : this.currentStreamIndex)) != null) {
            try {
                Collection<DatanodeDetails> failedServers = entry.getFailedServers();
                if (failedServers != null && !failedServers.isEmpty()) {
                    this.excludeList.addDatanodes(failedServers);
                }
                switch (op) {
                    case CLOSE: {
                        entry.close();
                        break;
                    }
                    case FULL: {
                        if (entry.getRemaining() != 0L) break block7;
                        entry.close();
                        ++this.currentStreamIndex;
                        break;
                    }
                    case FLUSH: {
                        entry.flush();
                        break;
                    }
                    default: {
                        throw new IOException("Invalid Operation");
                    }
                }
                break;
            }
            catch (IOException ioe) {
                this.handleException(entry, streamIndex, ioe);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.handleFlushOrClose(StreamAction.CLOSE);
            if (this.keyArgs != null) {
                this.removeEmptyBlocks();
                long length = this.getKeyLength();
                Preconditions.checkArgument((this.offset == length ? 1 : 0) != 0);
                this.keyArgs.setDataSize(length);
                this.keyArgs.setLocationInfoList(this.getLocationInfoList());
                if (this.keyArgs.getIsMultipartKey()) {
                    this.commitUploadPartInfo = this.omClient.commitMultipartUploadPart(this.keyArgs, this.openID);
                } else {
                    this.omClient.commitKey(this.keyArgs, this.openID);
                }
            } else {
                LOG.warn("Closing KeyOutputStream, but key args is null");
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            this.bufferPool.clearBufferPool();
        }
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        return this.commitUploadPartInfo;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.feInfo;
    }

    @VisibleForTesting
    public ExcludeList getExcludeList() {
        return this.excludeList;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(": Stream is closed! Key: " + this.keyArgs.getKeyName());
        }
    }

    public static class Builder {
        private OpenKeySession openHandler;
        private XceiverClientManager xceiverManager;
        private OzoneManagerProtocol omClient;
        private int chunkSize;
        private String requestID;
        private HddsProtos.ReplicationType type;
        private HddsProtos.ReplicationFactor factor;
        private long streamBufferFlushSize;
        private long streamBufferMaxSize;
        private long blockSize;
        private long watchTimeout;
        private ContainerProtos.ChecksumType checksumType;
        private int bytesPerChecksum;
        private String multipartUploadID;
        private int multipartNumber;
        private boolean isMultipartKey;
        private int maxRetryCount;

        public Builder setMultipartUploadID(String uploadID) {
            this.multipartUploadID = uploadID;
            return this;
        }

        public Builder setMultipartNumber(int partNumber) {
            this.multipartNumber = partNumber;
            return this;
        }

        public Builder setHandler(OpenKeySession handler) {
            this.openHandler = handler;
            return this;
        }

        public Builder setXceiverClientManager(XceiverClientManager manager) {
            this.xceiverManager = manager;
            return this;
        }

        public Builder setOmClient(OzoneManagerProtocol client) {
            this.omClient = client;
            return this;
        }

        public Builder setChunkSize(int size) {
            this.chunkSize = size;
            return this;
        }

        public Builder setRequestID(String id) {
            this.requestID = id;
            return this;
        }

        public Builder setType(HddsProtos.ReplicationType replicationType) {
            this.type = replicationType;
            return this;
        }

        public Builder setFactor(HddsProtos.ReplicationFactor replicationFactor) {
            this.factor = replicationFactor;
            return this;
        }

        public Builder setStreamBufferFlushSize(long size) {
            this.streamBufferFlushSize = size;
            return this;
        }

        public Builder setStreamBufferMaxSize(long size) {
            this.streamBufferMaxSize = size;
            return this;
        }

        public Builder setBlockSize(long size) {
            this.blockSize = size;
            return this;
        }

        public Builder setWatchTimeout(long timeout) {
            this.watchTimeout = timeout;
            return this;
        }

        public Builder setChecksumType(ContainerProtos.ChecksumType cType) {
            this.checksumType = cType;
            return this;
        }

        public Builder setBytesPerChecksum(int bytes) {
            this.bytesPerChecksum = bytes;
            return this;
        }

        public Builder setIsMultipartKey(boolean isMultipart) {
            this.isMultipartKey = isMultipart;
            return this;
        }

        public Builder setMaxRetryCount(int maxCount) {
            this.maxRetryCount = maxCount;
            return this;
        }

        public KeyOutputStream build() throws IOException {
            return new KeyOutputStream(this.openHandler, this.xceiverManager, this.omClient, this.chunkSize, this.requestID, this.factor, this.type, this.streamBufferFlushSize, this.streamBufferMaxSize, this.blockSize, this.watchTimeout, this.checksumType, this.bytesPerChecksum, this.multipartUploadID, this.multipartNumber, this.isMultipartKey, this.maxRetryCount);
        }
    }

    static enum StreamAction {
        FLUSH,
        CLOSE,
        FULL;

    }
}

