/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.storage.BlockInputStream;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyInputStream
extends InputStream
implements Seekable {
    private static final Logger LOG = LoggerFactory.getLogger(KeyInputStream.class);
    private static final int EOF = -1;
    private final ArrayList<ChunkInputStreamEntry> streamEntries = new ArrayList();
    private long[] streamOffset = null;
    private int currentStreamIndex = 0;
    private long length = 0L;
    private boolean closed = false;
    private String key;

    @VisibleForTesting
    public synchronized int getCurrentStreamIndex() {
        return this.currentStreamIndex;
    }

    @VisibleForTesting
    public long getRemainingOfIndex(int index) throws IOException {
        return this.streamEntries.get(index).getRemaining();
    }

    public synchronized void addStream(BlockInputStream stream, long streamLength) {
        this.streamEntries.add(new ChunkInputStreamEntry(stream, streamLength));
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) == -1) {
            return -1;
        }
        return Byte.toUnsignedInt(buf[0]);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.checkNotClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int totalReadLen = 0;
        while (len > 0) {
            int numBytesToRead;
            if (this.streamEntries.size() == 0 || this.streamEntries.size() - 1 <= this.currentStreamIndex && this.streamEntries.get(this.currentStreamIndex).getRemaining() == 0L) {
                return totalReadLen == 0 ? -1 : totalReadLen;
            }
            ChunkInputStreamEntry current = this.streamEntries.get(this.currentStreamIndex);
            int numBytesRead = current.read(b, off, numBytesToRead = Math.min(len, (int)current.getRemaining()));
            if (numBytesRead != numBytesToRead) {
                throw new IOException(String.format("Inconsistent read for blockID=%s length=%d numBytesRead=%d", current.blockInputStream.getBlockID(), current.length, numBytesRead));
            }
            totalReadLen += numBytesRead;
            off += numBytesRead;
            len -= numBytesRead;
            if (current.getRemaining() > 0L || this.currentStreamIndex + 1 >= this.streamEntries.size()) continue;
            ++this.currentStreamIndex;
        }
        return totalReadLen;
    }

    public void seek(long pos) throws IOException {
        this.checkNotClosed();
        if (pos < 0L || pos >= this.length) {
            if (pos == 0L) {
                return;
            }
            throw new EOFException("EOF encountered at pos: " + pos + " for key: " + this.key);
        }
        Preconditions.assertTrue((this.currentStreamIndex >= 0 ? 1 : 0) != 0);
        if (this.currentStreamIndex >= this.streamEntries.size()) {
            this.currentStreamIndex = Arrays.binarySearch(this.streamOffset, pos);
        } else if (pos < this.streamOffset[this.currentStreamIndex]) {
            this.currentStreamIndex = Arrays.binarySearch(this.streamOffset, 0, this.currentStreamIndex, pos);
        } else if (pos >= this.streamOffset[this.currentStreamIndex] + this.streamEntries.get(this.currentStreamIndex).length) {
            this.currentStreamIndex = Arrays.binarySearch(this.streamOffset, this.currentStreamIndex + 1, this.streamEntries.size(), pos);
        }
        if (this.currentStreamIndex < 0) {
            this.currentStreamIndex = -this.currentStreamIndex - 2;
        }
        this.streamEntries.get(this.currentStreamIndex).seek(pos - this.streamOffset[this.currentStreamIndex]);
    }

    public long getPos() throws IOException {
        return this.length == 0L ? 0L : this.streamOffset[this.currentStreamIndex] + this.streamEntries.get(this.currentStreamIndex).getPos();
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public int available() throws IOException {
        this.checkNotClosed();
        long remaining = this.length - this.getPos();
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        for (int i = 0; i < this.streamEntries.size(); ++i) {
            this.streamEntries.get(i).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LengthInputStream getFromOmKeyInfo(OmKeyInfo keyInfo, XceiverClientManager xceiverClientManager, StorageContainerLocationProtocol storageContainerLocationClient, String requestId, boolean verifyChecksum) throws IOException {
        long length = 0L;
        KeyInputStream groupInputStream = new KeyInputStream();
        groupInputStream.key = keyInfo.getKeyName();
        List keyLocationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
        groupInputStream.streamOffset = new long[keyLocationInfos.size()];
        for (int i = 0; i < keyLocationInfos.size(); ++i) {
            OmKeyLocationInfo omKeyLocationInfo = (OmKeyLocationInfo)keyLocationInfos.get(i);
            BlockID blockID = omKeyLocationInfo.getBlockID();
            long containerID = blockID.getContainerID();
            Pipeline pipeline = omKeyLocationInfo.getPipeline();
            if (pipeline.getType() != HddsProtos.ReplicationType.STAND_ALONE) {
                pipeline = Pipeline.newBuilder((Pipeline)pipeline).setType(HddsProtos.ReplicationType.STAND_ALONE).build();
            }
            XceiverClientSpi xceiverClient = xceiverClientManager.acquireClient(pipeline);
            boolean success = false;
            long containerKey = omKeyLocationInfo.getLocalID();
            try {
                LOG.debug("get key accessing {} {}", (Object)containerID, (Object)containerKey);
                groupInputStream.streamOffset[i] = length;
                ContainerProtos.DatanodeBlockID datanodeBlockID = blockID.getDatanodeBlockIDProtobuf();
                if (omKeyLocationInfo.getToken() != null) {
                    UserGroupInformation.getCurrentUser().addToken(omKeyLocationInfo.getToken());
                }
                ContainerProtos.GetBlockResponseProto response = ContainerProtocolCalls.getBlock((XceiverClientSpi)xceiverClient, (ContainerProtos.DatanodeBlockID)datanodeBlockID, (String)requestId);
                List chunks = response.getBlockData().getChunksList();
                for (ContainerProtos.ChunkInfo chunk : chunks) {
                    length += chunk.getLen();
                }
                success = true;
                BlockInputStream inputStream = new BlockInputStream(omKeyLocationInfo.getBlockID(), xceiverClientManager, xceiverClient, chunks, requestId, verifyChecksum);
                groupInputStream.addStream(inputStream, omKeyLocationInfo.getLength());
                continue;
            }
            finally {
                if (!success) {
                    xceiverClientManager.releaseClient(xceiverClient, false);
                }
            }
        }
        groupInputStream.length = length;
        return new LengthInputStream((InputStream)groupInputStream, length);
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(": Stream is closed! Key: " + this.key);
        }
    }

    public static class ChunkInputStreamEntry
    extends InputStream
    implements Seekable {
        private final BlockInputStream blockInputStream;
        private final long length;

        public ChunkInputStreamEntry(BlockInputStream blockInputStream, long length) {
            this.blockInputStream = blockInputStream;
            this.length = length;
        }

        synchronized long getRemaining() throws IOException {
            return this.length - this.getPos();
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int readLen = this.blockInputStream.read(b, off, len);
            return readLen;
        }

        @Override
        public synchronized int read() throws IOException {
            int data = this.blockInputStream.read();
            return data;
        }

        @Override
        public synchronized void close() throws IOException {
            this.blockInputStream.close();
        }

        public void seek(long pos) throws IOException {
            this.blockInputStream.seek(pos);
        }

        public long getPos() throws IOException {
            return this.blockInputStream.getPos();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }
    }
}

