/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockOutputStream;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public final class BlockOutputStreamEntry
extends OutputStream {
    private OutputStream outputStream = null;
    private BlockID blockID;
    private final String key;
    private final XceiverClientManager xceiverClientManager;
    private final Pipeline pipeline;
    private final ContainerProtos.ChecksumType checksumType;
    private final int bytesPerChecksum;
    private final String requestId;
    private final int chunkSize;
    private final long length;
    private long currentPosition;
    private Token<OzoneBlockTokenIdentifier> token;
    private final long streamBufferFlushSize;
    private final long streamBufferMaxSize;
    private final long watchTimeout;
    private BufferPool bufferPool;

    private BlockOutputStreamEntry(BlockID blockID, String key, XceiverClientManager xceiverClientManager, Pipeline pipeline, String requestId, int chunkSize, long length, long streamBufferFlushSize, long streamBufferMaxSize, long watchTimeout, BufferPool bufferPool, ContainerProtos.ChecksumType checksumType, int bytesPerChecksum, Token<OzoneBlockTokenIdentifier> token) {
        this.blockID = blockID;
        this.key = key;
        this.xceiverClientManager = xceiverClientManager;
        this.pipeline = pipeline;
        this.requestId = requestId;
        this.chunkSize = chunkSize;
        this.token = token;
        this.length = length;
        this.currentPosition = 0L;
        this.streamBufferFlushSize = streamBufferFlushSize;
        this.streamBufferMaxSize = streamBufferMaxSize;
        this.watchTimeout = watchTimeout;
        this.bufferPool = bufferPool;
        this.checksumType = checksumType;
        this.bytesPerChecksum = bytesPerChecksum;
    }

    long getLength() {
        return this.length;
    }

    Token<OzoneBlockTokenIdentifier> getToken() {
        return this.token;
    }

    long getRemaining() {
        return this.length - this.currentPosition;
    }

    private void checkStream() throws IOException {
        if (this.outputStream == null) {
            if (this.getToken() != null) {
                UserGroupInformation.getCurrentUser().addToken(this.getToken());
            }
            this.outputStream = new BlockOutputStream(this.blockID, this.key, this.xceiverClientManager, this.pipeline, this.requestId, this.chunkSize, this.streamBufferFlushSize, this.streamBufferMaxSize, this.watchTimeout, this.bufferPool, this.checksumType, this.bytesPerChecksum);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkStream();
        this.outputStream.write(b);
        ++this.currentPosition;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        this.outputStream.write(b, off, len);
        this.currentPosition += (long)len;
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.blockID = ((BlockOutputStream)this.outputStream).getBlockID();
        }
    }

    long getTotalAckDataLength() {
        if (this.outputStream != null) {
            BlockOutputStream out = (BlockOutputStream)this.outputStream;
            this.blockID = out.getBlockID();
            return out.getTotalAckDataLength();
        }
        return 0L;
    }

    Collection<DatanodeDetails> getFailedServers() throws IOException {
        if (this.outputStream != null) {
            BlockOutputStream out = (BlockOutputStream)this.outputStream;
            return out.getFailedServers();
        }
        return null;
    }

    long getWrittenDataLength() throws IOException {
        if (this.outputStream != null) {
            BlockOutputStream out = (BlockOutputStream)this.outputStream;
            return out.getWrittenDataLength();
        }
        return 0L;
    }

    void cleanup(boolean invalidateClient) throws IOException {
        this.checkStream();
        BlockOutputStream out = (BlockOutputStream)this.outputStream;
        out.cleanup(invalidateClient);
    }

    void writeOnRetry(long len) throws IOException {
        this.checkStream();
        BlockOutputStream out = (BlockOutputStream)this.outputStream;
        out.writeOnRetry(len);
        this.currentPosition += len;
    }

    @VisibleForTesting
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public String getKey() {
        return this.key;
    }

    public XceiverClientManager getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }

    public long getStreamBufferFlushSize() {
        return this.streamBufferFlushSize;
    }

    public long getStreamBufferMaxSize() {
        return this.streamBufferMaxSize;
    }

    public long getWatchTimeout() {
        return this.watchTimeout;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public void setCurrentPosition(long curPosition) {
        this.currentPosition = curPosition;
    }

    public static class Builder {
        private BlockID blockID;
        private String key;
        private XceiverClientManager xceiverClientManager;
        private Pipeline pipeline;
        private String requestId;
        private int chunkSize;
        private long length;
        private long streamBufferFlushSize;
        private long streamBufferMaxSize;
        private long watchTimeout;
        private BufferPool bufferPool;
        private Token<OzoneBlockTokenIdentifier> token;
        private ContainerProtos.ChecksumType checksumType;
        private int bytesPerChecksum;

        public Builder setChecksumType(ContainerProtos.ChecksumType type) {
            this.checksumType = type;
            return this;
        }

        public Builder setBytesPerChecksum(int bytes) {
            this.bytesPerChecksum = bytes;
            return this;
        }

        public Builder setBlockID(BlockID bID) {
            this.blockID = bID;
            return this;
        }

        public Builder setKey(String keys) {
            this.key = keys;
            return this;
        }

        public Builder setXceiverClientManager(XceiverClientManager xClientManager) {
            this.xceiverClientManager = xClientManager;
            return this;
        }

        public Builder setPipeline(Pipeline ppln) {
            this.pipeline = ppln;
            return this;
        }

        public Builder setRequestId(String request) {
            this.requestId = request;
            return this;
        }

        public Builder setChunkSize(int cSize) {
            this.chunkSize = cSize;
            return this;
        }

        public Builder setLength(long len) {
            this.length = len;
            return this;
        }

        public Builder setStreamBufferFlushSize(long bufferFlushSize) {
            this.streamBufferFlushSize = bufferFlushSize;
            return this;
        }

        public Builder setStreamBufferMaxSize(long bufferMaxSize) {
            this.streamBufferMaxSize = bufferMaxSize;
            return this;
        }

        public Builder setWatchTimeout(long timeout) {
            this.watchTimeout = timeout;
            return this;
        }

        public Builder setbufferPool(BufferPool pool) {
            this.bufferPool = pool;
            return this;
        }

        public Builder setToken(Token<OzoneBlockTokenIdentifier> bToken) {
            this.token = bToken;
            return this;
        }

        public BlockOutputStreamEntry build() {
            return new BlockOutputStreamEntry(this.blockID, this.key, this.xceiverClientManager, this.pipeline, this.requestId, this.chunkSize, this.length, this.streamBufferFlushSize, this.streamBufferMaxSize, this.watchTimeout, this.bufferPool, this.checksumType, this.bytesPerChecksum, this.token);
        }
    }
}

