/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.client.ReplicationType;

public class OzoneMultipartUploadPartListParts {
    private ReplicationType replicationType;
    private int nextPartNumberMarker;
    private boolean truncated;
    private List<PartInfo> partInfoList = new ArrayList<PartInfo>();

    public OzoneMultipartUploadPartListParts(ReplicationType type, int nextMarker, boolean truncate) {
        this.replicationType = type;
        this.nextPartNumberMarker = nextMarker;
        this.truncated = truncate;
    }

    public void addAllParts(List<PartInfo> partInfos) {
        this.partInfoList.addAll(partInfos);
    }

    public void addPart(PartInfo partInfo) {
        this.partInfoList.add(partInfo);
    }

    public ReplicationType getReplicationType() {
        return this.replicationType;
    }

    public int getNextPartNumberMarker() {
        return this.nextPartNumberMarker;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public List<PartInfo> getPartInfoList() {
        return this.partInfoList;
    }

    public static class PartInfo {
        private int partNumber;
        private String partName;
        private long modificationTime;
        private long size;

        public PartInfo(int number, String name, long time, long size) {
            this.partNumber = number;
            this.partName = name;
            this.modificationTime = time;
            this.size = size;
        }

        public int getPartNumber() {
            return this.partNumber;
        }

        public String getPartName() {
            return this.partName;
        }

        public long getModificationTime() {
            return this.modificationTime;
        }

        public long getSize() {
            return this.size;
        }
    }
}

