/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;

public final class BucketArgs {
    private List<OzoneAcl> acls;
    private Boolean versioning;
    private StorageType storageType;
    private Map<String, String> metadata;
    private String bucketEncryptionKey;

    private BucketArgs(Boolean versioning, StorageType storageType, List<OzoneAcl> acls, Map<String, String> metadata, String bucketEncryptionKey) {
        this.acls = acls;
        this.versioning = versioning;
        this.storageType = storageType;
        this.metadata = metadata;
        this.bucketEncryptionKey = bucketEncryptionKey;
    }

    public Boolean getVersioning() {
        return this.versioning;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getEncryptionKey() {
        return this.bucketEncryptionKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean versioning;
        private StorageType storageType;
        private List<OzoneAcl> acls;
        private Map<String, String> metadata = new HashMap<String, String>();
        private String bucketEncryptionKey;

        public Builder setVersioning(Boolean versionFlag) {
            this.versioning = versionFlag;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            this.acls = listOfAcls;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder setBucketEncryptionKey(String bek) {
            this.bucketEncryptionKey = bek;
            return this;
        }

        public BucketArgs build() {
            return new BucketArgs(this.versioning, this.storageType, this.acls, this.metadata, this.bucketEncryptionKey);
        }
    }
}

