/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mount;

import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.oncrpc.SimpleUdpServer;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MountdBase {
    public static final Logger LOG = LoggerFactory.getLogger(MountdBase.class);
    private final RpcProgram rpcProgram;
    private int udpBoundPort;
    private int tcpBoundPort;
    private SimpleUdpServer udpServer = null;
    private SimpleTcpServer tcpServer = null;
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;

    public RpcProgram getRpcProgram() {
        return this.rpcProgram;
    }

    public MountdBase(RpcProgram program) throws IOException {
        this.rpcProgram = program;
    }

    private void startUDPServer() {
        this.udpServer = new SimpleUdpServer(this.rpcProgram.getPort(), (ChannelInboundHandlerAdapter)this.rpcProgram, 1);
        this.rpcProgram.startDaemons();
        try {
            this.udpServer.run();
        }
        catch (Throwable e) {
            LOG.error("Failed to start the UDP server.", e);
            if (this.udpServer.getBoundPort() > 0) {
                this.rpcProgram.unregister(17, this.udpServer.getBoundPort());
            }
            this.udpServer.shutdown();
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        this.udpBoundPort = this.udpServer.getBoundPort();
    }

    private void startTCPServer() {
        this.tcpServer = new SimpleTcpServer(this.rpcProgram.getPort(), this.rpcProgram, 1);
        this.rpcProgram.startDaemons();
        try {
            this.tcpServer.run();
        }
        catch (Throwable e) {
            LOG.error("Failed to start the TCP server.", e);
            if (this.tcpServer.getBoundPort() > 0) {
                this.rpcProgram.unregister(6, this.tcpServer.getBoundPort());
            }
            this.tcpServer.shutdown();
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        this.tcpBoundPort = this.tcpServer.getBoundPort();
    }

    public void start(boolean register) {
        this.startUDPServer();
        this.startTCPServer();
        if (register) {
            ShutdownHookManager.get().addShutdownHook((Runnable)new Unregister(), 10);
            try {
                this.rpcProgram.register(17, this.udpBoundPort);
                this.rpcProgram.register(6, this.tcpBoundPort);
            }
            catch (Throwable e) {
                LOG.error("Failed to register the MOUNT service.", e);
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.udpBoundPort > 0) {
            this.rpcProgram.unregister(17, this.udpBoundPort);
            this.udpBoundPort = 0;
        }
        if (this.tcpBoundPort > 0) {
            this.rpcProgram.unregister(6, this.tcpBoundPort);
            this.tcpBoundPort = 0;
        }
        if (this.udpServer != null) {
            this.udpServer.shutdown();
            this.udpServer = null;
        }
        if (this.tcpServer != null) {
            this.tcpServer.shutdown();
            this.tcpServer = null;
        }
    }

    private class Unregister
    implements Runnable {
        private Unregister() {
        }

        @Override
        public synchronized void run() {
            MountdBase.this.stop();
        }
    }
}

