/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.cmakebuilder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.maven.plugin.util.Exec;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="cmake-test", defaultPhase=LifecyclePhase.TEST)
public class TestMojo
extends AbstractMojo {
    private static final String ALL_NATIVE = "allNative";
    @Parameter(required=true)
    private File binary;
    @Parameter
    private String testName;
    @Parameter
    private Map<String, String> env;
    @Parameter
    private List<String> args = new LinkedList<String>();
    @Parameter(defaultValue="600")
    private int timeout;
    @Parameter
    private File workingDirectory;
    @Parameter(defaultValue="native-results")
    private File results;
    @Parameter
    private Map<String, String> preconditions = new HashMap<String, String>();
    @Parameter(defaultValue="false")
    private boolean skipIfMissing;
    @Parameter(defaultValue="success")
    private String expectedResult;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    private static final String VALID_PRECONDITION_TYPES_STR = "Valid precondition types are \"and\", \"andNot\"";

    private static void validatePlatform() throws MojoExecutionException {
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows")) {
            throw new MojoExecutionException("CMakeBuilder does not yet support the Windows platform.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatusFile(String status) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(this.results, this.testName + ".pstatus"));
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));
            out.write(status + "\n");
        }
        finally {
            if (out != null) {
                out.close();
            } else {
                fos.close();
            }
        }
    }

    private static boolean isTruthy(String str) {
        if (str == null) {
            return false;
        }
        if (str.equalsIgnoreCase("")) {
            return false;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        if (str.equalsIgnoreCase("no")) {
            return false;
        }
        if (str.equalsIgnoreCase("off")) {
            return false;
        }
        return !str.equalsIgnoreCase("disable");
    }

    private void validateParameters() throws MojoExecutionException {
        if (!(this.expectedResult.equals("success") || this.expectedResult.equals("failure") || this.expectedResult.equals("any"))) {
            throw new MojoExecutionException("expectedResult must be either success, failure, or any");
        }
    }

    private boolean shouldRunTest() throws MojoExecutionException {
        String skipTests = this.session.getSystemProperties().getProperty("skipTests");
        if (TestMojo.isTruthy(skipTests)) {
            this.getLog().info((CharSequence)("skipTests is in effect for test " + this.testName));
            return false;
        }
        if (!this.binary.exists()) {
            if (this.skipIfMissing) {
                this.getLog().info((CharSequence)("Skipping missing test " + this.testName));
                return false;
            }
            throw new MojoExecutionException("Test " + this.binary + " was not built!  (File does not exist.)");
        }
        String testProp = this.session.getSystemProperties().getProperty("test");
        if (testProp != null) {
            String[] testPropArr = testProp.split(",");
            boolean found = false;
            for (String test : testPropArr) {
                if (test.equals(ALL_NATIVE)) {
                    found = true;
                    break;
                }
                if (!test.equals(this.testName)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.getLog().debug((CharSequence)("did not find test '" + this.testName + "' in list " + testProp));
                return false;
            }
        }
        if (this.preconditions != null) {
            int idx = 1;
            for (Map.Entry<String, String> entry : this.preconditions.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (key == null) {
                    throw new MojoExecutionException("NULL is not a valid precondition type.  Valid precondition types are \"and\", \"andNot\"");
                }
                if (key.equals("and")) {
                    if (!TestMojo.isTruthy(val)) {
                        this.getLog().info((CharSequence)("Skipping test " + this.testName + " because precondition number " + idx + " was not met."));
                        return false;
                    }
                } else if (key.equals("andNot")) {
                    if (TestMojo.isTruthy(val)) {
                        this.getLog().info((CharSequence)("Skipping test " + this.testName + " because negative precondition number " + idx + " was met."));
                        return false;
                    }
                } else {
                    throw new MojoExecutionException(key + " is not a valid precondition type.  Valid precondition types are \"and\", \"andNot\"");
                }
                ++idx;
            }
        }
        return true;
    }

    public void execute() throws MojoExecutionException {
        if (this.testName == null) {
            this.testName = this.binary.getName();
        }
        TestMojo.validatePlatform();
        this.validateParameters();
        if (!this.shouldRunTest()) {
            return;
        }
        if (!this.results.isDirectory() && !this.results.mkdirs()) {
            throw new MojoExecutionException("Failed to create output directory '" + this.results + "'!");
        }
        LinkedList<String> cmd = new LinkedList<String>();
        cmd.add(this.binary.getAbsolutePath());
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" C M A K E B U I L D E R    T E S T");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        StringBuilder bld = new StringBuilder();
        bld.append(this.testName).append(": running ");
        bld.append(this.binary.getAbsolutePath());
        for (String entry : this.args) {
            cmd.add(entry);
            bld.append(" ").append(entry);
        }
        this.getLog().info((CharSequence)bld.toString());
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Exec.addEnvironment(pb, this.env);
        if (this.workingDirectory != null) {
            pb.directory(this.workingDirectory);
        }
        pb.redirectError(new File(this.results, this.testName + ".stderr"));
        pb.redirectOutput(new File(this.results, this.testName + ".stdout"));
        this.getLog().info((CharSequence)("with extra environment variables " + Exec.envToString(this.env)));
        Process proc = null;
        Thread testThread = null;
        int retCode = -1;
        Object status = "IN_PROGRESS";
        try {
            this.writeStatusFile((String)status);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing the status file", (Exception)e);
        }
        long start = System.nanoTime();
        try {
            proc = pb.start();
            testThread = new TestThread(proc);
            testThread.start();
            testThread.join(this.timeout * 1000);
            if (!testThread.isAlive()) {
                retCode = ((TestThread)testThread).retCode();
                testThread = null;
                proc = null;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while executing the test " + this.testName, (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted while executing the test " + this.testName, (Exception)e);
        }
        finally {
            if (testThread != null) {
                testThread.interrupt();
                try {
                    testThread.join();
                }
                catch (InterruptedException e) {
                    this.getLog().error((CharSequence)"Interrupted while waiting for testThread", (Throwable)e);
                }
                status = "TIMED OUT";
            } else {
                status = retCode == 0 ? "SUCCESS" : "ERROR CODE " + String.valueOf(retCode);
            }
            try {
                this.writeStatusFile((String)status);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"failed to write status file!", (Throwable)e);
            }
            if (proc != null) {
                proc.destroy();
            }
        }
        long end = System.nanoTime();
        this.getLog().info((CharSequence)("STATUS: " + (String)status + " after " + TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS) + " millisecond(s)."));
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        if (((String)status).equals("TIMED_OUT")) {
            if (this.expectedResult.equals("success")) {
                throw new MojoExecutionException("Test " + this.binary + " timed out after " + this.timeout + " seconds!");
            }
        } else if (!((String)status).equals("SUCCESS")) {
            if (this.expectedResult.equals("success")) {
                throw new MojoExecutionException("Test " + this.binary + " returned " + (String)status);
            }
        } else if (this.expectedResult.equals("failure")) {
            throw new MojoExecutionException("Test " + this.binary + " succeeded, but we expected failure!");
        }
    }

    private static class TestThread
    extends Thread {
        private Process proc;
        private int retCode = -1;

        public TestThread(Process proc) {
            this.proc = proc;
        }

        @Override
        public void run() {
            try {
                this.retCode = this.proc.waitFor();
            }
            catch (InterruptedException e) {
                this.retCode = -1;
            }
        }

        public int retCode() {
            return this.retCode;
        }
    }
}

