/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.hadoop.examples.pi.Container;
import org.apache.hadoop.examples.pi.Util;
import org.apache.hadoop.examples.pi.math.Modular;
import org.apache.hadoop.examples.pi.math.Summation;

public final class Bellard {
    public static <T extends Container<Summation>> Map<Parameter, Sum> getSums(long b, int partsPerSum, Map<Parameter, List<T>> existing) {
        TreeMap<Parameter, Sum> sums = new TreeMap<Parameter, Sum>();
        for (Parameter p : Parameter.values()) {
            Sum s = new Sum(b, p, partsPerSum, existing.get((Object)p));
            Util.out.println("put " + s);
            sums.put(p, s);
        }
        return sums;
    }

    public static <T extends Container<Summation>> double computePi(long b, Map<Parameter, T> results) {
        if (results.size() != Parameter.values().length) {
            throw new IllegalArgumentException("m.size() != Parameter.values().length, m.size()=" + results.size() + "\n  m=" + results);
        }
        double pi = 0.0;
        for (Parameter p : Parameter.values()) {
            Summation sigma = (Summation)((Container)results.get((Object)p)).getElement();
            Sum s = new Sum(b, p, 1, null);
            s.setValue(sigma);
            pi = Modular.addMod(pi, s.getValue());
        }
        return pi;
    }

    public static double computePi(long b) {
        double pi = 0.0;
        for (Parameter p : Parameter.values()) {
            pi = Modular.addMod(pi, new Sum(b, p, 1, null).getValue());
        }
        return pi;
    }

    public static long bit2terms(long b) {
        return 7L * (b / 10L);
    }

    private static void computePi(Util.Timer t, long b) {
        t.tick(Util.pi2string(Bellard.computePi(b), Bellard.bit2terms(b)));
    }

    public static void main(String[] args) throws IOException {
        Util.Timer t = new Util.Timer(false);
        Bellard.computePi(t, 0L);
        Bellard.computePi(t, 1L);
        Bellard.computePi(t, 2L);
        Bellard.computePi(t, 3L);
        Bellard.computePi(t, 4L);
        Util.printBitSkipped(1008L);
        Bellard.computePi(t, 1008L);
        Bellard.computePi(t, 1012L);
        long b = 10L;
        for (int i = 0; i < 7; ++i) {
            Util.printBitSkipped(b);
            Bellard.computePi(t, b - 4L);
            Bellard.computePi(t, b);
            Bellard.computePi(t, b + 4L);
            b *= 10L;
        }
    }

    public static enum Parameter {
        P8_1(false, 1L, 8, -1),
        P8_3(false, 3L, 8, -6),
        P8_5(P8_1),
        P8_7(P8_3),
        P20_21(true, 1L, 20, 2),
        P20_3(false, 3L, 20, 0),
        P20_5(false, 5L, 20, -4),
        P20_7(false, 7L, 20, -4),
        P20_9(true, 9L, 20, -6),
        P20_11(P20_21),
        P20_13(P20_3),
        P20_15(P20_5),
        P20_17(P20_7),
        P20_19(P20_9);

        final boolean isplus;
        final long j;
        final int deltaN;
        final int deltaE;
        final int offsetE;

        private Parameter(boolean isplus, long j, int deltaN, int offsetE) {
            this.isplus = isplus;
            this.j = j;
            this.deltaN = deltaN;
            this.deltaE = -20;
            this.offsetE = offsetE;
        }

        private Parameter(Parameter p) {
            this.isplus = !p.isplus;
            this.j = p.j + (long)(p.deltaN >> 1);
            this.deltaN = p.deltaN;
            this.deltaE = p.deltaE;
            this.offsetE = p.offsetE + (p.deltaE >> 1);
        }

        public static Parameter get(String s) {
            String[] parts;
            if ((s = s.trim()).charAt(0) == 'P') {
                s = s.substring(1);
            }
            if ((parts = s.split("\\D+")).length >= 2) {
                String name = "P" + parts[0] + "_" + parts[1];
                for (Parameter p : Parameter.values()) {
                    if (!p.name().equals(name)) continue;
                    return p;
                }
            }
            throw new IllegalArgumentException("s=" + s + ", parts=" + Arrays.asList(parts));
        }
    }

    public static class Sum
    implements Container<Summation>,
    Iterable<Summation> {
        private static final long ACCURACY_BIT = 50L;
        private final Parameter parameter;
        private final Summation sigma;
        private final Summation[] parts;
        private final Tail tail;

        private <T extends Container<Summation>> Sum(long b, Parameter p, int nParts, List<T> existing) {
            if (b < 0L) {
                throw new IllegalArgumentException("b = " + b + " < 0");
            }
            if (nParts < 1) {
                throw new IllegalArgumentException("nParts = " + nParts + " < 1");
            }
            long i = p.j == 1L && p.offsetE >= 0 ? 1L : 0L;
            long e = b + i * (long)p.deltaE + (long)p.offsetE;
            long n = i * (long)p.deltaN + p.j;
            this.parameter = p;
            this.sigma = new Summation(n, p.deltaN, e, p.deltaE, 0L);
            this.parts = Sum.partition(this.sigma, nParts, existing);
            this.tail = new Tail(n, e);
        }

        private static <T extends Container<Summation>> Summation[] partition(Summation sigma, int nParts, List<T> existing) {
            ArrayList<Summation> parts = new ArrayList<Summation>();
            if (existing == null || existing.isEmpty()) {
                parts.addAll(Arrays.asList(sigma.partition(nParts)));
            } else {
                long stepsPerPart = sigma.getSteps() / (long)nParts;
                List<Summation> remaining = sigma.remainingTerms(existing);
                for (Summation s : remaining) {
                    int n = (int)((s.getSteps() - 1L) / stepsPerPart) + 1;
                    parts.addAll(Arrays.asList(s.partition(n)));
                }
                for (Container c : existing) {
                    parts.add((Summation)c.getElement());
                }
                Collections.sort(parts);
            }
            return parts.toArray(new Summation[parts.size()]);
        }

        public String toString() {
            int n = 0;
            for (Summation s : this.parts) {
                if (s.getValue() != null) continue;
                ++n;
            }
            return this.getClass().getSimpleName() + "{" + this.parameter + ": " + this.sigma + ", remaining=" + n + "}";
        }

        public void setValue(Summation s) {
            if (s.getValue() == null) {
                throw new IllegalArgumentException("s.getValue()\n  sigma=" + this.sigma + "\n  s    =" + s);
            }
            if (!s.contains(this.sigma) || !this.sigma.contains(s)) {
                throw new IllegalArgumentException("!s.contains(sigma) || !sigma.contains(s)\n  sigma=" + this.sigma + "\n  s    =" + s);
            }
            this.sigma.setValue(s.getValue());
        }

        public double getValue() {
            if (this.sigma.getValue() == null) {
                double d = 0.0;
                for (int i = 0; i < this.parts.length; ++i) {
                    d = Modular.addMod(d, this.parts[i].compute());
                }
                this.sigma.setValue(d);
            }
            double s = Modular.addMod(this.sigma.getValue(), this.tail.compute());
            return this.parameter.isplus ? s : -s;
        }

        @Override
        public Summation getElement() {
            if (this.sigma.getValue() == null) {
                int i;
                double d = 0.0;
                for (i = 0; i < this.parts.length && this.parts[i].getValue() != null; ++i) {
                    d = Modular.addMod(d, this.parts[i].getValue());
                }
                if (i == this.parts.length) {
                    this.sigma.setValue(d);
                }
            }
            return this.sigma;
        }

        @Override
        public Iterator<Summation> iterator() {
            return new Iterator<Summation>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < parts.length;
                }

                @Override
                public Summation next() throws NoSuchElementException {
                    if (this.hasNext()) {
                        return parts[this.i++];
                    }
                    throw new NoSuchElementException("Sum's iterator does not have next!");
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private class Tail {
            private long n;
            private long e;

            private Tail(long n, long e) {
                this.n = n;
                this.e = e;
            }

            private double compute() {
                if (this.e > 0L) {
                    long edelta = -Sum.this.sigma.E.delta;
                    long q = this.e / edelta;
                    long r = this.e % edelta;
                    if (r == 0L) {
                        this.e = 0L;
                        this.n += q * Sum.this.sigma.N.delta;
                    } else {
                        this.e = edelta - r;
                        this.n += (q + 1L) * Sum.this.sigma.N.delta;
                    }
                } else if (this.e < 0L) {
                    this.e = -this.e;
                }
                double s = 0.0;
                while (this.e <= 50L && 1L << (int)(50L - this.e) >= this.n) {
                    if ((s += 1.0 / (double)(this.n << (int)this.e)) >= 1.0) {
                        s -= 1.0;
                    }
                    this.n += Sum.this.sigma.N.delta;
                    this.e -= Sum.this.sigma.E.delta;
                }
                return s;
            }
        }
    }
}

