/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class QuasiMonteCarlo
extends Configured
implements Tool {
    static final String DESCRIPTION = "A map/reduce program that estimates Pi using a quasi-Monte Carlo method.";
    private static final String TMP_DIR_PREFIX = QuasiMonteCarlo.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal estimatePi(int numMaps, long numPoints, Path tmpDir, Configuration conf) throws IOException, ClassNotFoundException, InterruptedException {
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName(QuasiMonteCarlo.class.getSimpleName());
        job.setJarByClass(QuasiMonteCarlo.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputKeyClass(BooleanWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(QmcMapper.class);
        job.setReducerClass(QmcReducer.class);
        job.setNumReduceTasks(1);
        job.setSpeculativeExecution(false);
        Path inDir = new Path(tmpDir, "in");
        Path outDir = new Path(tmpDir, "out");
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(tmpDir)) {
            throw new IOException("Tmp directory " + fs.makeQualified(tmpDir) + " already exists.  Please remove it first.");
        }
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Cannot create input directory " + inDir);
        }
        try {
            for (int i = 0; i < numMaps; ++i) {
                Path file = new Path(inDir, "part" + i);
                LongWritable offset = new LongWritable((long)i * numPoints);
                LongWritable size = new LongWritable(numPoints);
                try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);){
                    writer.append((Writable)offset, (Writable)size);
                }
                System.out.println("Wrote input for Map #" + i);
            }
            System.out.println("Starting Job");
            long startTime = Time.monotonicNow();
            job.waitForCompletion(true);
            if (!job.isSuccessful()) {
                System.out.println("Job " + job.getJobID() + " failed!");
                System.exit(1);
            }
            double duration = (double)(Time.monotonicNow() - startTime) / 1000.0;
            System.out.println("Job Finished in " + duration + " seconds");
            Path inFile = new Path(outDir, "reduce-out");
            LongWritable numInside = new LongWritable();
            LongWritable numOutside = new LongWritable();
            try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, inFile, conf);){
                reader.next((Writable)numInside, (Writable)numOutside);
            }
            BigDecimal numTotal = BigDecimal.valueOf(numMaps).multiply(BigDecimal.valueOf(numPoints));
            BigDecimal bigDecimal = BigDecimal.valueOf(4L).setScale(20).multiply(BigDecimal.valueOf(numInside.get())).divide(numTotal, RoundingMode.HALF_UP);
            return bigDecimal;
        }
        finally {
            fs.delete(tmpDir, true);
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + ((Object)((Object)this)).getClass().getName() + " <nMaps> <nSamples>");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 2;
        }
        int nMaps = Integer.parseInt(args[0]);
        long nSamples = Long.parseLong(args[1]);
        long now = System.currentTimeMillis();
        int rand = new Random().nextInt(Integer.MAX_VALUE);
        Path tmpDir = new Path(TMP_DIR_PREFIX + "_" + now + "_" + rand);
        System.out.println("Number of Maps  = " + nMaps);
        System.out.println("Samples per Map = " + nSamples);
        System.out.println("Estimated value of Pi is " + QuasiMonteCarlo.estimatePi(nMaps, nSamples, tmpDir, this.getConf()));
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        System.exit(ToolRunner.run(null, (Tool)new QuasiMonteCarlo(), (String[])argv));
    }

    public static class QmcMapper
    extends Mapper<LongWritable, LongWritable, BooleanWritable, LongWritable> {
        public void map(LongWritable offset, LongWritable size, Mapper.Context context) throws IOException, InterruptedException {
            HaltonSequence haltonsequence = new HaltonSequence(offset.get());
            long numInside = 0L;
            long numOutside = 0L;
            long i = 0L;
            while (i < size.get()) {
                double y;
                double[] point = haltonsequence.nextPoint();
                double x = point[0] - 0.5;
                if (x * x + (y = point[1] - 0.5) * y > 0.25) {
                    ++numOutside;
                } else {
                    ++numInside;
                }
                if (++i % 1000L != 0L) continue;
                context.setStatus("Generated " + i + " samples.");
            }
            context.write((Object)new BooleanWritable(true), (Object)new LongWritable(numInside));
            context.write((Object)new BooleanWritable(false), (Object)new LongWritable(numOutside));
        }
    }

    public static class QmcReducer
    extends Reducer<BooleanWritable, LongWritable, WritableComparable<?>, Writable> {
        private long numInside = 0L;
        private long numOutside = 0L;

        public void reduce(BooleanWritable isInside, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            if (isInside.get()) {
                for (LongWritable val : values) {
                    this.numInside += val.get();
                }
            } else {
                for (LongWritable val : values) {
                    this.numOutside += val.get();
                }
            }
        }

        public void cleanup(Reducer.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            Path outDir = new Path(conf.get("mapreduce.output.fileoutputformat.outputdir"));
            Path outFile = new Path(outDir, "reduce-out");
            FileSystem fileSys = FileSystem.get((Configuration)conf);
            SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fileSys, (Configuration)conf, (Path)outFile, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
            writer.append((Writable)new LongWritable(this.numInside), (Writable)new LongWritable(this.numOutside));
            writer.close();
        }
    }

    private static class HaltonSequence {
        static final int[] P = new int[]{2, 3};
        static final int[] K = new int[]{63, 40};
        private long index;
        private double[] x;
        private double[][] q;
        private int[][] d;

        HaltonSequence(long startindex) {
            int i;
            this.index = startindex;
            this.x = new double[K.length];
            this.q = new double[K.length][];
            this.d = new int[K.length][];
            for (i = 0; i < K.length; ++i) {
                this.q[i] = new double[K[i]];
                this.d[i] = new int[K[i]];
            }
            for (i = 0; i < K.length; ++i) {
                long k = this.index;
                this.x[i] = 0.0;
                for (int j = 0; j < K[i]; ++j) {
                    this.q[i][j] = (j == 0 ? 1.0 : this.q[i][j - 1]) / (double)P[i];
                    this.d[i][j] = (int)(k % (long)P[i]);
                    k = (k - (long)this.d[i][j]) / (long)P[i];
                    int n = i;
                    this.x[n] = this.x[n] + (double)this.d[i][j] * this.q[i][j];
                }
            }
        }

        double[] nextPoint() {
            ++this.index;
            block0: for (int i = 0; i < K.length; ++i) {
                for (int j = 0; j < K[i]; ++j) {
                    int[] nArray = this.d[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    int n2 = i;
                    this.x[n2] = this.x[n2] + this.q[i][j];
                    if (this.d[i][j] < P[i]) continue block0;
                    this.d[i][j] = 0;
                    int n3 = i;
                    this.x[n3] = this.x[n3] - (j == 0 ? 1.0 : this.q[i][j - 1]);
                }
            }
            return this.x;
        }
    }
}

