/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileAsBinaryOutputFormat;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMRSequenceFileAsBinaryOutputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(TestMRSequenceFileAsBinaryOutputFormat.class);
    private static final int RECORDS = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBinary() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        Job job = Job.getInstance((Configuration)conf);
        Path outdir = new Path(System.getProperty("test.build.data", "/tmp"), "outseq");
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        FileOutputFormat.setOutputPath((Job)job, (Path)outdir);
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputKeyClass((Job)job, IntWritable.class);
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputValueClass((Job)job, DoubleWritable.class);
        SequenceFileAsBinaryOutputFormat.setCompressOutput((Job)job, (boolean)true);
        SequenceFileAsBinaryOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        BytesWritable bkey = new BytesWritable();
        BytesWritable bval = new BytesWritable();
        TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
        SequenceFileAsBinaryOutputFormat outputFormat = new SequenceFileAsBinaryOutputFormat();
        OutputCommitter committer = outputFormat.getOutputCommitter(context);
        committer.setupJob((JobContext)job);
        RecordWriter writer = outputFormat.getRecordWriter(context);
        IntWritable iwritable = new IntWritable();
        DoubleWritable dwritable = new DoubleWritable();
        DataOutputBuffer outbuf = new DataOutputBuffer();
        LOG.info("Creating data by SequenceFileAsBinaryOutputFormat");
        try {
            for (int i = 0; i < 10000; ++i) {
                iwritable = new IntWritable(r.nextInt());
                iwritable.write((DataOutput)outbuf);
                bkey.set(outbuf.getData(), 0, outbuf.getLength());
                outbuf.reset();
                dwritable = new DoubleWritable(r.nextDouble());
                dwritable.write((DataOutput)outbuf);
                bval.set(outbuf.getData(), 0, outbuf.getLength());
                outbuf.reset();
                writer.write((Object)bkey, (Object)bval);
            }
        }
        finally {
            writer.close(context);
        }
        committer.commitTask(context);
        committer.commitJob((JobContext)job);
        SequenceFileInputFormat iformat = new SequenceFileInputFormat();
        int count = 0;
        r.setSeed(seed);
        SequenceFileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{outdir});
        LOG.info("Reading data by SequenceFileInputFormat");
        for (InputSplit split : iformat.getSplits((JobContext)job)) {
            RecordReader reader = iformat.createRecordReader(split, context);
            MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
            reader.initialize(split, (TaskAttemptContext)mcontext);
            try {
                while (reader.nextKeyValue()) {
                    int sourceInt = r.nextInt();
                    double sourceDouble = r.nextDouble();
                    iwritable = (IntWritable)reader.getCurrentKey();
                    dwritable = (DoubleWritable)reader.getCurrentValue();
                    org.junit.jupiter.api.Assertions.assertEquals((int)sourceInt, (int)iwritable.get(), (String)("Keys don't match: *" + iwritable.get() + ":" + sourceInt + "*"));
                    ((AbstractDoubleAssert)Assertions.assertThat((double)dwritable.get()).withFailMessage("Vals don't match: *" + dwritable.get() + ":" + sourceDouble + "*", new Object[0])).isEqualTo(sourceDouble);
                    ++count;
                }
            }
            finally {
                reader.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)10000, (int)count, (String)"Some records not found");
    }

    @Test
    public void testSequenceOutputClassDefaultsToMapRedOutputClass() throws IOException {
        Job job = Job.getInstance();
        job.setOutputKeyClass(FloatWritable.class);
        job.setOutputValueClass(BooleanWritable.class);
        org.junit.jupiter.api.Assertions.assertEquals(FloatWritable.class, (Object)SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass((JobContext)job), (String)"SequenceFileOutputKeyClass should default to ouputKeyClass");
        org.junit.jupiter.api.Assertions.assertEquals(BooleanWritable.class, (Object)SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass((JobContext)job), (String)"SequenceFileOutputValueClass should default to ouputValueClass");
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputKeyClass((Job)job, IntWritable.class);
        SequenceFileAsBinaryOutputFormat.setSequenceFileOutputValueClass((Job)job, DoubleWritable.class);
        org.junit.jupiter.api.Assertions.assertEquals(IntWritable.class, (Object)SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass((JobContext)job), (String)"SequenceFileOutputKeyClass not updated");
        org.junit.jupiter.api.Assertions.assertEquals(DoubleWritable.class, (Object)SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass((JobContext)job), (String)"SequenceFileOutputValueClass not updated");
    }

    @Test
    public void testcheckOutputSpecsForbidRecordCompression() throws IOException {
        Job job = Job.getInstance();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job.getConfiguration());
        Path outputdir = new Path(System.getProperty("test.build.data", "/tmp") + "/output");
        fs.delete(outputdir, true);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputdir);
        SequenceFileAsBinaryOutputFormat.setCompressOutput((Job)job, (boolean)true);
        SequenceFileAsBinaryOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        try {
            new SequenceFileAsBinaryOutputFormat().checkOutputSpecs((JobContext)job);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)("Block compression should be allowed for SequenceFileAsBinaryOutputFormat:Caught " + e.getClass().getName()));
        }
        SequenceFileAsBinaryOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD);
        try {
            new SequenceFileAsBinaryOutputFormat().checkOutputSpecs((JobContext)job);
            org.junit.jupiter.api.Assertions.fail((String)"Record compression should not be allowed for SequenceFileAsBinaryOutputFormat");
        }
        catch (InvalidJobConfException e) {
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)("Expected " + InvalidJobConfException.class.getName() + "but caught " + e.getClass().getName()));
        }
    }
}

