/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.join.CompositeInputFormat;
import org.apache.hadoop.mapreduce.lib.join.TupleWritable;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestJoinProperties {
    private static MiniDFSCluster cluster = null;
    static final int SOURCES = 3;
    static final int ITEMS = 16;
    static int[][] source = new int[3][];
    static Path[] src;
    static Path base;

    @BeforeAll
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        base = cluster.getFileSystem().makeQualified(new Path("/nested"));
        src = TestJoinProperties.generateSources(conf);
    }

    @AfterAll
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private static SequenceFile.Writer[] createWriters(Path testdir, Configuration conf, int srcs, Path[] src) throws IOException {
        for (int i = 0; i < srcs; ++i) {
            src[i] = new Path(testdir, Integer.toString(i + 10, 36));
        }
        SequenceFile.Writer[] out = new SequenceFile.Writer[srcs];
        for (int i = 0; i < srcs - 1; ++i) {
            out[i] = new SequenceFile.Writer(testdir.getFileSystem(conf), conf, src[i], IntWritable.class, IntWritable.class);
        }
        out[srcs - 1] = new SequenceFile.Writer(testdir.getFileSystem(conf), conf, src[srcs - 1], IntWritable.class, LongWritable.class);
        return out;
    }

    private static String stringify(IntWritable key, Writable val) {
        StringBuilder sb = new StringBuilder();
        sb.append("(" + key);
        sb.append("," + val + ")");
        return sb.toString();
    }

    private static Path[] generateSources(Configuration conf) throws IOException {
        for (int i = 0; i < 3; ++i) {
            TestJoinProperties.source[i] = new int[16];
            for (int j = 0; j < 16; ++j) {
                TestJoinProperties.source[i][j] = (i + 2) * (j + 1);
            }
        }
        Path[] src = new Path[3];
        SequenceFile.Writer[] out = TestJoinProperties.createWriters(base, conf, 3, src);
        IntWritable k = new IntWritable();
        for (int i = 0; i < 3; ++i) {
            IntWritable v;
            if (i != 2) {
                v = new IntWritable();
                v.set(i);
            } else {
                v = new LongWritable();
                ((LongWritable)v).set((long)i);
            }
            for (int j = 0; j < 16; ++j) {
                k.set(source[i][j]);
                out[i].append((Writable)k, (Writable)v);
            }
            out[i].close();
        }
        return src;
    }

    private String A() {
        return CompositeInputFormat.compose(SequenceFileInputFormat.class, (String)src[0].toString());
    }

    private String B() {
        return CompositeInputFormat.compose(SequenceFileInputFormat.class, (String)src[1].toString());
    }

    private String C() {
        return CompositeInputFormat.compose(SequenceFileInputFormat.class, (String)src[2].toString());
    }

    private String constructExpr1(String op) {
        StringBuilder sb = new StringBuilder();
        sb.append(op + "(" + op + "(");
        sb.append(this.A());
        sb.append(",");
        sb.append(this.B());
        sb.append("),");
        sb.append(this.C());
        sb.append(")");
        return sb.toString();
    }

    private String constructExpr2(String op) {
        StringBuilder sb = new StringBuilder();
        sb.append(op + "(");
        sb.append(this.A());
        sb.append(",");
        sb.append(op + "(");
        sb.append(this.B());
        sb.append(",");
        sb.append(this.C());
        sb.append("))");
        return sb.toString();
    }

    private String constructExpr3(String op) {
        StringBuilder sb = new StringBuilder();
        sb.append(op + "(");
        sb.append(this.A());
        sb.append(",");
        sb.append(this.B());
        sb.append(",");
        sb.append(this.C());
        sb.append(")");
        return sb.toString();
    }

    private String constructExpr4() {
        StringBuilder sb = new StringBuilder();
        sb.append("override(inner(");
        sb.append(this.A());
        sb.append(",");
        sb.append(this.B());
        sb.append("),");
        sb.append(this.A());
        sb.append(")");
        return sb.toString();
    }

    private void validateKeyValue(WritableComparable<?> k, Writable v, int tupleSize, boolean firstTuple, boolean secondTuple, TestType ttype) throws IOException {
        System.out.println("out k:" + k + " v:" + v);
        if (ttype.equals((Object)TestType.OUTER_ASSOCIATIVITY)) {
            this.validateOuterKeyValue((IntWritable)k, (TupleWritable)v, tupleSize, firstTuple, secondTuple);
        } else if (ttype.equals((Object)TestType.INNER_ASSOCIATIVITY)) {
            this.validateInnerKeyValue((IntWritable)k, (TupleWritable)v, tupleSize, firstTuple, secondTuple);
        }
        if (ttype.equals((Object)TestType.INNER_IDENTITY)) {
            this.validateKeyValue_INNER_IDENTITY((IntWritable)k, (IntWritable)v);
        }
    }

    private void testExpr1(Configuration conf, String op, TestType ttype, int expectedCount) throws Exception {
        String joinExpr = this.constructExpr1(op);
        conf.set("mapreduce.join.expr", joinExpr);
        int count = this.testFormat(conf, 2, true, false, ttype);
        Assertions.assertTrue((count == expectedCount ? 1 : 0) != 0, (String)"not all keys present");
    }

    private void testExpr2(Configuration conf, String op, TestType ttype, int expectedCount) throws Exception {
        String joinExpr = this.constructExpr2(op);
        conf.set("mapreduce.join.expr", joinExpr);
        int count = this.testFormat(conf, 2, false, true, ttype);
        Assertions.assertTrue((count == expectedCount ? 1 : 0) != 0, (String)"not all keys present");
    }

    private void testExpr3(Configuration conf, String op, TestType ttype, int expectedCount) throws Exception {
        String joinExpr = this.constructExpr3(op);
        conf.set("mapreduce.join.expr", joinExpr);
        int count = this.testFormat(conf, 3, false, false, ttype);
        Assertions.assertTrue((count == expectedCount ? 1 : 0) != 0, (String)"not all keys present");
    }

    private void testExpr4(Configuration conf) throws Exception {
        String joinExpr = this.constructExpr4();
        conf.set("mapreduce.join.expr", joinExpr);
        int count = this.testFormat(conf, 0, false, false, TestType.INNER_IDENTITY);
        Assertions.assertTrue((count == 16 ? 1 : 0) != 0, (String)"not all keys present");
    }

    @Test
    public void testOuterAssociativity() throws Exception {
        Configuration conf = new Configuration();
        this.testExpr1(conf, "outer", TestType.OUTER_ASSOCIATIVITY, 33);
        this.testExpr2(conf, "outer", TestType.OUTER_ASSOCIATIVITY, 33);
        this.testExpr3(conf, "outer", TestType.OUTER_ASSOCIATIVITY, 33);
    }

    @Test
    public void testInnerAssociativity() throws Exception {
        Configuration conf = new Configuration();
        this.testExpr1(conf, "inner", TestType.INNER_ASSOCIATIVITY, 2);
        this.testExpr2(conf, "inner", TestType.INNER_ASSOCIATIVITY, 2);
        this.testExpr3(conf, "inner", TestType.INNER_ASSOCIATIVITY, 2);
    }

    @Test
    public void testIdentity() throws Exception {
        Configuration conf = new Configuration();
        this.testExpr4(conf);
    }

    private void validateOuterKeyValue(IntWritable k, TupleWritable v, int tupleSize, boolean firstTuple, boolean secondTuple) {
        String kvstr = "Unexpected tuple: " + TestJoinProperties.stringify(k, (Writable)v);
        Assertions.assertTrue((v.size() == tupleSize ? 1 : 0) != 0, (String)kvstr);
        int key = k.get();
        IntWritable val0 = null;
        IntWritable val1 = null;
        LongWritable val2 = null;
        if (firstTuple) {
            TupleWritable v0 = (TupleWritable)v.get(0);
            if (key % 2 == 0 && key / 2 <= 16) {
                val0 = (IntWritable)v0.get(0);
            } else {
                Assertions.assertFalse((boolean)v0.has(0), (String)kvstr);
            }
            if (key % 3 == 0 && key / 3 <= 16) {
                val1 = (IntWritable)v0.get(1);
            } else {
                Assertions.assertFalse((boolean)v0.has(1), (String)kvstr);
            }
            if (key % 4 == 0 && key / 4 <= 16) {
                val2 = (LongWritable)v.get(1);
            } else {
                Assertions.assertFalse((boolean)v.has(2), (String)kvstr);
            }
        } else if (secondTuple) {
            if (key % 2 == 0 && key / 2 <= 16) {
                val0 = (IntWritable)v.get(0);
            } else {
                Assertions.assertFalse((boolean)v.has(0), (String)kvstr);
            }
            TupleWritable v1 = (TupleWritable)v.get(1);
            if (key % 3 == 0 && key / 3 <= 16) {
                val1 = (IntWritable)v1.get(0);
            } else {
                Assertions.assertFalse((boolean)v1.has(0), (String)kvstr);
            }
            if (key % 4 == 0 && key / 4 <= 16) {
                val2 = (LongWritable)v1.get(1);
            } else {
                Assertions.assertFalse((boolean)v1.has(1), (String)kvstr);
            }
        } else {
            if (key % 2 == 0 && key / 2 <= 16) {
                val0 = (IntWritable)v.get(0);
            } else {
                Assertions.assertFalse((boolean)v.has(0), (String)kvstr);
            }
            if (key % 3 == 0 && key / 3 <= 16) {
                val1 = (IntWritable)v.get(1);
            } else {
                Assertions.assertFalse((boolean)v.has(1), (String)kvstr);
            }
            if (key % 4 == 0 && key / 4 <= 16) {
                val2 = (LongWritable)v.get(2);
            } else {
                Assertions.assertFalse((boolean)v.has(2), (String)kvstr);
            }
        }
        if (val0 != null) {
            Assertions.assertTrue((val0.get() == 0 ? 1 : 0) != 0, (String)kvstr);
        }
        if (val1 != null) {
            Assertions.assertTrue((val1.get() == 1 ? 1 : 0) != 0, (String)kvstr);
        }
        if (val2 != null) {
            Assertions.assertTrue((val2.get() == 2L ? 1 : 0) != 0, (String)kvstr);
        }
    }

    private void validateInnerKeyValue(IntWritable k, TupleWritable v, int tupleSize, boolean firstTuple, boolean secondTuple) {
        String kvstr = "Unexpected tuple: " + TestJoinProperties.stringify(k, (Writable)v);
        Assertions.assertTrue((v.size() == tupleSize ? 1 : 0) != 0, (String)kvstr);
        int key = k.get();
        IntWritable val0 = null;
        IntWritable val1 = null;
        LongWritable val2 = null;
        Assertions.assertTrue((key % 2 == 0 && key / 2 <= 16 ? 1 : 0) != 0, (String)kvstr);
        Assertions.assertTrue((key % 3 == 0 && key / 3 <= 16 ? 1 : 0) != 0, (String)kvstr);
        Assertions.assertTrue((key % 4 == 0 && key / 4 <= 16 ? 1 : 0) != 0, (String)kvstr);
        if (firstTuple) {
            TupleWritable v0 = (TupleWritable)v.get(0);
            val0 = (IntWritable)v0.get(0);
            val1 = (IntWritable)v0.get(1);
            val2 = (LongWritable)v.get(1);
        } else if (secondTuple) {
            val0 = (IntWritable)v.get(0);
            TupleWritable v1 = (TupleWritable)v.get(1);
            val1 = (IntWritable)v1.get(0);
            val2 = (LongWritable)v1.get(1);
        } else {
            val0 = (IntWritable)v.get(0);
            val1 = (IntWritable)v.get(1);
            val2 = (LongWritable)v.get(2);
        }
        Assertions.assertTrue((val0.get() == 0 ? 1 : 0) != 0, (String)kvstr);
        Assertions.assertTrue((val1.get() == 1 ? 1 : 0) != 0, (String)kvstr);
        Assertions.assertTrue((val2.get() == 2L ? 1 : 0) != 0, (String)kvstr);
    }

    private void validateKeyValue_INNER_IDENTITY(IntWritable k, IntWritable v) {
        String kvstr = "Unexpected tuple: " + TestJoinProperties.stringify(k, (Writable)v);
        int key = k.get();
        Assertions.assertTrue((key % 2 == 0 && key / 2 <= 16 ? 1 : 0) != 0, (String)kvstr);
        Assertions.assertTrue((v.get() == 0 ? 1 : 0) != 0, (String)kvstr);
    }

    public int testFormat(Configuration conf, int tupleSize, boolean firstTuple, boolean secondTuple, TestType ttype) throws Exception {
        Job job = Job.getInstance((Configuration)conf);
        CompositeInputFormat format = new CompositeInputFormat();
        int count = 0;
        for (InputSplit split : format.getSplits((JobContext)job)) {
            TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(conf);
            RecordReader reader = format.createRecordReader(split, context);
            MapContextImpl mcontext = new MapContextImpl(conf, context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
            reader.initialize(split, (TaskAttemptContext)mcontext);
            WritableComparable key = null;
            Writable value = null;
            while (reader.nextKeyValue()) {
                key = (WritableComparable)reader.getCurrentKey();
                value = (Writable)reader.getCurrentValue();
                this.validateKeyValue(key, value, tupleSize, firstTuple, secondTuple, ttype);
                ++count;
            }
        }
        return count;
    }

    static enum TestType {
        OUTER_ASSOCIATIVITY,
        INNER_IDENTITY,
        INNER_ASSOCIATIVITY;

    }
}

