/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.util.BitSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileAsTextInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileAsTextRecordReader;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMRSequenceFileAsTextInputFormat {
    private static int MAX_LENGTH = 10000;
    private static Configuration conf = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormat() throws Exception {
        Job job = Job.getInstance((Configuration)conf);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path file = new Path(dir, "test.seq");
        int seed = new Random().nextInt();
        Random random = new Random(seed);
        fs.delete(dir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{dir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, IntWritable.class, LongWritable.class);){
                for (int i = 0; i < length; ++i) {
                    IntWritable key = new IntWritable(i);
                    LongWritable value = new LongWritable((long)(10 * i));
                    writer.append((Writable)key, (Writable)value);
                }
            }
            TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
            SequenceFileAsTextInputFormat format = new SequenceFileAsTextInputFormat();
            for (int i = 0; i < 3; ++i) {
                BitSet bits = new BitSet(length);
                int numSplits = random.nextInt(MAX_LENGTH / 5120) + 1;
                FileInputFormat.setMaxInputSplitSize((Job)job, (long)(fs.getFileStatus(file).getLen() / (long)numSplits));
                for (InputSplit split : format.getSplits((JobContext)job)) {
                    RecordReader reader = format.createRecordReader(split, context);
                    MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
                    reader.initialize(split, (TaskAttemptContext)mcontext);
                    Class<?> readerClass = reader.getClass();
                    Assertions.assertEquals(SequenceFileAsTextRecordReader.class, readerClass, (String)"reader class is SequenceFileAsTextRecordReader.");
                    try {
                        int count = 0;
                        while (reader.nextKeyValue()) {
                            Text key = (Text)reader.getCurrentKey();
                            int keyInt = Integer.parseInt(key.toString());
                            Assertions.assertFalse((boolean)bits.get(keyInt), (String)"Key in multiple partitions.");
                            bits.set(keyInt);
                            ++count;
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                Assertions.assertEquals((int)length, (int)bits.cardinality(), (String)"Some keys in no partition.");
            }
        }
    }
}

