/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestMRCJCFileInputFormat {
    @Test
    public void testAddInputPath() throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///abc/");
        Job j = Job.getInstance((Configuration)conf);
        FileSystem defaultfs = FileSystem.get((Configuration)conf);
        System.out.println("defaultfs.getUri() = " + defaultfs.getUri());
        Path original = new Path("file:/foo");
        System.out.println("original = " + original);
        FileInputFormat.addInputPath((Job)j, (Path)original);
        Path[] results = FileInputFormat.getInputPaths((JobContext)j);
        System.out.println("results = " + Arrays.asList(results));
        Assertions.assertEquals((int)1, (int)results.length);
        Assertions.assertEquals((Object)original, (Object)results[0]);
        original = new Path("file:/bar");
        System.out.println("original = " + original);
        FileInputFormat.setInputPaths((Job)j, (Path[])new Path[]{original});
        results = FileInputFormat.getInputPaths((JobContext)j);
        System.out.println("results = " + Arrays.asList(results));
        Assertions.assertEquals((int)1, (int)results.length);
        Assertions.assertEquals((Object)original, (Object)results[0]);
    }

    @Test
    public void testNumInputFiles() throws Exception {
        Configuration conf = (Configuration)Mockito.spy((Object)new Configuration());
        Job mockedJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockedJob.getConfiguration()).thenReturn((Object)conf);
        FileStatus stat = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)stat.getLen()).thenReturn((Object)0L);
        TextInputFormat ispy = (TextInputFormat)Mockito.spy((Object)new TextInputFormat());
        ((TextInputFormat)Mockito.doReturn(Arrays.asList(stat)).when((Object)ispy)).listStatus((JobContext)mockedJob);
        ispy.getSplits((JobContext)mockedJob);
        ((Configuration)Mockito.verify((Object)conf)).setLong("mapreduce.input.fileinputformat.numinputfiles", 1L);
    }

    @Test
    public void testLastInputSplitAtSplitBoundary() throws Exception {
        FileInputFormatForTest fif = new FileInputFormatForTest(0x40000000L, 0x8000000L);
        Configuration conf = new Configuration();
        JobContext jobContext = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)jobContext.getConfiguration()).thenReturn((Object)conf);
        List splits = fif.getSplits(jobContext);
        Assertions.assertEquals((int)8, (int)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            Assertions.assertEquals((Object)("host" + i), (Object)split.getLocations()[0]);
        }
    }

    @Test
    public void testLastInputSplitExceedingSplitBoundary() throws Exception {
        FileInputFormatForTest fif = new FileInputFormatForTest(0x40300000L, 0x8000000L);
        Configuration conf = new Configuration();
        JobContext jobContext = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)jobContext.getConfiguration()).thenReturn((Object)conf);
        List splits = fif.getSplits(jobContext);
        Assertions.assertEquals((int)8, (int)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            Assertions.assertEquals((Object)("host" + i), (Object)split.getLocations()[0]);
        }
    }

    @Test
    public void testLastInputSplitSingleSplit() throws Exception {
        FileInputFormatForTest fif = new FileInputFormatForTest(0x6400000L, 0x8000000L);
        Configuration conf = new Configuration();
        JobContext jobContext = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)jobContext.getConfiguration()).thenReturn((Object)conf);
        List splits = fif.getSplits(jobContext);
        Assertions.assertEquals((int)1, (int)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            Assertions.assertEquals((Object)("host" + i), (Object)split.getLocations()[0]);
        }
    }

    @Test
    public void testForEmptyFile() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        Path file = new Path("test/file");
        FSDataOutputStream out = fileSys.create(file, true, conf.getInt("io.file.buffer.size", 4096), (short)1, 1024L);
        out.write(new byte[0]);
        out.close();
        DummyInputFormat inFormat = new DummyInputFormat();
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (String)"test");
        List splits = inFormat.getSplits((JobContext)job);
        Assertions.assertEquals((int)1, (int)splits.size());
        FileSplit fileSplit = (FileSplit)splits.get(0);
        Assertions.assertEquals((int)0, (int)fileSplit.getLocations().length);
        Assertions.assertEquals((Object)file.getName(), (Object)fileSplit.getPath().getName());
        Assertions.assertEquals((long)0L, (long)fileSplit.getStart());
        Assertions.assertEquals((long)0L, (long)fileSplit.getLength());
        fileSys.delete(file.getParent(), true);
    }

    private class FileInputFormatForTest<K, V>
    extends FileInputFormat<K, V> {
        long splitSize;
        long length;

        FileInputFormatForTest(long length, long splitSize) {
            this.length = length;
            this.splitSize = splitSize;
        }

        public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            return null;
        }

        protected List<FileStatus> listStatus(JobContext job) throws IOException {
            FileStatus mockFileStatus = (FileStatus)Mockito.mock(FileStatus.class);
            Mockito.when((Object)mockFileStatus.getBlockSize()).thenReturn((Object)this.splitSize);
            Path mockPath = (Path)Mockito.mock(Path.class);
            FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
            BlockLocation[] blockLocations = this.mockBlockLocations(this.length, this.splitSize);
            Mockito.when((Object)mockFs.getFileBlockLocations(mockFileStatus, 0L, this.length)).thenReturn((Object)blockLocations);
            Mockito.when((Object)mockPath.getFileSystem((Configuration)Mockito.any(Configuration.class))).thenReturn((Object)mockFs);
            Mockito.when((Object)mockFileStatus.getPath()).thenReturn((Object)mockPath);
            Mockito.when((Object)mockFileStatus.getLen()).thenReturn((Object)this.length);
            ArrayList<FileStatus> list = new ArrayList<FileStatus>();
            list.add(mockFileStatus);
            return list;
        }

        protected long computeSplitSize(long blockSize, long minSize, long maxSize) {
            return this.splitSize;
        }

        private BlockLocation[] mockBlockLocations(long size, long splitSize) {
            int numLocations = (int)(size / splitSize);
            if (size % splitSize != 0L) {
                ++numLocations;
            }
            BlockLocation[] blockLocations = new BlockLocation[numLocations];
            for (int i = 0; i < numLocations; ++i) {
                String[] names = new String[]{"b" + i};
                String[] hosts = new String[]{"host" + i};
                blockLocations[i] = new BlockLocation(names, hosts, (long)i * splitSize, Math.min(splitSize, size - splitSize * (long)i));
            }
            return blockLocations;
        }
    }

    private class DummyInputFormat
    extends FileInputFormat<Text, Text> {
        private DummyInputFormat() {
        }

        public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return null;
        }
    }
}

