/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.chain;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMapReduceChain
extends HadoopTestCase {
    private static String localPathRoot = System.getProperty("test.build.data", "/tmp");
    private static Path flagDir = new Path(localPathRoot, "testing/chain/flags");

    private static void cleanFlags(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(flagDir, true);
        fs.mkdirs(flagDir);
    }

    private static void writeFlag(Configuration conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (TestMapReduceChain.getFlag(conf, flag)) {
            Assertions.fail((String)("Flag " + flag + " already exists"));
        }
        FSDataOutputStream file = fs.create(new Path(flagDir, flag));
        file.close();
    }

    private static boolean getFlag(Configuration conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return fs.exists(new Path(flagDir, flag));
    }

    public TestMapReduceChain() throws IOException {
        super(1, 4, 1, 1);
    }

    @Test
    public void testChain() throws Exception {
        Path inDir = new Path(localPathRoot, "testing/chain/input");
        Path outDir = new Path(localPathRoot, "testing/chain/output");
        String input = "1\n2\n";
        String expectedOutput = "0\t1ABCRDEF\n2\t2ABCRDEF\n";
        JobConf conf = this.createJobConf();
        TestMapReduceChain.cleanFlags((Configuration)conf);
        conf.set("a", "X");
        Job job = MapReduceTestUtil.createJob((Configuration)conf, inDir, outDir, 1, 1, input);
        job.setJobName("chain");
        Configuration mapAConf = new Configuration(false);
        mapAConf.set("a", "A");
        ChainMapper.addMapper((Job)job, AMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (Configuration)mapAConf);
        ChainMapper.addMapper((Job)job, BMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        ChainMapper.addMapper((Job)job, CMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        Configuration reduceConf = new Configuration(false);
        reduceConf.set("a", "C");
        ChainReducer.setReducer((Job)job, RReduce.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (Configuration)reduceConf);
        ChainReducer.addMapper((Job)job, DMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        Configuration mapEConf = new Configuration(false);
        mapEConf.set("a", "E");
        ChainReducer.addMapper((Job)job, EMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (Configuration)mapEConf);
        ChainReducer.addMapper((Job)job, FMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        job.waitForCompletion(true);
        Assertions.assertTrue((boolean)job.isSuccessful(), (String)"Job failed");
        String str = "flag not set";
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.A"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.B"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.C"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "reduce.setup.R"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.D"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.E"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.F"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.A.value.1"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.A.value.2"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.B.value.1A"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.B.value.2A"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.C.value.1AB"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.C.value.2AB"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "reduce.R.value.1ABC"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "reduce.R.value.2ABC"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.D.value.1ABCR"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.D.value.2ABCR"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.E.value.1ABCRD"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.E.value.2ABCRD"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.F.value.1ABCRDE"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.F.value.2ABCRDE"), (String)str);
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.A"));
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.B"));
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.C"));
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "reduce.cleanup.R"));
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.D"));
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.E"));
        Assertions.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.F"));
        Assertions.assertEquals((Object)expectedOutput, (Object)MapReduceTestUtil.readOutput(outDir, (Configuration)conf), (String)"Outputs doesn't match");
    }

    public static class IDReduce
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        private String name;
        private String prop;

        public IDReduce(String name, String prop) {
            this.name = name;
            this.prop = prop;
        }

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            Assertions.assertEquals((Object)this.prop, (Object)conf.get("a"));
            TestMapReduceChain.writeFlag(conf, "reduce.setup." + this.name);
        }

        public void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            for (Text value : values) {
                TestMapReduceChain.writeFlag(context.getConfiguration(), "reduce." + this.name + ".value." + value);
                context.write((Object)key, (Object)new Text(value + this.name));
            }
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            TestMapReduceChain.writeFlag(context.getConfiguration(), "reduce.cleanup." + this.name);
        }
    }

    public static class IDMap
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        private String name;
        private String prop;

        public IDMap(String name, String prop) {
            this.name = name;
            this.prop = prop;
        }

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            Assertions.assertEquals((Object)this.prop, (Object)conf.get("a"));
            TestMapReduceChain.writeFlag(conf, "map.setup." + this.name);
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            TestMapReduceChain.writeFlag(context.getConfiguration(), "map." + this.name + ".value." + value);
            context.write((Object)key, (Object)new Text(value + this.name));
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            TestMapReduceChain.writeFlag(context.getConfiguration(), "map.cleanup." + this.name);
        }
    }

    public static class FMap
    extends IDMap {
        public FMap() {
            super("F", "X");
        }
    }

    public static class EMap
    extends IDMap {
        public EMap() {
            super("E", "E");
        }
    }

    public static class DMap
    extends IDMap {
        public DMap() {
            super("D", "X");
        }
    }

    public static class RReduce
    extends IDReduce {
        public RReduce() {
            super("R", "C");
        }
    }

    public static class CMap
    extends IDMap {
        public CMap() {
            super("C", "X");
        }
    }

    public static class BMap
    extends IDMap {
        public BMap() {
            super("B", "X");
        }
    }

    public static class AMap
    extends IDMap {
        public AMap() {
            super("A", "A");
        }
    }
}

