/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.filecache;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestURIFragments {
    @Test
    public void testURIs() throws URISyntaxException {
        Assertions.assertTrue((boolean)DistributedCache.checkURIs(null, null));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile.txt")}, null));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs(null, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive.txt")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file"), new URI("file://foo/bar/myCacheFile2.txt")}, null));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs(null, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt"), new URI("file://foo/bar/myCacheArchive2.txt#archive")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile.txt")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive.txt")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file"), new URI("file://foo/bar/myCacheFile2.txt#file")}, null));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs(null, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#archive"), new URI("file://foo/bar/myCacheArchive2.txt#archive")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile.txt#cache")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive.txt#cache")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file1"), new URI("file://foo/bar/myCacheFile2.txt#file2")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#archive"), new URI("file://foo/bar/myCacheArchive2.txt#archive")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file"), new URI("file://foo/bar/myCacheFile2.txt#file")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#archive1"), new URI("file://foo/bar/myCacheArchive2.txt#archive2")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file1"), new URI("file://foo/bar/myCacheFile2.txt#cache")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#cache"), new URI("file://foo/bar/myCacheArchive2.txt#archive2")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file"), new URI("file://foo/bar/myCacheFile2.txt#FILE")}, null));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs(null, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#archive"), new URI("file://foo/bar/myCacheArchive2.txt#ARCHIVE")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile.txt#cache")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive.txt#CACHE")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file1"), new URI("file://foo/bar/myCacheFile2.txt#file2")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#ARCHIVE"), new URI("file://foo/bar/myCacheArchive2.txt#archive")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#FILE"), new URI("file://foo/bar/myCacheFile2.txt#file")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#archive1"), new URI("file://foo/bar/myCacheArchive2.txt#archive2")}));
        Assertions.assertFalse((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file1"), new URI("file://foo/bar/myCacheFile2.txt#CACHE")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#cache"), new URI("file://foo/bar/myCacheArchive2.txt#archive2")}));
        Assertions.assertTrue((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file1"), new URI("file://foo/bar/myCacheFile2.txt#file2")}, null));
        Assertions.assertTrue((boolean)DistributedCache.checkURIs(null, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#archive1"), new URI("file://foo/bar/myCacheArchive2.txt#archive2")}));
        Assertions.assertTrue((boolean)DistributedCache.checkURIs((URI[])new URI[]{new URI("file://foo/bar/myCacheFile1.txt#file1"), new URI("file://foo/bar/myCacheFile2.txt#file2")}, (URI[])new URI[]{new URI("file://foo/bar/myCacheArchive1.txt#archive1"), new URI("file://foo/bar/myCacheArchive2.txt#archive2")}));
    }
}

