/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public class TestNoJobSetupCleanup
extends HadoopTestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private final Path inDir = new Path(TEST_ROOT_DIR, "./wc/input");
    private final Path outDir = new Path(TEST_ROOT_DIR, "./wc/output");

    public TestNoJobSetupCleanup() throws IOException {
        super(2, 4, 2, 2);
    }

    private Job submitAndValidateJob(Configuration conf, int numMaps, int numReds) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = MapReduceTestUtil.createJob(conf, this.inDir, this.outDir, numMaps, numReds);
        job.setJobSetupCleanupNeeded(false);
        job.setOutputFormatClass(MyOutputFormat.class);
        job.waitForCompletion(true);
        Assertions.assertTrue((boolean)job.isSuccessful());
        Assertions.assertTrue((job.getTaskReports(TaskType.JOB_SETUP).length == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((job.getTaskReports(TaskType.JOB_CLEANUP).length == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((job.getTaskReports(TaskType.MAP).length == numMaps ? 1 : 0) != 0);
        Assertions.assertTrue((job.getTaskReports(TaskType.REDUCE).length == numReds ? 1 : 0) != 0);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assertions.assertTrue((boolean)fs.exists(this.outDir), (String)"Job output directory doesn't exit!");
        String tempWorkingPathStr = this.outDir + "/" + "_temporary" + "/" + "0";
        Path tempWorkingPath = new Path(tempWorkingPathStr);
        FileStatus[] list = fs.listStatus(tempWorkingPath, (PathFilter)new OutputFilter());
        int numPartFiles = numReds == 0 ? numMaps : numReds;
        Assertions.assertTrue((list.length == numPartFiles ? 1 : 0) != 0, (String)("Number of part-files is " + list.length + " and not " + numPartFiles));
        return job;
    }

    @Test
    public void testNoJobSetupCleanup() throws Exception {
        try {
            JobConf conf = this.createJobConf();
            this.submitAndValidateJob((Configuration)conf, 1, 1);
            this.submitAndValidateJob((Configuration)conf, 1, 0);
            this.submitAndValidateJob((Configuration)conf, 0, 0);
            this.submitAndValidateJob((Configuration)conf, 0, 1);
        }
        finally {
            this.tearDown();
        }
    }

    private static class OutputFilter
    implements PathFilter {
        private OutputFilter() {
        }

        public boolean accept(Path path) {
            return !path.getName().startsWith("_");
        }
    }

    public static class MyOutputFormat
    extends TextOutputFormat {
        public void checkOutputSpecs(JobContext job) throws FileAlreadyExistsException, IOException {
            super.checkOutputSpecs(job);
            TaskAttemptID tid = new TaskAttemptID("jt", 1, TaskType.JOB_SETUP, 0, 0);
            this.getOutputCommitter((TaskAttemptContext)new TaskAttemptContextImpl(job.getConfiguration(), tid)).setupJob(job);
        }
    }
}

