/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapreduce.LargeSorter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLargeSort {
    MiniMRClientCluster cluster;

    @BeforeEach
    public void setup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        this.cluster = MiniMRClientClusterFactory.create(this.getClass(), 2, (Configuration)conf);
        this.cluster.start();
    }

    @AfterEach
    public void cleanup() throws IOException {
        if (this.cluster != null) {
            this.cluster.stop();
            this.cluster = null;
        }
    }

    @Test
    public void testLargeSort() throws Exception {
        int[] ioSortMbs;
        String[] args = new String[]{};
        for (int ioSortMb : ioSortMbs = new int[]{128, 256, 1536}) {
            Configuration conf = new Configuration(this.cluster.getConfig());
            conf.setInt("mapreduce.map.memory.mb", 2048);
            conf.setInt("mapreduce.task.io.sort.mb", ioSortMb);
            conf.setInt("mapreduce.large-sorter.map-tasks", 1);
            conf.setInt("mapreduce.large-sorter.mbs-per-map", ioSortMb);
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new LargeSorter(), (String[])args), (String)("Large sort failed for " + ioSortMb));
        }
    }
}

